/// <reference types="react" />
import { DocumentRegistry } from '@jupyterlab/docregistry';
import { CommandRegistry } from '@lumino/commands';
import { IPullRequestGroup } from '../../tokens';
/**
 * PullRequestBrowser properties
 */
export interface IBrowserProps {
    /**
     * Jupyter Front End Commands Registry
     */
    commands: CommandRegistry;
    /**
     * The document registry
     */
    docRegistry: DocumentRegistry;
    /**
     * Groups of Pull Request Lists
     */
    prGroups: IPullRequestGroup[];
}
/**
 * Display the Pull Request Lists
 *
 * @param props Component properties
 */
export declare function Browser(props: IBrowserProps): JSX.Element;
