```
Imported from `https://bitbucket.org/chadgalley/rompy` to make it python3

All credit to Chad R. Galley

Original README below

install with `python setup.py develop`

```

Welcome to RomPy!
-----------------------

RomPy is a Python package for reduced-order modeling applications of parametrized problems for which their solutions are expensive to make and/or are generated by codes that are unavailable, not public, or too complicated for invasively applying order-reduction methods.

This package contains:
    
    * low-level functions for greedy algorithms and reduced-order quadrature rules
    * iterated, modified Gram-Schmidt orthogonalization
    * empirical interpolation method
    * functions for building reduced bases and surrogate models

RomPy is intended for arbitrary parametrized problems and can be used as a foundation or back-end for problem-specific applications. The Python package RomGW is an example of this for gravitational wave applications, which has been used to build reduced-order models that can be accurately and cheaply evaluated as a substitute (or surrogate) for problems where waveform generation is too expensive for the problem of interest. For example, this is the case, among others, for generating numerical solutions of Einstein's equations, which involves solving coupled, nonlinear, and constrained partial differential equations.

RomPy has been designed to be used easily for both scripting work and interaction sessions with IPython. 

Many of the methods and algorithms implemented in RomPy for building surrogate models are discussed in 

    Scott E. Field, Chad R. Galley, Jan S. Hesthaven, Jason Kaye, and Manuel Tiglio
    "Fast prediction and evaluation of gravitational waveforms using surrogate models"
    Phys. Rev. X 4, 031006 (2014). [arXiv:1308.3565]

Please cite this paper and this package if you find RomPy useful for your work. Comments, questions, and requests are always welcome.


Installation
-----------------------

RomPy is still in development but is mostly stable at this point. RomPy can be installed simply by cloning or downloading this repository and adding the install directory to your `$PYTHONPATH`.
