# AUTOGENERATED! DO NOT EDIT! File to edit: ../15_CutMixSemantic.ipynb.

# %% auto 0
__all__ = ['CutMixSemantic']

# %% ../15_CutMixSemantic.ipynb 2
from .holemakertechnique import *
from .holemakerrandom import *
from .holesfilling import *
import numpy as np

# %% ../15_CutMixSemantic.ipynb 4
class CutMixSemantic(HolesFilling):
    "Defines the amount of holes, the technique used to make them and the probability of apply the technique."
    def __init__(self,
                 holes_num = 1, # The amount of holes to make.
                 occlusion_class = -1, # The class to remove. If -1, selects it randomly in each use.
                 hole_maker: "HoleMakerTechnique" = None, # The strategy used to make the holes.
                 p = 1.0): # The probability of applying this technique.
        super().__init__(hole_maker)
        self.holes_num = holes_num
        self.occlusion_class = occlusion_class
        self.p = p

    def before_batch(self):
        "Applies the CutMix technique with semantic information (only applies the CutMix to a selected class)."
        if random() < self.p:
            for image, mask in zip(self.x, self.y):
                for _ in range(self.holes_num):
                    rand = randint(0, image.shape[0])
                    other_image, other_mask = self.x[rand], self.y[rand]
                    xhole, yhole = self.make_hole(mask)
                    occlusion_value = self.occlusion_class if self.occlusion_class != -1 else randint(1, len(mask.unique()))
                    sub_image, sub_mask = TensorBase(other_image[:, yhole, xhole]), TensorBase(other_mask[yhole, xhole])
                    replacement_mask = sub_mask == occlusion_value
                    sub_image[:, replacement_mask] = torch.min(image)
                    sub_mask[replacement_mask] = 0
                    self.fill_hole(image, mask, xhole, yhole, [sub_image, sub_mask])
