/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CoroutineSuspendCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class CoroutineSuspendCallChecker
implements CallChecker {
    public static final CoroutineSuspendCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        FunctionDescriptor enclosingSuspendFunction;
        FqName fqName2;
        Object descriptor2;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object obj = descriptor2 = resolvedCall2.getCandidateDescriptor();
        if (obj instanceof FunctionDescriptor) {
            if (!((FunctionDescriptor)descriptor2).isSuspend()) {
                return;
            }
        } else if (obj instanceof PropertyDescriptor) {
            fqName2 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)descriptor2);
            if (!(Intrinsics.areEqual(fqName2, CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_1_2_20_FQ_NAME()) || Intrinsics.areEqual(fqName2, CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_1_2_30_FQ_NAME()) || Intrinsics.areEqual(fqName2, CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_1_3_FQ_NAME()))) {
                return;
            }
        } else {
            return;
        }
        if ((enclosingSuspendFunction = CoroutineCallCheckerKt.findEnclosingSuspendFunction(context)) != null) {
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
            KtElement ktElement = call2.getCallElement();
            if (ktElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            KtExpression callElement = (KtExpression)ktElement;
            if (!InlineUtil.checkNonLocalReturnUsage(enclosingSuspendFunction, callElement, context.getResolutionContext())) {
                context.getTrace().report(Errors.NON_LOCAL_SUSPENSION_POINT.on(reportOn));
            } else {
                boolean bl;
                block18: {
                    Sequence<HierarchicalScope> $receiver$iv = ScopeUtilsKt.getParentsWithSelf(context.getScope());
                    Iterator<HierarchicalScope> iterator2 = $receiver$iv.iterator();
                    while (iterator2.hasNext()) {
                        HierarchicalScope element$iv = iterator2.next();
                        HierarchicalScope it = element$iv;
                        if (!CoroutineCallCheckerKt.access$isScopeForDefaultParameterValuesOf(it, enclosingSuspendFunction)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
                if (bl) {
                    context.getTrace().report(Errors.UNSUPPORTED.on(reportOn, "suspend function calls in a context of default parameter value"));
                }
            }
            if ((Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)descriptor2), CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_1_2_20_FQ_NAME()) || Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)descriptor2), CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_1_2_30_FQ_NAME())) && context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReleaseCoroutines)) {
                context.getTrace().report(Errors.UNSUPPORTED.on(reportOn, "experimental coroutineContext of release coroutine: use kotlin.coroutines.coroutineContext instead"));
            }
            context.getTrace().record(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall(), enclosingSuspendFunction);
            CoroutineCallCheckerKt.access$checkRestrictsSuspension(enclosingSuspendFunction, resolvedCall2, reportOn, context);
        } else {
            Call call3 = resolvedCall2.getCall();
            Intrinsics.checkExpressionValueIsNotNull(call3, "resolvedCall.call");
            if (!CallUtilKt.isCallableReference(call3)) {
                fqName2 = descriptor2;
                if (fqName2 instanceof FunctionDescriptor) {
                    context.getTrace().report(Errors.ILLEGAL_SUSPEND_FUNCTION_CALL.on(reportOn, (CallableDescriptor)resolvedCall2.getCandidateDescriptor()));
                } else if (fqName2 instanceof PropertyDescriptor) {
                    context.getTrace().report(Errors.ILLEGAL_SUSPEND_PROPERTY_ACCESS.on(reportOn, (CallableDescriptor)resolvedCall2.getCandidateDescriptor()));
                }
            }
        }
    }

    private CoroutineSuspendCallChecker() {
    }

    static {
        CoroutineSuspendCallChecker coroutineSuspendCallChecker;
        INSTANCE = coroutineSuspendCallChecker = new CoroutineSuspendCallChecker();
    }
}

