/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileFilter;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThreadLocalCachedValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.CommonProcessors;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.LimitedPool;
import org.jetbrains.kotlin.com.intellij.util.containers.SLRUCache;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.com.intellij.util.io.DataOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.IOStatistics;
import org.jetbrains.kotlin.com.intellij.util.io.IOUtil;
import org.jetbrains.kotlin.com.intellij.util.io.InlineKeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.IntInlineKeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.PagedFileStorage;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentBTreeEnumerator;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentEnumeratorBase;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentEnumeratorDelegate;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentHashMapValueStorage;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentMap;
import org.jetbrains.kotlin.com.intellij.util.io.UnsyncByteArrayInputStream;

public class PersistentHashMap<Key, Value>
extends PersistentEnumeratorDelegate<Key>
implements PersistentMap<Key, Value> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.PersistentHashMap");
    private static final boolean myDoTrace = SystemProperties.getBooleanProperty("idea.trace.persistent.map", false);
    private static final int DEAD_KEY_NUMBER_MASK = -1;
    private final File myStorageFile;
    private final boolean myIsReadOnly;
    private final KeyDescriptor<Key> myKeyDescriptor;
    private PersistentHashMapValueStorage myValueStorage;
    protected final DataExternalizer<Value> myValueExternalizer;
    private static final long NULL_ADDR = 0L;
    private static final int INITIAL_INDEX_SIZE;
    @NonNls
    static final String DATA_FILE_EXTENSION = ".values";
    private long myLiveAndGarbageKeysCounter;
    private int myReadCompactionGarbageSize;
    private static final long LIVE_KEY_MASK = 0x100000000L;
    private static final long USED_LONG_VALUE_MASK = 0x4000000000000000L;
    private static final int POSITIVE_VALUE_SHIFT = 1;
    private final int myParentValueRefOffset;
    @NotNull
    private final byte[] myRecordBuffer;
    @NotNull
    private final byte[] mySmallRecordBuffer;
    private final boolean myIntMapping;
    private final boolean myDirectlyStoreLongFileOffsetMode;
    private final boolean myCanReEnumerate;
    private int myLargeIndexWatermarkId;
    private boolean myIntAddressForNewRecord;
    private static final boolean doHardConsistencyChecks = false;
    private volatile boolean myBusyReading;
    private final LimitedPool<BufferExposingByteArrayOutputStream> myStreamPool;
    private final SLRUCache<Key, BufferExposingByteArrayOutputStream> myAppendCache;
    private final LowMemoryWatcher myAppendCacheFlusher;
    private static final ThreadLocalCachedValue<AppendStream> ourFlyweightAppenderStream;
    private int smallKeys;
    private int largeKeys;
    private int transformedKeys;
    private int requests;

    private boolean canUseIntAddressForNewRecord(long size) {
        return this.myCanReEnumerate && size + 1L < Integer.MAX_VALUE;
    }

    public PersistentHashMap(@NotNull File file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) throws IOException {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(0);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(1);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(2);
        }
        this(file2, keyDescriptor, valueExternalizer, INITIAL_INDEX_SIZE);
    }

    public PersistentHashMap(@NotNull File file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize) throws IOException {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(3);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(4);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(5);
        }
        this(file2, keyDescriptor, valueExternalizer, initialSize, 0);
    }

    public PersistentHashMap(@NotNull File file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize, int version) throws IOException {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(6);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(7);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(8);
        }
        this(file2, keyDescriptor, valueExternalizer, initialSize, version, null);
    }

    public PersistentHashMap(@NotNull File file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize, int version, @Nullable PagedFileStorage.StorageLockContext lockContext) throws IOException {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(9);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(10);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(11);
        }
        this(file2, keyDescriptor, valueExternalizer, initialSize, version, lockContext, PersistentHashMapValueStorage.CreationTimeOptions.threadLocalOptions());
    }

    private PersistentHashMap(@NotNull File file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize, int version, @Nullable PagedFileStorage.StorageLockContext lockContext, @NotNull PersistentHashMapValueStorage.CreationTimeOptions options) throws IOException {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(12);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(13);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(14);
        }
        if (options == null) {
            PersistentHashMap.$$$reportNull$$$0(15);
        }
        super(PersistentHashMap.checkDataFiles(file2), keyDescriptor, initialSize, lockContext, PersistentHashMap.modifyVersionDependingOnOptions(version, options));
        this.myStreamPool = new LimitedPool<BufferExposingByteArrayOutputStream>(10, new LimitedPool.ObjectFactory<BufferExposingByteArrayOutputStream>(){

            @Override
            @NotNull
            public BufferExposingByteArrayOutputStream create() {
                BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = new BufferExposingByteArrayOutputStream();
                if (bufferExposingByteArrayOutputStream == null) {
                    1.$$$reportNull$$$0(0);
                }
                return bufferExposingByteArrayOutputStream;
            }

            @Override
            public void cleanup(@NotNull BufferExposingByteArrayOutputStream appendStream) {
                if (appendStream == null) {
                    1.$$$reportNull$$$0(1);
                }
                appendStream.reset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "appendStream";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "cleanup";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myAppendCacheFlusher = LowMemoryWatcher.register(new Runnable(){

            @Override
            public void run() {
                PersistentHashMap.this.dropMemoryCaches();
            }
        });
        this.myStorageFile = file2;
        this.myKeyDescriptor = keyDescriptor;
        this.myIsReadOnly = this.isReadOnly();
        if (this.myIsReadOnly) {
            options = options.setReadOnly();
        }
        this.myAppendCache = this.createAppendCache(keyDescriptor);
        final PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase> recordHandler = this.myEnumerator.getRecordHandler();
        this.myParentValueRefOffset = recordHandler.getRecordBuffer(this.myEnumerator).length;
        this.myIntMapping = valueExternalizer instanceof IntInlineKeyDescriptor && this.wantNonNegativeIntegralValues();
        this.myDirectlyStoreLongFileOffsetMode = keyDescriptor instanceof InlineKeyDescriptor && this.myEnumerator instanceof PersistentBTreeEnumerator;
        this.myRecordBuffer = this.myDirectlyStoreLongFileOffsetMode ? ArrayUtil.EMPTY_BYTE_ARRAY : new byte[this.myParentValueRefOffset + 8];
        this.mySmallRecordBuffer = this.myDirectlyStoreLongFileOffsetMode ? ArrayUtil.EMPTY_BYTE_ARRAY : new byte[this.myParentValueRefOffset + 4];
        this.myEnumerator.setRecordHandler(new PersistentEnumeratorBase.RecordBufferHandler<PersistentEnumeratorBase>(){

            @Override
            int recordWriteOffset(PersistentEnumeratorBase enumerator, byte[] buf) {
                return recordHandler.recordWriteOffset(enumerator, buf);
            }

            @Override
            @NotNull
            byte[] getRecordBuffer(PersistentEnumeratorBase enumerator) {
                byte[] byArray = PersistentHashMap.this.myIntAddressForNewRecord ? PersistentHashMap.this.mySmallRecordBuffer : PersistentHashMap.this.myRecordBuffer;
                if (byArray == null) {
                    3.$$$reportNull$$$0(0);
                }
                return byArray;
            }

            @Override
            void setupRecord(PersistentEnumeratorBase enumerator, int hashCode2, int dataOffset, @NotNull byte[] buf) {
                if (buf == null) {
                    3.$$$reportNull$$$0(1);
                }
                recordHandler.setupRecord(enumerator, hashCode2, dataOffset, buf);
                for (int i = PersistentHashMap.this.myParentValueRefOffset; i < buf.length; ++i) {
                    buf[i] = 0;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "buf";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRecordBuffer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setupRecord";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myEnumerator.setMarkCleanCallback(new Flushable(){

            @Override
            public void flush() {
                PersistentHashMap.this.myEnumerator.putMetaData(PersistentHashMap.this.myLiveAndGarbageKeysCounter);
                PersistentHashMap.this.myEnumerator.putMetaData2((long)PersistentHashMap.this.myLargeIndexWatermarkId | (long)PersistentHashMap.this.myReadCompactionGarbageSize << 32);
            }
        });
        if (myDoTrace) {
            LOG.info("Opened " + file2);
        }
        try {
            this.myValueExternalizer = valueExternalizer;
            this.myValueStorage = PersistentHashMapValueStorage.create(PersistentHashMap.getDataFile(file2).getPath(), options);
            this.myLiveAndGarbageKeysCounter = this.myEnumerator.getMetaData();
            long data2 = this.myEnumerator.getMetaData2();
            this.myLargeIndexWatermarkId = (int)(data2 & 0xFFFFFFFFFFFFFFFFL);
            this.myReadCompactionGarbageSize = (int)(data2 >>> 32);
            this.myCanReEnumerate = this.myEnumerator.canReEnumerate();
            if (this.makesSenseToCompact()) {
                this.compact();
            }
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        catch (Throwable t) {
            LOG.error(t);
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new PersistentEnumeratorBase.CorruptedException(file2);
        }
    }

    private static int modifyVersionDependingOnOptions(int version, @NotNull PersistentHashMapValueStorage.CreationTimeOptions options) {
        if (options == null) {
            PersistentHashMap.$$$reportNull$$$0(16);
        }
        return version + options.getVersion();
    }

    protected boolean wantNonNegativeIntegralValues() {
        return false;
    }

    protected boolean isReadOnly() {
        return false;
    }

    private SLRUCache<Key, BufferExposingByteArrayOutputStream> createAppendCache(KeyDescriptor<Key> keyDescriptor) {
        return new SLRUCache<Key, BufferExposingByteArrayOutputStream>(16384, 4096, keyDescriptor){

            @Override
            @NotNull
            public BufferExposingByteArrayOutputStream createValue(Key key) {
                BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = (BufferExposingByteArrayOutputStream)PersistentHashMap.this.myStreamPool.alloc();
                if (bufferExposingByteArrayOutputStream == null) {
                    5.$$$reportNull$$$0(0);
                }
                return bufferExposingByteArrayOutputStream;
            }

            @Override
            protected void onDropFromCache(Key key, @NotNull BufferExposingByteArrayOutputStream bytes) {
                if (bytes == null) {
                    5.$$$reportNull$$$0(1);
                }
                PersistentHashMap.this.myEnumerator.lockStorage();
                try {
                    int id;
                    long previousRecord;
                    if (PersistentHashMap.this.myDirectlyStoreLongFileOffsetMode) {
                        previousRecord = ((PersistentBTreeEnumerator)PersistentHashMap.this.myEnumerator).getNonNegativeValue(key);
                        id = -1;
                    } else {
                        id = PersistentHashMap.this.enumerate(key);
                        previousRecord = PersistentHashMap.this.readValueId(id);
                    }
                    long headerRecord = PersistentHashMap.this.myValueStorage.appendBytes(bytes.getInternalBuffer(), 0, bytes.size(), previousRecord);
                    if (PersistentHashMap.this.myDirectlyStoreLongFileOffsetMode) {
                        ((PersistentBTreeEnumerator)PersistentHashMap.this.myEnumerator).putNonNegativeValue(key, headerRecord);
                    } else {
                        PersistentHashMap.this.updateValueId(id, headerRecord, previousRecord, key, 0);
                    }
                    if (previousRecord == 0L) {
                        PersistentHashMap.this.myLiveAndGarbageKeysCounter = PersistentHashMap.this.myLiveAndGarbageKeysCounter + 0x100000000L;
                    }
                    PersistentHashMap.this.myStreamPool.recycle(bytes);
                }
                catch (IOException e) {
                    PersistentHashMap.this.markCorrupted();
                    throw new RuntimeException(e);
                }
                finally {
                    PersistentHashMap.this.myEnumerator.unlockStorage();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap$5";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "bytes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "onDropFromCache";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static boolean doNewCompact() {
        return System.getProperty("idea.persistent.hash.map.oldcompact") == null;
    }

    private boolean forceNewCompact() {
        return System.getProperty("idea.persistent.hash.map.newcompact") != null && (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFFFFFFFFFL) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropMemoryCaches() {
        if (myDoTrace) {
            LOG.info("Drop memory caches " + this.myStorageFile);
        }
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.doDropMemoryCaches();
        }
    }

    protected void doDropMemoryCaches() {
        this.myEnumerator.lockStorage();
        try {
            this.clearAppenderCaches();
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
    }

    int getGarbageSize() {
        return (int)this.myLiveAndGarbageKeysCounter;
    }

    public File getBaseFile() {
        return this.myEnumerator.myFile;
    }

    public boolean makesSenseToCompact() {
        if (this.myIsReadOnly) {
            return false;
        }
        long fileSize = this.myValueStorage.getSize();
        int megabyte = 0x100000;
        if (fileSize > 0x500000L) {
            int liveKeys = (int)(this.myLiveAndGarbageKeysCounter / 0x100000000L);
            int deadKeys = (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFFFFFFFFFL);
            if (fileSize > 0x3200000L && this.forceNewCompact()) {
                return true;
            }
            if (deadKeys < 50) {
                return false;
            }
            long benefitSize = Math.max(0x6400000L, fileSize / 4L);
            long avgValueSize = fileSize / (long)(liveKeys + deadKeys);
            return deadKeys > liveKeys || avgValueSize * (long)deadKeys > benefitSize || (long)this.myReadCompactionGarbageSize > fileSize / 2L;
        }
        return false;
    }

    @NotNull
    private static File checkDataFiles(@NotNull File file2) {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(17);
        }
        if (!file2.exists()) {
            PersistentHashMap.deleteFilesStartingWith(PersistentHashMap.getDataFile(file2));
        }
        File file3 = file2;
        if (file3 == null) {
            PersistentHashMap.$$$reportNull$$$0(18);
        }
        return file3;
    }

    public static void deleteFilesStartingWith(@NotNull File prefixFile) {
        if (prefixFile == null) {
            PersistentHashMap.$$$reportNull$$$0(19);
        }
        IOUtil.deleteAllFilesStartingWith(prefixFile);
    }

    @NotNull
    static File getDataFile(@NotNull File file2) {
        if (file2 == null) {
            PersistentHashMap.$$$reportNull$$$0(20);
        }
        File file3 = new File(file2.getParentFile(), file2.getName() + DATA_FILE_EXTENSION);
        if (file3 == null) {
            PersistentHashMap.$$$reportNull$$$0(21);
        }
        return file3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Key key, Value value) throws IOException {
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            try {
                this.doPut(key, value);
            }
            catch (IOException ex) {
                this.myEnumerator.markCorrupted();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(Key key, Value value) throws IOException {
        long newValueOffset = -1L;
        if (!this.myIntMapping) {
            BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
            AppendStream appenderStream = ourFlyweightAppenderStream.getValue();
            appenderStream.setOut(bytes);
            this.myValueExternalizer.save(appenderStream, value);
            appenderStream.setOut(null);
            newValueOffset = this.myValueStorage.appendBytes(bytes.getInternalBuffer(), 0, bytes.size(), 0L);
        }
        this.myEnumerator.lockStorage();
        try {
            long oldValueOffset;
            this.myEnumerator.markDirty(true);
            this.myAppendCache.remove(key);
            if (this.myDirectlyStoreLongFileOffsetMode) {
                if (this.myIntMapping) {
                    ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, ((Integer)value).intValue());
                    return;
                }
                oldValueOffset = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key);
                ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, newValueOffset);
            } else {
                int id = this.enumerate(key);
                if (this.myIntMapping) {
                    this.myEnumerator.myStorage.putInt(id + this.myParentValueRefOffset, (Integer)value);
                    return;
                }
                oldValueOffset = this.readValueId(id);
                this.updateValueId(id, newValueOffset, oldValueOffset, key, 0);
            }
            this.myLiveAndGarbageKeysCounter = oldValueOffset != 0L ? ++this.myLiveAndGarbageKeysCounter : (this.myLiveAndGarbageKeysCounter += 0x100000000L);
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int enumerate(Key name) throws IOException {
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.myIntAddressForNewRecord = this.canUseIntAddressForNewRecord(this.myValueStorage.getSize());
            return super.enumerate(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendData(Key key, @NotNull ValueDataAppender appender) throws IOException {
        if (appender == null) {
            PersistentHashMap.$$$reportNull$$$0(22);
        }
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            try {
                this.doAppendData(key, appender);
            }
            catch (IOException ex) {
                this.myEnumerator.markCorrupted();
                throw ex;
            }
        }
    }

    private void doAppendData(Key key, @NotNull ValueDataAppender appender) throws IOException {
        if (appender == null) {
            PersistentHashMap.$$$reportNull$$$0(23);
        }
        assert (!this.myIntMapping);
        this.myEnumerator.markDirty(true);
        AppendStream appenderStream = ourFlyweightAppenderStream.getValue();
        BufferExposingByteArrayOutputStream stream2 = this.myAppendCache.get(key);
        appenderStream.setOut(stream2);
        this.myValueStorage.checkAppendsAllowed(stream2.size());
        appender.append(appenderStream);
        appenderStream.setOut(null);
    }

    public final boolean processKeys(@NotNull Processor<? super Key> processor2) throws IOException {
        if (processor2 == null) {
            PersistentHashMap.$$$reportNull$$$0(24);
        }
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            try {
                this.myAppendCache.clear();
                return this.myEnumerator.iterateData(processor2);
            }
            catch (IOException e) {
                this.myEnumerator.markCorrupted();
                throw e;
            }
        }
    }

    @NotNull
    public Collection<Key> getAllKeysWithExistingMapping() throws IOException {
        ArrayList values2 = new ArrayList();
        this.processKeysWithExistingMapping(new CommonProcessors.CollectProcessor(values2));
        ArrayList arrayList = values2;
        if (arrayList == null) {
            PersistentHashMap.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    public final boolean processKeysWithExistingMapping(Processor<? super Key> processor2) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            try {
                this.myAppendCache.clear();
                return this.myEnumerator.processAllDataObject(processor2, new PersistentEnumeratorBase.DataFilter(){

                    @Override
                    public boolean accept(int id) {
                        return PersistentHashMap.this.readValueId(id) != 0L;
                    }
                });
            }
            catch (IOException e) {
                this.myEnumerator.markCorrupted();
                throw e;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Value get(Key key) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.myBusyReading = true;
            try {
                Value Value2 = this.doGet(key);
                return Value2;
            }
            catch (IOException ex) {
                this.myEnumerator.markCorrupted();
                throw ex;
            }
            finally {
                this.myBusyReading = false;
            }
        }
    }

    public boolean isBusyReading() {
        return this.myBusyReading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Value doGet(Key key) throws IOException {
        Value valueRead;
        int id;
        long valueOffset;
        this.myEnumerator.lockStorage();
        try {
            this.myAppendCache.remove(key);
            if (this.myDirectlyStoreLongFileOffsetMode) {
                valueOffset = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key);
                if (this.myIntMapping) {
                    Integer n = (int)valueOffset;
                    return (Value)n;
                }
                id = -1;
            } else {
                id = this.tryEnumerate(key);
                if (id == 0) {
                    Value Value2 = null;
                    return Value2;
                }
                if (this.myIntMapping) {
                    Integer n = this.myEnumerator.myStorage.getInt(id + this.myParentValueRefOffset);
                    return (Value)n;
                }
                valueOffset = this.readValueId(id);
            }
            if (valueOffset == 0L) {
                Value Value3 = null;
                return Value3;
            }
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
        PersistentHashMapValueStorage.ReadResult readResult = this.myValueStorage.readBytes(valueOffset);
        DataInputStream input = new DataInputStream(new UnsyncByteArrayInputStream(readResult.buffer));
        try {
            valueRead = this.myValueExternalizer.read(input);
        }
        finally {
            input.close();
        }
        if (this.myValueStorage.performChunksCompaction(readResult.chunksCount, readResult.buffer.length)) {
            long newValueOffset = this.myValueStorage.compactChunks(new ValueDataAppender(){

                @Override
                public void append(DataOutput out) throws IOException {
                    PersistentHashMap.this.myValueExternalizer.save(out, valueRead);
                }
            }, readResult);
            this.myEnumerator.lockStorage();
            try {
                this.myEnumerator.markDirty(true);
                if (this.myDirectlyStoreLongFileOffsetMode) {
                    ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, newValueOffset);
                } else {
                    this.updateValueId(id, newValueOffset, valueOffset, key, 0);
                }
                ++this.myLiveAndGarbageKeysCounter;
                this.myReadCompactionGarbageSize += readResult.buffer.length;
            }
            finally {
                this.myEnumerator.unlockStorage();
            }
        }
        return valueRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsMapping(Key key) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            return this.doContainsMapping(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doContainsMapping(Key key) throws IOException {
        this.myEnumerator.lockStorage();
        try {
            this.myAppendCache.remove(key);
            if (this.myDirectlyStoreLongFileOffsetMode) {
                boolean bl = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key) != 0L;
                return bl;
            }
            int id = this.tryEnumerate(key);
            if (id == 0) {
                boolean bl = false;
                return bl;
            }
            if (this.myIntMapping) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.readValueId(id) != 0L;
            return bl;
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(Key key) throws IOException {
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.doRemove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemove(Key key) throws IOException {
        this.myEnumerator.lockStorage();
        try {
            long record2;
            this.myAppendCache.remove(key);
            if (this.myDirectlyStoreLongFileOffsetMode) {
                assert (!this.myIntMapping);
                record2 = ((PersistentBTreeEnumerator)this.myEnumerator).getNonNegativeValue(key);
                if (record2 != 0L) {
                    ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(key, 0L);
                }
            } else {
                int id = this.tryEnumerate(key);
                if (id == 0) {
                    return;
                }
                assert (!this.myIntMapping);
                this.myEnumerator.markDirty(true);
                record2 = this.readValueId(id);
                this.updateValueId(id, 0L, record2, key, 0);
            }
            if (record2 != 0L) {
                ++this.myLiveAndGarbageKeysCounter;
                this.myLiveAndGarbageKeysCounter -= 0x100000000L;
            }
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void force() {
        if (this.myIsReadOnly) {
            return;
        }
        if (myDoTrace) {
            LOG.info("Forcing " + this.myStorageFile);
        }
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.doForce();
        }
    }

    protected void doForce() {
        this.myEnumerator.lockStorage();
        try {
            try {
                this.clearAppenderCaches();
            }
            finally {
                super.force();
            }
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
    }

    private void clearAppenderCaches() {
        this.myAppendCache.clear();
        this.myValueStorage.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        if (myDoTrace) {
            LOG.info("Closed " + this.myStorageFile);
        }
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.doClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() throws IOException {
        this.myEnumerator.lockStorage();
        try {
            try {
                this.myAppendCacheFlusher.stop();
                try {
                    this.myAppendCache.clear();
                }
                catch (RuntimeException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw ex;
                }
            }
            finally {
                PersistentHashMapValueStorage valueStorage = this.myValueStorage;
                try {
                    if (valueStorage != null) {
                        valueStorage.dispose();
                    }
                }
                finally {
                    super.close();
                }
            }
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact() throws IOException {
        if (this.myIsReadOnly) {
            throw new IncorrectOperationException();
        }
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            this.force();
            LOG.info("Compacting " + this.myEnumerator.myFile.getPath());
            LOG.info("Live keys:" + (int)(this.myLiveAndGarbageKeysCounter / 0x100000000L) + ", dead keys:" + (int)(this.myLiveAndGarbageKeysCounter & 0xFFFFFFFFFFFFFFFFL) + ", read compaction size:" + this.myReadCompactionGarbageSize);
            long now = System.currentTimeMillis();
            File oldDataFile = PersistentHashMap.getDataFile(this.myEnumerator.myFile);
            String oldDataFileBaseName = oldDataFile.getName();
            File[] oldFiles = PersistentHashMap.getFilesInDirectoryWithNameStartingWith(oldDataFile, oldDataFileBaseName);
            String newPath = PersistentHashMap.getDataFile(this.myEnumerator.myFile).getPath() + ".new";
            PersistentHashMapValueStorage.CreationTimeOptions options = this.myValueStorage.getOptions();
            final PersistentHashMapValueStorage newStorage = PersistentHashMapValueStorage.create(newPath, options);
            this.myValueStorage.switchToCompactionMode();
            this.myEnumerator.markDirty(true);
            long sizeBefore = this.myValueStorage.getSize();
            this.myLiveAndGarbageKeysCounter = 0L;
            this.myReadCompactionGarbageSize = 0;
            try {
                if (PersistentHashMap.doNewCompact()) {
                    this.newCompact(newStorage);
                } else {
                    this.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

                        @Override
                        public boolean process(int keyId) throws IOException {
                            long record2 = PersistentHashMap.this.readValueId(keyId);
                            if (record2 != 0L) {
                                PersistentHashMapValueStorage.ReadResult readResult = PersistentHashMap.this.myValueStorage.readBytes(record2);
                                long value = newStorage.appendBytes(readResult.buffer, 0, readResult.buffer.length, 0L);
                                PersistentHashMap.this.updateValueId(keyId, value, record2, null, this.getCurrentKey());
                                PersistentHashMap.this.myLiveAndGarbageKeysCounter = PersistentHashMap.this.myLiveAndGarbageKeysCounter + 0x100000000L;
                            }
                            return true;
                        }
                    });
                }
            }
            finally {
                newStorage.dispose();
            }
            this.myValueStorage.dispose();
            if (oldFiles != null) {
                for (File f : oldFiles) {
                    assert (FileUtil.deleteWithRenaming(f));
                }
            }
            long newSize = newStorage.getSize();
            File newDataFile = new File(newPath);
            String newBaseName = newDataFile.getName();
            File[] newFiles = PersistentHashMap.getFilesInDirectoryWithNameStartingWith(newDataFile, newBaseName);
            if (newFiles != null) {
                File parentFile = newDataFile.getParentFile();
                for (File f : newFiles) {
                    String nameAfterRename = StringUtil.replace(f.getName(), newBaseName, oldDataFileBaseName);
                    FileUtil.rename(f, new File(parentFile, nameAfterRename));
                }
            }
            this.myValueStorage = PersistentHashMapValueStorage.create(oldDataFile.getPath(), options);
            LOG.info("Compacted " + this.myEnumerator.myFile.getPath() + ":" + sizeBefore + " bytes into " + newSize + " bytes in " + (System.currentTimeMillis() - now) + "ms.");
            this.myEnumerator.putMetaData(this.myLiveAndGarbageKeysCounter);
            this.myEnumerator.putMetaData2(this.myLargeIndexWatermarkId);
            if (myDoTrace) {
                LOG.assertTrue(this.myEnumerator.isDirty());
            }
        }
    }

    private static File[] getFilesInDirectoryWithNameStartingWith(@NotNull File fileFromDirectory, final @NotNull String baseFileName) {
        File parentFile;
        if (fileFromDirectory == null) {
            PersistentHashMap.$$$reportNull$$$0(26);
        }
        if (baseFileName == null) {
            PersistentHashMap.$$$reportNull$$$0(27);
        }
        return (parentFile = fileFromDirectory.getParentFile()) != null ? parentFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(baseFileName);
            }
        }) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newCompact(@NotNull PersistentHashMapValueStorage newStorage) throws IOException {
        if (newStorage == null) {
            PersistentHashMap.$$$reportNull$$$0(28);
        }
        long started = System.currentTimeMillis();
        final ArrayList infos2 = new ArrayList(10000);
        this.traverseAllRecords(new PersistentEnumeratorBase.RecordsProcessor(){

            @Override
            public boolean process(int keyId) {
                long record2 = PersistentHashMap.this.readValueId(keyId);
                if (record2 != 0L) {
                    infos2.add(new CompactionRecordInfo(this.getCurrentKey(), record2, keyId));
                }
                return true;
            }
        });
        LOG.info("Loaded mappings:" + (System.currentTimeMillis() - started) + "ms, keys:" + infos2.size());
        started = System.currentTimeMillis();
        long fragments2 = 0L;
        if (!infos2.isEmpty()) {
            try {
                fragments2 = this.myValueStorage.compactValues(infos2, newStorage);
            }
            catch (Throwable t) {
                if (!(t instanceof IOException)) {
                    throw new IOException("Compaction failed", t);
                }
                throw (IOException)t;
            }
        }
        LOG.info("Compacted values for:" + (System.currentTimeMillis() - started) + "ms fragments:" + (int)fragments2 + ", new fragments:" + (fragments2 >> 32));
        started = System.currentTimeMillis();
        try {
            this.myEnumerator.lockStorage();
            for (CompactionRecordInfo info : infos2) {
                this.updateValueId(info.address, info.newValueAddress, info.valueAddress, null, info.key);
                this.myLiveAndGarbageKeysCounter += 0x100000000L;
            }
        }
        finally {
            this.myEnumerator.unlockStorage();
        }
        LOG.info("Updated mappings:" + (System.currentTimeMillis() - started) + " ms");
    }

    private long readValueId(int keyId) {
        if (this.myDirectlyStoreLongFileOffsetMode) {
            return ((PersistentBTreeEnumerator)this.myEnumerator).keyIdToNonNegativeOffset(keyId);
        }
        long address = this.myEnumerator.myStorage.getInt(keyId + this.myParentValueRefOffset);
        if (address == 0L || address == -1L) {
            return 0L;
        }
        if (address < 0L) {
            address = -address - 1L;
        } else {
            long value = (long)this.myEnumerator.myStorage.getInt(keyId + this.myParentValueRefOffset + 4) & 0xFFFFFFFFL;
            address = (address << 32) + value & 0xBFFFFFFFFFFFFFFFL;
        }
        return address;
    }

    private int updateValueId(int keyId, long value, long oldValue, @Nullable Key key, int processingKey) throws IOException {
        boolean newKey;
        if (this.myDirectlyStoreLongFileOffsetMode) {
            ((PersistentBTreeEnumerator)this.myEnumerator).putNonNegativeValue(((InlineKeyDescriptor)this.myKeyDescriptor).fromInt(processingKey), value);
            return keyId;
        }
        boolean bl = newKey = oldValue == 0L;
        if (newKey) {
            ++this.requests;
        }
        boolean defaultSizeInfo = true;
        if (this.myCanReEnumerate) {
            if (this.canUseIntAddressForNewRecord(value)) {
                defaultSizeInfo = false;
                this.myEnumerator.myStorage.putInt(keyId + this.myParentValueRefOffset, -((int)(value + 1L)));
                if (newKey) {
                    ++this.smallKeys;
                }
            } else if ((keyId < this.myLargeIndexWatermarkId || this.myLargeIndexWatermarkId == 0) && (newKey || this.canUseIntAddressForNewRecord(oldValue))) {
                this.myIntAddressForNewRecord = false;
                keyId = this.myEnumerator.reEnumerate(key == null ? this.myEnumerator.getValue(keyId, processingKey) : key);
                ++this.transformedKeys;
                if (this.myLargeIndexWatermarkId == 0) {
                    this.myLargeIndexWatermarkId = keyId;
                }
            }
        }
        if (defaultSizeInfo) {
            this.myEnumerator.myStorage.putInt(keyId + this.myParentValueRefOffset, (int)((value |= 0x4000000000000000L) >>> 32));
            this.myEnumerator.myStorage.putInt(keyId + this.myParentValueRefOffset + 4, (int)value);
            if (newKey) {
                ++this.largeKeys;
            }
        }
        if (newKey && IOStatistics.DEBUG && (this.requests & 0xFFFF) == 0) {
            IOStatistics.dump("small:" + this.smallKeys + ", large:" + this.largeKeys + ", transformed:" + this.transformedKeys + ",@" + this.getBaseFile().getPath());
        }
        return keyId;
    }

    public String toString() {
        return super.toString() + ": " + this.myStorageFile;
    }

    PersistentHashMapValueStorage getValueStorage() {
        return this.myValueStorage;
    }

    public boolean getReadOnly() {
        return this.myIsReadOnly;
    }

    static {
        String property = System.getProperty("idea.initialIndexSize");
        INITIAL_INDEX_SIZE = property == null ? 4096 : Integer.valueOf(property);
        ourFlyweightAppenderStream = new ThreadLocalCachedValue<AppendStream>(){

            @Override
            @NotNull
            protected AppendStream create() {
                AppendStream appendStream = new AppendStream();
                if (appendStream == null) {
                    6.$$$reportNull$$$0(0);
                }
                return appendStream;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap$6", "create"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 21: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 21: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 18: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixFile";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFromDirectory";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFileName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentHashMap";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDataFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeysWithExistingMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "modifyVersionDependingOnOptions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkDataFiles";
                break;
            }
            case 18: 
            case 21: 
            case 25: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deleteFilesStartingWith";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDataFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doAppendData";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFilesInDirectoryWithNameStartingWith";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "newCompact";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 21: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CompactionRecordInfo {
        final int key;
        final int address;
        long valueAddress;
        long newValueAddress;
        byte[] value;

        CompactionRecordInfo(int _key, long _valueAddress, int _address) {
            this.key = _key;
            this.address = _address;
            this.valueAddress = _valueAddress;
        }
    }

    public static interface ValueDataAppender {
        public void append(DataOutput var1) throws IOException;
    }

    private static class AppendStream
    extends DataOutputStream {
        private AppendStream() {
            super(null);
        }

        private void setOut(BufferExposingByteArrayOutputStream stream2) {
            this.out = stream2;
        }
    }
}

