/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.util.List;
import soot.Body;
import soot.Local;
import soot.VoidType;
import soot.util.Chain;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public class CheckVoidLocalesValidator
implements BodyValidator {
    public static CheckVoidLocalesValidator INSTANCE;

    public static CheckVoidLocalesValidator v() {
        if (INSTANCE == null) {
            INSTANCE = new CheckVoidLocalesValidator();
        }
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        Chain<Local> locals = body.getLocals();
        for (Local l : locals) {
            if (!(l.getType() instanceof VoidType)) continue;
            exception.add(new ValidationException(l, "Local " + l + " in " + body.getMethod() + " defined with void type"));
        }
    }

    @Override
    public boolean isBasicValidator() {
        return false;
    }
}

