/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import soot.util.IterableNumberer;
import soot.util.Numberable;

public class ArrayNumberer<E extends Numberable>
implements IterableNumberer<E> {
    protected E[] numberToObj = new Numberable[1024];
    protected int lastNumber = 0;

    private void resize(int n) {
        Object[] old = this.numberToObj;
        this.numberToObj = (Numberable[])Arrays.copyOf(this.numberToObj, n);
        Arrays.fill(old, null);
    }

    @Override
    public void add(E o) {
        if (o.getNumber() != 0) {
            return;
        }
        ++this.lastNumber;
        if (this.lastNumber >= this.numberToObj.length) {
            this.resize(this.numberToObj.length * 2);
        }
        this.numberToObj[this.lastNumber] = o;
        o.setNumber(this.lastNumber);
    }

    @Override
    public long get(E o) {
        if (o == null) {
            return 0L;
        }
        int ret = o.getNumber();
        if (ret == 0) {
            throw new RuntimeException("unnumbered: " + o);
        }
        return ret;
    }

    @Override
    public E get(long number) {
        if (number == 0L) {
            return null;
        }
        E ret = this.numberToObj[(int)number];
        if (ret == null) {
            throw new RuntimeException("no object with number " + number);
        }
        return ret;
    }

    @Override
    public int size() {
        return this.lastNumber;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int cur = 1;

            @Override
            public final boolean hasNext() {
                return this.cur <= ArrayNumberer.this.lastNumber && this.cur < ArrayNumberer.this.numberToObj.length && ArrayNumberer.this.numberToObj[this.cur] != null;
            }

            @Override
            public final E next() {
                if (this.hasNext()) {
                    return ArrayNumberer.this.numberToObj[this.cur++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

