/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.DominatorNode;
import soot.toolkits.graph.DominatorsFinder;

public class DominatorTree<N>
implements Iterable<DominatorNode<N>> {
    protected DominatorsFinder<N> dominators;
    protected DirectedGraph<N> graph;
    protected List<DominatorNode<N>> heads;
    protected List<DominatorNode<N>> tails;
    protected Map<N, DominatorNode<N>> godeToDode;

    public DominatorTree(DominatorsFinder dominators) {
        this.dominators = dominators;
        this.graph = dominators.getGraph();
        this.heads = new ArrayList<DominatorNode<N>>();
        this.tails = new ArrayList<DominatorNode<N>>();
        this.godeToDode = new HashMap<N, DominatorNode<N>>();
        this.buildTree();
    }

    public DirectedGraph<N> getGraph() {
        return this.dominators.getGraph();
    }

    public List<DominatorNode<N>> getHeads() {
        return new ArrayList<DominatorNode<N>>(this.heads);
    }

    public DominatorNode<N> getHead() {
        return this.heads.isEmpty() ? null : this.heads.get(0);
    }

    public List<DominatorNode<N>> getTails() {
        return new ArrayList<DominatorNode<N>>(this.tails);
    }

    public DominatorNode<N> getParentOf(DominatorNode<N> node) {
        return node.getParent();
    }

    public List<DominatorNode<N>> getChildrenOf(DominatorNode<N> node) {
        return new ArrayList<DominatorNode<N>>(node.getChildren());
    }

    public List<DominatorNode<N>> getPredsOf(DominatorNode<N> node) {
        List<N> preds = this.graph.getPredsOf(node.getGode());
        ArrayList<DominatorNode<N>> predNodes = new ArrayList<DominatorNode<N>>();
        for (N pred : preds) {
            predNodes.add(this.getDode(pred));
        }
        return predNodes;
    }

    public List<DominatorNode<N>> getSuccsOf(DominatorNode<N> node) {
        List<N> succs = this.graph.getSuccsOf(node.getGode());
        ArrayList<DominatorNode<N>> succNodes = new ArrayList<DominatorNode<N>>();
        for (N succ : succs) {
            succNodes.add(this.getDode(succ));
        }
        return succNodes;
    }

    public boolean isImmediateDominatorOf(DominatorNode<N> idom, DominatorNode<N> node) {
        return node.getParent() == idom;
    }

    public boolean isDominatorOf(DominatorNode<N> dom, DominatorNode<N> node) {
        return this.dominators.isDominatedBy(node.getGode(), dom.getGode());
    }

    public DominatorNode<N> getDode(N gode) {
        DominatorNode<N> dode = this.godeToDode.get(gode);
        if (dode == null) {
            throw new RuntimeException("Assertion failed: Dominator tree does not have a corresponding dode for gode (" + gode + ")");
        }
        return dode;
    }

    @Override
    public Iterator<DominatorNode<N>> iterator() {
        return this.godeToDode.values().iterator();
    }

    public int size() {
        return this.godeToDode.size();
    }

    protected void buildTree() {
        for (N gode : this.graph) {
            DominatorNode<N> dode = this.fetchDode(gode);
            DominatorNode<N> parent = this.fetchParent(gode);
            if (parent == null) {
                this.heads.add(dode);
                continue;
            }
            parent.addChild(dode);
            dode.setParent(parent);
        }
        for (DominatorNode dode : this) {
            if (!dode.isTail()) continue;
            this.tails.add(dode);
        }
    }

    protected DominatorNode<N> fetchDode(N gode) {
        DominatorNode<N> dode;
        if (this.godeToDode.containsKey(gode)) {
            dode = this.godeToDode.get(gode);
        } else {
            dode = new DominatorNode<N>(gode);
            this.godeToDode.put(gode, dode);
        }
        return dode;
    }

    protected DominatorNode<N> fetchParent(N gode) {
        N immediateDominator = this.dominators.getImmediateDominator(gode);
        if (immediateDominator == null) {
            return null;
        }
        return this.fetchDode(immediateDominator);
    }
}

