/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.validation;

import java.util.List;
import soot.Body;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.IdentityStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ThisRef;
import soot.util.Chain;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public class IdentityStatementsValidator
implements BodyValidator {
    public static IdentityStatementsValidator INSTANCE;

    public static IdentityStatementsValidator v() {
        if (INSTANCE == null) {
            INSTANCE = new IdentityStatementsValidator();
        }
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        SootMethod method = body.getMethod();
        if (method.isAbstract()) {
            return;
        }
        Chain<Unit> units = body.getUnits().getNonPatchingChain();
        boolean foundNonThisOrParamIdentityStatement = false;
        boolean firstStatement = true;
        for (Unit unit : units) {
            if (unit instanceof IdentityStmt) {
                IdentityStmt identityStmt = (IdentityStmt)unit;
                if (identityStmt.getRightOp() instanceof ThisRef) {
                    if (method.isStatic()) {
                        exception.add(new ValidationException(identityStmt, "@this-assignment in a static method!"));
                    }
                    if (!firstStatement) {
                        exception.add(new ValidationException(identityStmt, "@this-assignment statement should precede all other statements\n method: " + method));
                    }
                } else if (identityStmt.getRightOp() instanceof ParameterRef) {
                    if (foundNonThisOrParamIdentityStatement) {
                        exception.add(new ValidationException(identityStmt, "@param-assignment statements should precede all non-identity statements\n method: " + method));
                    }
                } else {
                    foundNonThisOrParamIdentityStatement = true;
                }
            } else {
                foundNonThisOrParamIdentityStatement = true;
            }
            firstStatement = false;
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

