/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.Context;
import soot.EntryPoints;
import soot.FastHierarchy;
import soot.G;
import soot.Kind;
import soot.Local;
import soot.MethodContext;
import soot.MethodOrMethodContext;
import soot.PackManager;
import soot.PhaseOptions;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Transform;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.FieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.ContextManager;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.callgraph.ReflectionModel;
import soot.jimple.toolkits.callgraph.VirtualCallSite;
import soot.jimple.toolkits.callgraph.VirtualCalls;
import soot.jimple.toolkits.reflection.ReflectionTraceInfo;
import soot.options.CGOptions;
import soot.options.Options;
import soot.util.LargeNumberedMap;
import soot.util.NumberedString;
import soot.util.SmallNumberedMap;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public final class OnFlyCallGraphBuilder {
    private final CallGraph cicg = new CallGraph();
    private final HashSet<SootMethod> analyzedMethods = new HashSet();
    private final LargeNumberedMap<Local, List<VirtualCallSite>> receiverToSites = new LargeNumberedMap(Scene.v().getLocalNumberer());
    private final LargeNumberedMap<SootMethod, List<Local>> methodToReceivers = new LargeNumberedMap(Scene.v().getMethodNumberer());
    private final SmallNumberedMap<List<VirtualCallSite>> stringConstToSites = new SmallNumberedMap(Scene.v().getLocalNumberer());
    private final LargeNumberedMap<SootMethod, List<Local>> methodToStringConstants = new LargeNumberedMap(Scene.v().getMethodNumberer());
    private CGOptions options;
    private boolean appOnly;
    private ReachableMethods rm;
    private QueueReader<MethodOrMethodContext> worklist;
    private ContextManager cm;
    private final ChunkedQueue<SootMethod> targetsQueue = new ChunkedQueue();
    private final QueueReader<SootMethod> targets = this.targetsQueue.reader();
    ReflectionModel reflectionModel;
    protected final NumberedString sigFinalize = Scene.v().getSubSigNumberer().findOrAdd("void finalize()");
    protected final NumberedString sigInit = Scene.v().getSubSigNumberer().findOrAdd("void <init>()");
    protected final NumberedString sigStart = Scene.v().getSubSigNumberer().findOrAdd("void start()");
    protected final NumberedString sigRun = Scene.v().getSubSigNumberer().findOrAdd("void run()");
    protected final NumberedString sigExecute = Scene.v().getSubSigNumberer().findOrAdd("android.os.AsyncTask execute(java.lang.Object[])");
    protected final NumberedString sigExecutorExecute = Scene.v().getSubSigNumberer().findOrAdd("void execute(java.lang.Runnable)");
    protected final NumberedString sigHandlerPost = Scene.v().getSubSigNumberer().findOrAdd("boolean post(java.lang.Runnable)");
    protected final NumberedString sigHandlerPostAtFrontOfQueue = Scene.v().getSubSigNumberer().findOrAdd("boolean postAtFrontOfQueue(java.lang.Runnable)");
    protected final NumberedString sigHandlerPostAtTime = Scene.v().getSubSigNumberer().findOrAdd("boolean postAtTime(java.lang.Runnable,long)");
    protected final NumberedString sigHandlerPostAtTimeWithToken = Scene.v().getSubSigNumberer().findOrAdd("boolean postAtTime(java.lang.Runnable,java.lang.Object,long)");
    protected final NumberedString sigHandlerPostDelayed = Scene.v().getSubSigNumberer().findOrAdd("boolean postDelayed(java.lang.Runnable,long)");
    protected final NumberedString sigObjRun = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Object run()");
    protected final NumberedString sigDoInBackground = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Object doInBackground(java.lang.Object[])");
    protected final NumberedString sigForName = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Class forName(java.lang.String)");
    protected final RefType clRunnable = RefType.v("java.lang.Runnable");
    protected final RefType clAsyncTask = RefType.v("android.os.AsyncTask");

    public LargeNumberedMap<SootMethod, List<Local>> methodToReceivers() {
        return this.methodToReceivers;
    }

    public LargeNumberedMap<SootMethod, List<Local>> methodToStringConstants() {
        return this.methodToStringConstants;
    }

    public OnFlyCallGraphBuilder(ContextManager cm, ReachableMethods rm) {
        this.cm = cm;
        this.rm = rm;
        this.worklist = rm.listener();
        this.options = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
        if (!this.options.verbose()) {
            G.v().out.println("[Call Graph] For information on where the call graph may be incomplete, use the verbose option to the cg phase.");
        }
        this.reflectionModel = this.options.reflection_log() == null || this.options.reflection_log().length() == 0 ? new DefaultReflectionModel() : new TraceBasedReflectionModel();
    }

    public OnFlyCallGraphBuilder(ContextManager cm, ReachableMethods rm, boolean appOnly) {
        this(cm, rm);
        this.appOnly = appOnly;
    }

    public void processReachables() {
        while (true) {
            if (!this.worklist.hasNext()) {
                this.rm.update();
                if (!this.worklist.hasNext()) break;
            }
            MethodOrMethodContext momc = this.worklist.next();
            SootMethod m = momc.method();
            if (this.appOnly && !m.getDeclaringClass().isApplicationClass()) continue;
            if (this.analyzedMethods.add(m)) {
                this.processNewMethod(m);
            }
            this.processNewMethodContext(momc);
        }
    }

    public boolean wantTypes(Local receiver) {
        return this.receiverToSites.get(receiver) != null;
    }

    public void addType(Local receiver, Context srcContext, Type type, Context typeContext) {
        FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
        for (VirtualCallSite site : this.receiverToSites.get(receiver)) {
            SootMethod target;
            if (site.kind() == Kind.THREAD && !fh.canStoreType(type, this.clRunnable) || site.kind() == Kind.EXECUTOR && !fh.canStoreType(type, this.clRunnable) || site.kind() == Kind.ASYNCTASK && !fh.canStoreType(type, this.clAsyncTask)) continue;
            if (site.iie() instanceof SpecialInvokeExpr && site.kind != Kind.THREAD && site.kind != Kind.EXECUTOR && site.kind != Kind.ASYNCTASK) {
                target = VirtualCalls.v().resolveSpecial((SpecialInvokeExpr)site.iie(), site.subSig(), site.container());
                if (target != null) {
                    this.targetsQueue.add(target);
                }
            } else {
                VirtualCalls.v().resolve(type, receiver.getType(), site.subSig(), site.container(), this.targetsQueue);
            }
            while (this.targets.hasNext()) {
                target = this.targets.next();
                this.cm.addVirtualEdge(MethodContext.v(site.container(), srcContext), site.stmt(), target, site.kind(), typeContext);
            }
        }
    }

    public boolean wantStringConstants(Local stringConst) {
        return this.stringConstToSites.get(stringConst) != null;
    }

    public void addStringConstant(Local l, Context srcContext, String constant) {
        for (VirtualCallSite site : this.stringConstToSites.get(l)) {
            if (constant == null) {
                if (!this.options.verbose()) continue;
                G.v().out.println("Warning: Method " + site.container() + " is reachable, and calls Class.forName on a" + " non-constant String; graph will be incomplete!" + " Use safe-forname option for a conservative result.");
                continue;
            }
            if (constant.length() > 0 && constant.charAt(0) == '[') {
                if (constant.length() <= 1 || constant.charAt(1) != 'L' || constant.charAt(constant.length() - 1) != ';') continue;
                constant = constant.substring(2, constant.length() - 1);
            }
            if (!Scene.v().containsClass(constant)) {
                if (!this.options.verbose()) continue;
                G.v().out.println("Warning: Class " + constant + " is" + " a dynamic class, and you did not specify" + " it as such; graph will be incomplete!");
                continue;
            }
            SootClass sootcls = Scene.v().getSootClass(constant);
            if (!sootcls.isApplicationClass()) {
                sootcls.setLibraryClass();
            }
            for (SootMethod clinit : EntryPoints.v().clinitsOf(sootcls)) {
                this.cm.addStaticEdge(MethodContext.v(site.container(), srcContext), site.stmt(), clinit, Kind.CLINIT);
            }
        }
    }

    private void addVirtualCallSite(Stmt s, SootMethod m, Local receiver, InstanceInvokeExpr iie, NumberedString subSig, Kind kind) {
        List<VirtualCallSite> sites = this.receiverToSites.get(receiver);
        if (sites == null) {
            sites = new ArrayList<VirtualCallSite>();
            this.receiverToSites.put(receiver, sites);
            List<Local> receivers = this.methodToReceivers.get(m);
            if (receivers == null) {
                receivers = new ArrayList<Local>();
                this.methodToReceivers.put(m, receivers);
            }
            receivers.add(receiver);
        }
        sites.add(new VirtualCallSite(s, m, iie, subSig, kind));
    }

    private void processNewMethod(SootMethod m) {
        if (m.isNative() || m.isPhantom()) {
            return;
        }
        Body b = m.retrieveActiveBody();
        this.getImplicitTargets(m);
        this.findReceivers(m, b);
    }

    private void findReceivers(SootMethod m, Body b) {
        for (Unit u : b.getUnits()) {
            Stmt s = (Stmt)u;
            if (!s.containsInvokeExpr()) continue;
            InvokeExpr ie = s.getInvokeExpr();
            if (ie instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
                Local receiver = (Local)iie.getBase();
                NumberedString subSig = iie.getMethodRef().getSubSignature();
                this.addVirtualCallSite(s, m, receiver, iie, subSig, Edge.ieToKind(iie));
                if (subSig == this.sigStart) {
                    this.addVirtualCallSite(s, m, receiver, iie, this.sigRun, Kind.THREAD);
                    continue;
                }
                if (subSig == this.sigExecutorExecute || subSig == this.sigHandlerPost || subSig == this.sigHandlerPostAtFrontOfQueue || subSig == this.sigHandlerPostAtTime || subSig == this.sigHandlerPostAtTimeWithToken || subSig == this.sigHandlerPostDelayed) {
                    Value runnable;
                    if (iie.getArgCount() <= 0 || !((runnable = iie.getArg(0)) instanceof Local)) continue;
                    this.addVirtualCallSite(s, m, (Local)runnable, iie, this.sigRun, Kind.EXECUTOR);
                    continue;
                }
                if (subSig != this.sigExecute) continue;
                this.addVirtualCallSite(s, m, receiver, iie, this.sigDoInBackground, Kind.ASYNCTASK);
                continue;
            }
            if (ie instanceof DynamicInvokeExpr) {
                if (!this.options.verbose()) continue;
                G.v().out.println("WARNING: InvokeDynamic to " + ie + " not resolved during call-graph construction.");
                continue;
            }
            SootMethod tgt = ie.getMethod();
            if (tgt != null) {
                this.addEdge(m, s, tgt);
                String signature = tgt.getSignature();
                if (!signature.equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedAction)>") && !signature.equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction)>") && !signature.equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedAction,java.security.AccessControlContext)>") && !signature.equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction,java.security.AccessControlContext)>")) continue;
                Local receiver = (Local)ie.getArg(0);
                this.addVirtualCallSite(s, m, receiver, null, this.sigObjRun, Kind.PRIVILEGED);
                continue;
            }
            if (Options.v().ignore_resolution_errors()) continue;
            throw new InternalError("Unresolved target " + ie.getMethod() + ". Resolution error should have occured earlier.");
        }
    }

    private void getImplicitTargets(SootMethod source) {
        SootClass scl = source.getDeclaringClass();
        if (source.isNative() || source.isPhantom()) {
            return;
        }
        if (source.getSubSignature().indexOf("<init>") >= 0) {
            this.handleInit(source, scl);
        }
        Body b = source.retrieveActiveBody();
        for (Stmt stmt : b.getUnits()) {
            FieldRef fr;
            SootClass cl;
            if (stmt.containsInvokeExpr()) {
                InvokeExpr ie = stmt.getInvokeExpr();
                String methRefSig = ie.getMethodRef().getSignature();
                if (methRefSig.equals("<java.lang.reflect.Method: java.lang.Object invoke(java.lang.Object,java.lang.Object[])>")) {
                    this.reflectionModel.methodInvoke(source, stmt);
                } else if (methRefSig.equals("<java.lang.Class: java.lang.Object newInstance()>")) {
                    this.reflectionModel.classNewInstance(source, stmt);
                } else if (methRefSig.equals("<java.lang.reflect.Constructor: java.lang.Object newInstance(java.lang.Object[])>")) {
                    this.reflectionModel.contructorNewInstance(source, stmt);
                }
                if (ie.getMethodRef().getSubSignature() == this.sigForName) {
                    this.reflectionModel.classForName(source, stmt);
                }
                if (ie instanceof StaticInvokeExpr) {
                    cl = ie.getMethodRef().declaringClass();
                    for (SootMethod clinit : EntryPoints.v().clinitsOf(cl)) {
                        this.addEdge(source, stmt, clinit, Kind.CLINIT);
                    }
                }
            }
            if (stmt.containsFieldRef() && (fr = stmt.getFieldRef()) instanceof StaticFieldRef) {
                SootClass cl2 = fr.getFieldRef().declaringClass();
                for (SootMethod clinit : EntryPoints.v().clinitsOf(cl2)) {
                    this.addEdge(source, stmt, clinit, Kind.CLINIT);
                }
            }
            if (!(stmt instanceof AssignStmt)) continue;
            Value rhs = ((AssignStmt)stmt).getRightOp();
            if (rhs instanceof NewExpr) {
                NewExpr r = (NewExpr)rhs;
                cl = r.getBaseType().getSootClass();
                for (SootMethod clinit : EntryPoints.v().clinitsOf(cl)) {
                    this.addEdge(source, stmt, clinit, Kind.CLINIT);
                }
                continue;
            }
            if (!(rhs instanceof NewArrayExpr) && !(rhs instanceof NewMultiArrayExpr)) continue;
            Type t = rhs.getType();
            if (t instanceof ArrayType) {
                t = ((ArrayType)t).baseType;
            }
            if (!(t instanceof RefType)) continue;
            cl = ((RefType)t).getSootClass();
            for (SootMethod clinit : EntryPoints.v().clinitsOf(cl)) {
                this.addEdge(source, stmt, clinit, Kind.CLINIT);
            }
        }
    }

    private void processNewMethodContext(MethodOrMethodContext momc) {
        SootMethod m = momc.method();
        Iterator<Edge> it = this.cicg.edgesOutOf(m);
        while (it.hasNext()) {
            Edge e = it.next();
            this.cm.addStaticEdge(momc, e.srcUnit(), e.tgt(), e.kind());
        }
    }

    private void handleInit(SootMethod source, SootClass scl) {
        this.addEdge(source, null, scl, this.sigFinalize, Kind.FINALIZE);
    }

    private void constantForName(String cls, SootMethod src, Stmt srcUnit) {
        if (cls.length() > 0 && cls.charAt(0) == '[') {
            if (cls.length() > 1 && cls.charAt(1) == 'L' && cls.charAt(cls.length() - 1) == ';') {
                cls = cls.substring(2, cls.length() - 1);
                this.constantForName(cls, src, srcUnit);
            }
        } else if (!Scene.v().containsClass(cls)) {
            if (this.options.verbose()) {
                G.v().out.println("Warning: Class " + cls + " is" + " a dynamic class, and you did not specify" + " it as such; graph will be incomplete!");
            }
        } else {
            SootClass sootcls = Scene.v().getSootClass(cls);
            if (!sootcls.isPhantomClass()) {
                if (!sootcls.isApplicationClass()) {
                    sootcls.setLibraryClass();
                }
                for (SootMethod clinit : EntryPoints.v().clinitsOf(sootcls)) {
                    this.addEdge(src, srcUnit, clinit, Kind.CLINIT);
                }
            }
        }
    }

    private void addEdge(SootMethod src, Stmt stmt, SootMethod tgt, Kind kind) {
        this.cicg.addEdge(new Edge(src, stmt, tgt, kind));
    }

    private void addEdge(SootMethod src, Stmt stmt, SootClass cls, NumberedString methodSubSig, Kind kind) {
        SootMethod sm = cls.getMethodUnsafe(methodSubSig);
        if (sm != null) {
            this.addEdge(src, stmt, sm, kind);
        }
    }

    private void addEdge(SootMethod src, Stmt stmt, SootMethod tgt) {
        InvokeExpr ie = stmt.getInvokeExpr();
        this.addEdge(src, stmt, tgt, Edge.ieToKind(ie));
    }

    public class TraceBasedReflectionModel
    implements ReflectionModel {
        protected Set<Guard> guards = new HashSet<Guard>();
        protected ReflectionTraceInfo reflectionInfo;
        private boolean registeredTransformation = false;

        private TraceBasedReflectionModel() {
            String logFile = OnFlyCallGraphBuilder.this.options.reflection_log();
            if (logFile == null) {
                throw new InternalError("Trace based refection model enabled but no trace file given!?");
            }
            this.reflectionInfo = new ReflectionTraceInfo(logFile);
        }

        @Override
        public void classForName(SootMethod container2, Stmt forNameInvokeStmt) {
            Set<String> classNames = this.reflectionInfo.classForNameClassNames(container2);
            if (classNames == null || classNames.isEmpty()) {
                this.registerGuard(container2, forNameInvokeStmt, "Class.forName() call site; Soot did not expect this site to be reached");
            } else {
                for (String clsName : classNames) {
                    OnFlyCallGraphBuilder.this.constantForName(clsName, container2, forNameInvokeStmt);
                }
            }
        }

        @Override
        public void classNewInstance(SootMethod container2, Stmt newInstanceInvokeStmt) {
            Set<String> classNames = this.reflectionInfo.classNewInstanceClassNames(container2);
            if (classNames == null || classNames.isEmpty()) {
                this.registerGuard(container2, newInstanceInvokeStmt, "Class.newInstance() call site; Soot did not expect this site to be reached");
            } else {
                for (String clsName : classNames) {
                    SootClass cls = Scene.v().getSootClass(clsName);
                    SootMethod constructor = cls.getMethodUnsafe(OnFlyCallGraphBuilder.this.sigInit);
                    if (constructor == null) continue;
                    OnFlyCallGraphBuilder.this.addEdge(container2, newInstanceInvokeStmt, constructor, Kind.REFL_CLASS_NEWINSTANCE);
                }
            }
        }

        @Override
        public void contructorNewInstance(SootMethod container2, Stmt newInstanceInvokeStmt) {
            Set<String> constructorSignatures = this.reflectionInfo.constructorNewInstanceSignatures(container2);
            if (constructorSignatures == null || constructorSignatures.isEmpty()) {
                this.registerGuard(container2, newInstanceInvokeStmt, "Constructor.newInstance(..) call site; Soot did not expect this site to be reached");
            } else {
                for (String constructorSignature : constructorSignatures) {
                    SootMethod constructor = Scene.v().getMethod(constructorSignature);
                    OnFlyCallGraphBuilder.this.addEdge(container2, newInstanceInvokeStmt, constructor, Kind.REFL_CONSTR_NEWINSTANCE);
                }
            }
        }

        @Override
        public void methodInvoke(SootMethod container2, Stmt invokeStmt) {
            Set<String> methodSignatures = this.reflectionInfo.methodInvokeSignatures(container2);
            if (methodSignatures == null || methodSignatures.isEmpty()) {
                this.registerGuard(container2, invokeStmt, "Method.invoke(..) call site; Soot did not expect this site to be reached");
            } else {
                for (String methodSignature : methodSignatures) {
                    SootMethod method = Scene.v().getMethod(methodSignature);
                    OnFlyCallGraphBuilder.this.addEdge(container2, invokeStmt, method, Kind.REFL_INVOKE);
                }
            }
        }

        private void registerGuard(SootMethod container2, Stmt stmt, String string) {
            this.guards.add(new Guard(container2, stmt, string));
            if (OnFlyCallGraphBuilder.this.options.verbose()) {
                G.v().out.println("Incomplete trace file: Class.forName() is called in method '" + container2 + "' but trace contains no information about the receiver class of this call.");
                if (OnFlyCallGraphBuilder.this.options.guards().equals("ignore")) {
                    G.v().out.println("Guarding strategy is set to 'ignore'. Will ignore this problem.");
                } else if (OnFlyCallGraphBuilder.this.options.guards().equals("print")) {
                    G.v().out.println("Guarding strategy is set to 'print'. Program will print a stack trace if this location is reached during execution.");
                } else if (OnFlyCallGraphBuilder.this.options.guards().equals("throw")) {
                    G.v().out.println("Guarding strategy is set to 'throw'. Program will throw an Error if this location is reached during execution.");
                } else {
                    throw new RuntimeException("Invalid value for phase option (guarding): " + OnFlyCallGraphBuilder.this.options.guards());
                }
            }
            if (!this.registeredTransformation) {
                this.registeredTransformation = true;
                PackManager.v().getPack("wjap").add(new Transform("wjap.guards", new SceneTransformer(){

                    @Override
                    protected void internalTransform(String phaseName, Map<String, String> options) {
                        for (Guard g : TraceBasedReflectionModel.this.guards) {
                            TraceBasedReflectionModel.this.insertGuard(g);
                        }
                    }
                }));
                PhaseOptions.v().setPhaseOption("wjap.guards", "enabled");
            }
        }

        private void insertGuard(Guard guard) {
            if (OnFlyCallGraphBuilder.this.options.guards().equals("ignore")) {
                return;
            }
            SootMethod container2 = guard.container;
            Stmt insertionPoint = guard.stmt;
            if (!container2.hasActiveBody()) {
                G.v().out.println("WARNING: Tried to insert guard into " + container2 + " but couldn't because method has no body.");
            } else {
                Body body = container2.getActiveBody();
                RefType runtimeExceptionType = RefType.v("java.lang.Error");
                NewExpr newExpr = Jimple.v().newNewExpr(runtimeExceptionType);
                LocalGenerator lg = new LocalGenerator(body);
                Local exceptionLocal = lg.generateLocal(runtimeExceptionType);
                AssignStmt assignStmt = Jimple.v().newAssignStmt(exceptionLocal, newExpr);
                body.getUnits().insertBefore(assignStmt, (Unit)insertionPoint);
                SootMethodRef cref = runtimeExceptionType.getSootClass().getMethod("<init>", Collections.singletonList(RefType.v("java.lang.String"))).makeRef();
                SpecialInvokeExpr constructorInvokeExpr = Jimple.v().newSpecialInvokeExpr(exceptionLocal, cref, (Value)StringConstant.v(guard.message));
                InvokeStmt initStmt = Jimple.v().newInvokeStmt(constructorInvokeExpr);
                body.getUnits().insertAfter(initStmt, (Unit)assignStmt);
                if (OnFlyCallGraphBuilder.this.options.guards().equals("print")) {
                    VirtualInvokeExpr printStackTraceExpr = Jimple.v().newVirtualInvokeExpr(exceptionLocal, Scene.v().getSootClass("java.lang.Throwable").getMethod("printStackTrace", Collections.<Type>emptyList()).makeRef());
                    InvokeStmt printStackTraceStmt = Jimple.v().newInvokeStmt(printStackTraceExpr);
                    body.getUnits().insertAfter(printStackTraceStmt, (Unit)initStmt);
                } else if (OnFlyCallGraphBuilder.this.options.guards().equals("throw")) {
                    body.getUnits().insertAfter(Jimple.v().newThrowStmt(exceptionLocal), (Unit)initStmt);
                } else {
                    throw new RuntimeException("Invalid value for phase option (guarding): " + OnFlyCallGraphBuilder.this.options.guards());
                }
            }
        }

        class Guard {
            final SootMethod container;
            final Stmt stmt;
            final String message;

            public Guard(SootMethod container2, Stmt stmt, String message) {
                this.container = container2;
                this.stmt = stmt;
                this.message = message;
            }
        }
    }

    public class DefaultReflectionModel
    implements ReflectionModel {
        protected CGOptions options = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
        protected HashSet<SootMethod> warnedAlready = new HashSet();

        @Override
        public void classForName(SootMethod source, Stmt s) {
            InvokeExpr ie;
            Value className;
            ArrayList<Local> stringConstants = (ArrayList<Local>)OnFlyCallGraphBuilder.this.methodToStringConstants.get(source);
            if (stringConstants == null) {
                stringConstants = new ArrayList<Local>();
                OnFlyCallGraphBuilder.this.methodToStringConstants.put(source, stringConstants);
            }
            if ((className = (ie = s.getInvokeExpr()).getArg(0)) instanceof StringConstant) {
                String cls = ((StringConstant)className).value;
                OnFlyCallGraphBuilder.this.constantForName(cls, source, s);
            } else {
                Local constant = (Local)className;
                if (this.options.safe_forname()) {
                    for (SootMethod tgt : EntryPoints.v().clinits()) {
                        OnFlyCallGraphBuilder.this.addEdge(source, s, tgt, Kind.CLINIT);
                    }
                } else {
                    for (SootClass cls : Scene.v().dynamicClasses()) {
                        for (SootMethod clinit : EntryPoints.v().clinitsOf(cls)) {
                            OnFlyCallGraphBuilder.this.addEdge(source, s, clinit, Kind.CLINIT);
                        }
                    }
                    VirtualCallSite site = new VirtualCallSite(s, source, null, null, Kind.CLINIT);
                    ArrayList<VirtualCallSite> sites = (ArrayList<VirtualCallSite>)OnFlyCallGraphBuilder.this.stringConstToSites.get(constant);
                    if (sites == null) {
                        sites = new ArrayList<VirtualCallSite>();
                        OnFlyCallGraphBuilder.this.stringConstToSites.put(constant, sites);
                        stringConstants.add(constant);
                    }
                    sites.add(site);
                }
            }
        }

        @Override
        public void classNewInstance(SootMethod source, Stmt s) {
            if (this.options.safe_newinstance()) {
                for (SootMethod tgt : EntryPoints.v().inits()) {
                    OnFlyCallGraphBuilder.this.addEdge(source, s, tgt, Kind.NEWINSTANCE);
                }
            } else {
                for (SootClass cls : Scene.v().dynamicClasses()) {
                    SootMethod sm = cls.getMethodUnsafe(OnFlyCallGraphBuilder.this.sigInit);
                    if (sm == null) continue;
                    OnFlyCallGraphBuilder.this.addEdge(source, s, sm, Kind.NEWINSTANCE);
                }
                if (this.options.verbose()) {
                    G.v().out.println("Warning: Method " + source + " is reachable, and calls Class.newInstance;" + " graph will be incomplete!" + " Use safe-newinstance option for a conservative result.");
                }
            }
        }

        @Override
        public void contructorNewInstance(SootMethod source, Stmt s) {
            if (this.options.safe_newinstance()) {
                for (SootMethod tgt : EntryPoints.v().allInits()) {
                    OnFlyCallGraphBuilder.this.addEdge(source, s, tgt, Kind.NEWINSTANCE);
                }
            } else {
                for (SootClass cls : Scene.v().dynamicClasses()) {
                    for (SootMethod m : cls.getMethods()) {
                        if (!m.getName().equals("<init>")) continue;
                        OnFlyCallGraphBuilder.this.addEdge(source, s, m, Kind.NEWINSTANCE);
                    }
                }
                if (this.options.verbose()) {
                    G.v().out.println("Warning: Method " + source + " is reachable, and calls Constructor.newInstance;" + " graph will be incomplete!" + " Use safe-newinstance option for a conservative result.");
                }
            }
        }

        @Override
        public void methodInvoke(SootMethod container2, Stmt invokeStmt) {
            if (!this.warnedAlready(container2)) {
                if (this.options.verbose()) {
                    G.v().out.println("Warning: call to java.lang.reflect.Method: invoke() from " + container2 + "; graph will be incomplete!");
                }
                this.markWarned(container2);
            }
        }

        private void markWarned(SootMethod m) {
            this.warnedAlready.add(m);
        }

        private boolean warnedAlready(SootMethod m) {
            return this.warnedAlready.contains(m);
        }
    }
}

