/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import soot.G;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.ValNode;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.spark.solver.Propagator;
import soot.util.LargeNumberedMap;

public final class PropCycle
extends Propagator {
    private PAG pag;
    private OnFlyCallGraph ofcg;
    private Integer currentIteration;
    private final LargeNumberedMap<VarNode, Integer> varNodeToIteration;

    public PropCycle(PAG pag) {
        this.pag = pag;
        this.varNodeToIteration = new LargeNumberedMap(pag.getVarNodeNumberer());
    }

    @Override
    public final void propagate() {
        boolean changed;
        this.ofcg = this.pag.getOnFlyCallGraph();
        boolean verbose = this.pag.getOpts().verbose();
        AbstractCollection bases = new HashSet<VarNode>();
        for (FieldRefNode frn : this.pag.getFieldRefNodeNumberer()) {
            bases.add(frn.getBase());
        }
        bases = new ArrayList(bases);
        int iteration = 0;
        boolean finalIter = false;
        do {
            changed = false;
            this.currentIteration = new Integer(++iteration);
            if (verbose) {
                G.v().out.println("Iteration: " + iteration);
            }
            for (VarNode varNode : bases) {
                changed = this.computeP2Set((VarNode)varNode.getReplacement(), new ArrayList<VarNode>()) | changed;
            }
            if (this.ofcg != null) {
                throw new RuntimeException("NYI");
            }
            if (verbose) {
                G.v().out.println("Processing stores");
            }
            for (Object object : this.pag.storeSources()) {
                Node[] targets;
                final VarNode src = (VarNode)object;
                for (Node element0 : targets = this.pag.storeLookup(src)) {
                    final FieldRefNode target = (FieldRefNode)element0;
                    changed = target.getBase().makeP2Set().forall(new P2SetVisitor(){

                        @Override
                        public final void visit(Node n) {
                            AllocDotField nDotF = PropCycle.this.pag.makeAllocDotField((AllocNode)n, target.getField());
                            nDotF.makeP2Set().addAll(src.getP2Set(), null);
                        }
                    }) | changed;
                }
            }
            if (changed || finalIter) continue;
            finalIter = true;
            if (verbose) {
                G.v().out.println("Doing full graph");
            }
            bases = new ArrayList(this.pag.getVarNodeNumberer().size());
            for (VarNode varNode : this.pag.getVarNodeNumberer()) {
                bases.add(varNode);
            }
            changed = true;
        } while (changed);
    }

    private boolean computeP2Set(VarNode v, ArrayList<VarNode> path) {
        ValNode src;
        Node[] srcs;
        boolean ret = false;
        if (path.contains(v)) {
            return false;
        }
        if (this.currentIteration == this.varNodeToIteration.get(v)) {
            return false;
        }
        this.varNodeToIteration.put(v, this.currentIteration);
        path.add(v);
        if (v.getP2Set().isEmpty()) {
            for (Node element : srcs = this.pag.allocInvLookup(v)) {
                ret = v.makeP2Set().add(element) | ret;
            }
        }
        for (Node element : srcs = this.pag.simpleInvLookup(v)) {
            src = (VarNode)element;
            ret = this.computeP2Set((VarNode)src, path) | ret;
            ret = v.makeP2Set().addAll(src.getP2Set(), null) | ret;
        }
        for (Node element : srcs = this.pag.loadInvLookup(v)) {
            src = (FieldRefNode)element;
            ret = ((FieldRefNode)src).getBase().getP2Set().forall(new P2SetVisitor((FieldRefNode)src, v){
                final /* synthetic */ FieldRefNode val$src;
                final /* synthetic */ VarNode val$v;
                {
                    this.val$src = fieldRefNode;
                    this.val$v = varNode;
                }

                @Override
                public final void visit(Node n) {
                    AllocNode an = (AllocNode)n;
                    AllocDotField adf = PropCycle.this.pag.makeAllocDotField(an, this.val$src.getField());
                    this.returnValue = this.val$v.makeP2Set().addAll(adf.getP2Set(), null) | this.returnValue;
                }
            }) | ret;
        }
        path.remove(path.size() - 1);
        return ret;
    }
}

