/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.bafTransformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import soot.Body;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.IntegerType;
import soot.Local;
import soot.LongType;
import soot.PatchingChain;
import soot.RefLikeType;
import soot.RefType;
import soot.SootMethod;
import soot.StmtAddressType;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.VoidType;
import soot.baf.AddInst;
import soot.baf.AndInst;
import soot.baf.ArrayLengthInst;
import soot.baf.ArrayReadInst;
import soot.baf.ArrayWriteInst;
import soot.baf.BafBody;
import soot.baf.CmpInst;
import soot.baf.CmpgInst;
import soot.baf.CmplInst;
import soot.baf.DivInst;
import soot.baf.Dup1Inst;
import soot.baf.Dup1_x1Inst;
import soot.baf.Dup1_x2Inst;
import soot.baf.Dup2Inst;
import soot.baf.Dup2_x1Inst;
import soot.baf.Dup2_x2Inst;
import soot.baf.DynamicInvokeInst;
import soot.baf.EnterMonitorInst;
import soot.baf.ExitMonitorInst;
import soot.baf.FieldGetInst;
import soot.baf.FieldPutInst;
import soot.baf.GotoInst;
import soot.baf.IdentityInst;
import soot.baf.IfCmpEqInst;
import soot.baf.IfCmpGeInst;
import soot.baf.IfCmpGtInst;
import soot.baf.IfCmpLeInst;
import soot.baf.IfCmpLtInst;
import soot.baf.IfCmpNeInst;
import soot.baf.IfEqInst;
import soot.baf.IfGeInst;
import soot.baf.IfGtInst;
import soot.baf.IfLeInst;
import soot.baf.IfLtInst;
import soot.baf.IfNeInst;
import soot.baf.IfNonNullInst;
import soot.baf.IfNullInst;
import soot.baf.IncInst;
import soot.baf.Inst;
import soot.baf.InstSwitch;
import soot.baf.InstanceCastInst;
import soot.baf.InstanceOfInst;
import soot.baf.InterfaceInvokeInst;
import soot.baf.JSRInst;
import soot.baf.LoadInst;
import soot.baf.LookupSwitchInst;
import soot.baf.MethodArgInst;
import soot.baf.MulInst;
import soot.baf.NegInst;
import soot.baf.NewArrayInst;
import soot.baf.NewInst;
import soot.baf.NewMultiArrayInst;
import soot.baf.NopInst;
import soot.baf.OpTypeArgInst;
import soot.baf.OrInst;
import soot.baf.PopInst;
import soot.baf.PrimitiveCastInst;
import soot.baf.PushInst;
import soot.baf.RemInst;
import soot.baf.ReturnInst;
import soot.baf.ReturnVoidInst;
import soot.baf.ShlInst;
import soot.baf.ShrInst;
import soot.baf.SpecialInvokeInst;
import soot.baf.StaticGetInst;
import soot.baf.StaticInvokeInst;
import soot.baf.StaticPutInst;
import soot.baf.StoreInst;
import soot.baf.SubInst;
import soot.baf.SwapInst;
import soot.baf.TableSwitchInst;
import soot.baf.TargetArgInst;
import soot.baf.ThrowInst;
import soot.baf.UshrInst;
import soot.baf.VirtualInvokeInst;
import soot.baf.XorInst;
import soot.baf.internal.AbstractOpTypeInst;
import soot.baf.internal.BPopInst;
import soot.jbco.util.Debugger;
import soot.toolkits.graph.BriefUnitGraph;
import soot.util.Chain;

public class StackTypeHeightCalculator {
    public static StackEffectSwitch sw = new StackTypeHeightCalculator().new StackEffectSwitch();
    public static BriefUnitGraph bug = null;

    public static Map<Unit, Stack<Type>> calculateStackHeights(Body b, Map<Local, Local> b2JLocs) {
        StackTypeHeightCalculator.sw.bafToJLocals = b2JLocs;
        return StackTypeHeightCalculator.calculateStackHeights(b, true);
    }

    public static Map<Unit, Stack<Type>> calculateStackHeights(Body b) {
        StackTypeHeightCalculator.sw.bafToJLocals = null;
        return StackTypeHeightCalculator.calculateStackHeights(b, false);
    }

    public static Map<Unit, Stack<Type>> calculateStackHeights(Body b, boolean jimpleLocals) {
        if (!(b instanceof BafBody)) {
            throw new RuntimeException("Expecting Baf Body");
        }
        HashMap<Unit, Stack<Type>> results = new HashMap<Unit, Stack<Type>>();
        bug = new BriefUnitGraph(b);
        List<Unit> heads = bug.getHeads();
        for (int i = 0; i < heads.size(); ++i) {
            Unit h = heads.get(i);
            RefType handlerExc = StackTypeHeightCalculator.isHandlerUnit(b.getTraps(), h);
            Stack<Object> stack = (Stack<RefType>)results.get(h);
            if (stack != null) {
                if (stack.size() == (handlerExc != null ? 1 : 0)) continue;
                throw new RuntimeException("Problem with stack height - head expects ZERO or one if handler");
            }
            ArrayList<Unit> worklist = new ArrayList<Unit>();
            stack = new Stack<RefType>();
            if (handlerExc != null) {
                stack.push(handlerExc);
            }
            results.put(h, stack);
            worklist.add(h);
            while (!worklist.isEmpty()) {
                Inst inst = (Inst)worklist.remove(0);
                inst.apply(sw);
                try {
                    stack = StackTypeHeightCalculator.updateStack(sw, (Stack<Type>)((Stack)results.get(inst)));
                }
                catch (RuntimeException rexc) {
                    StackTypeHeightCalculator.printStack(b.getUnits(), results, false);
                    System.exit(1);
                }
                for (Unit next : bug.getSuccsOf(inst)) {
                    Stack nxtStck = (Stack)results.get(next);
                    if (nxtStck != null) {
                        if (nxtStck.size() == stack.size()) continue;
                        StackTypeHeightCalculator.printStack(b.getUnits(), results, false);
                        throw new RuntimeException("Problem with stack height at: " + next + "\n\rHas Stack " + nxtStck + " but is expecting " + stack);
                    }
                    results.put(next, stack);
                    worklist.add(next);
                }
            }
        }
        return results;
    }

    public static Stack<Type> updateStack(Unit u, Stack<Type> st) {
        u.apply(sw);
        return StackTypeHeightCalculator.updateStack(sw, st);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Stack<Type> updateStack(StackEffectSwitch sw, Stack<Type> st) {
        Stack clone = (Stack)st.clone();
        if (sw.remove_types != null) {
            if (sw.remove_types.length > clone.size()) {
                String exc = "Expecting values on stack: ";
                for (Type element : sw.remove_types) {
                    String type = element.toString();
                    if (type.trim().length() == 0) {
                        type = element instanceof RefLikeType ? "L" : "U";
                    }
                    exc = exc + type + "  ";
                }
                exc = exc + "\n\tbut only found: ";
                for (int i = 0; i < clone.size(); ++i) {
                    String type = ((Type)clone.get(i)).toString();
                    if (type.trim().length() == 0) {
                        type = clone.get(i) instanceof RefLikeType ? "L" : "U";
                    }
                    exc = exc + type + "  ";
                }
                if (sw.shouldThrow) {
                    throw new RuntimeException(exc);
                }
                G.v().out.println(exc);
            }
            for (int i = sw.remove_types.length - 1; i >= 0; --i) {
                try {
                    Type t = (Type)clone.pop();
                    if (!StackTypeHeightCalculator.checkTypes(t, sw.remove_types[i])) continue;
                    continue;
                }
                catch (Exception exc) {
                    return null;
                }
            }
        }
        if (sw.add_types != null) {
            for (Type element : sw.add_types) {
                clone.push(element);
            }
        }
        return clone;
    }

    private static boolean checkTypes(Type t1, Type t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 instanceof RefLikeType && t2 instanceof RefLikeType) {
            return true;
        }
        if (t1 instanceof IntegerType && t2 instanceof IntegerType) {
            return true;
        }
        if (t1 instanceof LongType && t2 instanceof LongType) {
            return true;
        }
        if (t1 instanceof DoubleType && t2 instanceof DoubleType) {
            return true;
        }
        return t1 instanceof FloatType && t2 instanceof FloatType;
    }

    public static void printStack(PatchingChain<Unit> units, Map<Unit, Stack<Type>> stacks, boolean before) {
        int count = 0;
        StackTypeHeightCalculator.sw.shouldThrow = false;
        HashMap<Unit, Integer> indexes = new HashMap<Unit, Integer>();
        Iterator<Unit> it = units.snapshotIterator();
        while (it.hasNext()) {
            indexes.put(it.next(), new Integer(count++));
        }
        it = units.snapshotIterator();
        while (it.hasNext()) {
            String s = "";
            Unit unit = it.next();
            if (unit instanceof TargetArgInst) {
                Unit t = ((TargetArgInst)unit).getTarget();
                s = ((Integer)indexes.get(t)).toString();
            } else if (unit instanceof TableSwitchInst) {
                TableSwitchInst tswi = (TableSwitchInst)unit;
                s = s + "\r\tdefault: " + tswi.getDefaultTarget() + "  " + indexes.get(tswi.getDefaultTarget());
                int index = 0;
                for (int x = tswi.getLowIndex(); x <= tswi.getHighIndex(); ++x) {
                    s = s + "\r\t " + x + ": " + tswi.getTarget(index) + "  " + indexes.get(tswi.getTarget(index++));
                }
            }
            try {
                s = indexes.get(unit) + " " + unit + "  " + s + "   [";
            }
            catch (Exception e) {
                G.v().out.println("Error in StackTypeHeightCalculator trying to find index of unit");
            }
            Stack<Type> stack = stacks.get(unit);
            if (stack != null) {
                if (!before) {
                    unit.apply(sw);
                    stack = StackTypeHeightCalculator.updateStack(sw, stack);
                    if (stack == null) {
                        Debugger.printUnits(units, " StackTypeHeightCalc failed");
                        StackTypeHeightCalculator.sw.shouldThrow = true;
                        return;
                    }
                }
                for (int i = 0; i < stack.size(); ++i) {
                    s = s + StackTypeHeightCalculator.printType((Type)stack.get(i));
                }
            } else {
                s = s + "***missing***";
            }
            System.out.println(s + "]");
        }
        StackTypeHeightCalculator.sw.shouldThrow = true;
    }

    private static String printType(Type t) {
        if (t instanceof IntegerType) {
            return "I";
        }
        if (t instanceof FloatType) {
            return "F";
        }
        if (t instanceof DoubleType) {
            return "D";
        }
        if (t instanceof LongType) {
            return "J";
        }
        if (t instanceof RefLikeType) {
            return "L" + t.toString();
        }
        return "U(" + t.getClass().toString() + ")";
    }

    private static RefType isHandlerUnit(Chain<Trap> traps, Unit h) {
        for (Trap t : traps) {
            if (t.getHandlerUnit() != h) continue;
            return t.getException().getType();
        }
        return null;
    }

    public static Stack<Type> getAfterStack(Body b, Unit u) {
        Stack<Type> stack = StackTypeHeightCalculator.calculateStackHeights(b).get(u);
        u.apply(sw);
        return StackTypeHeightCalculator.updateStack(sw, stack);
    }

    public static Stack<Type> getAfterStack(Stack<Type> beforeStack, Unit u) {
        u.apply(sw);
        return StackTypeHeightCalculator.updateStack(sw, beforeStack);
    }

    protected class StackEffectSwitch
    implements InstSwitch {
        public boolean shouldThrow = true;
        public Map<Local, Local> bafToJLocals = null;
        public Type[] remove_types = null;
        public Type[] add_types = null;

        protected StackEffectSwitch() {
        }

        @Override
        public void caseReturnInst(ReturnInst i) {
            this.remove_types = new Type[]{i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseReturnVoidInst(ReturnVoidInst i) {
            this.remove_types = null;
            this.add_types = null;
        }

        @Override
        public void caseNopInst(NopInst i) {
            this.remove_types = null;
            this.add_types = null;
        }

        @Override
        public void caseGotoInst(GotoInst i) {
            this.remove_types = null;
            this.add_types = null;
        }

        @Override
        public void caseJSRInst(JSRInst i) {
            this.remove_types = null;
            this.add_types = new Type[]{StmtAddressType.v()};
        }

        @Override
        public void casePushInst(PushInst i) {
            this.remove_types = null;
            this.add_types = new Type[]{i.getConstant().getType()};
        }

        @Override
        public void casePopInst(PopInst i) {
            this.remove_types = new Type[]{((BPopInst)i).getType()};
            this.add_types = null;
        }

        @Override
        public void caseIdentityInst(IdentityInst i) {
            this.remove_types = null;
            this.add_types = null;
        }

        @Override
        public void caseStoreInst(StoreInst i) {
            this.remove_types = new Type[]{((AbstractOpTypeInst)((Object)i)).getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseLoadInst(LoadInst i) {
            Local jl;
            this.remove_types = null;
            this.add_types = null;
            if (this.bafToJLocals != null && (jl = this.bafToJLocals.get(i.getLocal())) != null) {
                this.add_types = new Type[]{jl.getType()};
            }
            if (this.add_types == null) {
                this.add_types = new Type[]{i.getOpType()};
            }
        }

        @Override
        public void caseArrayWriteInst(ArrayWriteInst i) {
            this.remove_types = new Type[]{RefType.v(), IntType.v(), i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseArrayReadInst(ArrayReadInst i) {
            this.remove_types = new Type[]{RefType.v(), IntType.v()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseIfNullInst(IfNullInst i) {
            this.remove_types = new Type[]{RefType.v("java.lang.Object")};
            this.add_types = null;
        }

        @Override
        public void caseIfNonNullInst(IfNonNullInst i) {
            this.remove_types = new Type[]{RefType.v("java.lang.Object")};
            this.add_types = null;
        }

        @Override
        public void caseIfEqInst(IfEqInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseIfNeInst(IfNeInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseIfGtInst(IfGtInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseIfGeInst(IfGeInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseIfLtInst(IfLtInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseIfLeInst(IfLeInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseIfCmpEqInst(IfCmpEqInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseIfCmpNeInst(IfCmpNeInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseIfCmpGtInst(IfCmpGtInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseIfCmpGeInst(IfCmpGeInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseIfCmpLtInst(IfCmpLtInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseIfCmpLeInst(IfCmpLeInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = null;
        }

        @Override
        public void caseStaticGetInst(StaticGetInst i) {
            this.remove_types = null;
            this.add_types = new Type[]{i.getField().getType()};
        }

        @Override
        public void caseStaticPutInst(StaticPutInst i) {
            this.remove_types = new Type[]{i.getField().getType()};
            this.add_types = null;
        }

        @Override
        public void caseFieldGetInst(FieldGetInst i) {
            this.remove_types = new Type[]{i.getField().getDeclaringClass().getType()};
            this.add_types = new Type[]{i.getField().getType()};
        }

        @Override
        public void caseFieldPutInst(FieldPutInst i) {
            this.remove_types = new Type[]{i.getField().getDeclaringClass().getType(), i.getField().getType()};
            this.add_types = null;
        }

        @Override
        public void caseInstanceCastInst(InstanceCastInst i) {
            this.remove_types = new Type[]{RefType.v("java.lang.Object")};
            this.add_types = new Type[]{i.getCastType()};
        }

        @Override
        public void caseInstanceOfInst(InstanceOfInst i) {
            this.remove_types = new Type[]{RefType.v("java.lang.Object")};
            this.add_types = new Type[]{IntType.v()};
        }

        @Override
        public void casePrimitiveCastInst(PrimitiveCastInst i) {
            this.remove_types = new Type[]{i.getFromType()};
            this.add_types = new Type[]{i.getToType()};
        }

        @Override
        public void caseDynamicInvokeInst(DynamicInvokeInst i) {
            SootMethod m = i.getMethod();
            Object[] args = m.getParameterTypes().toArray();
            this.remove_types = new Type[args.length];
            for (int ii = 0; ii < args.length; ++ii) {
                this.remove_types[ii] = (Type)args[ii];
            }
            this.add_types = m.getReturnType() instanceof VoidType ? null : new Type[]{m.getReturnType()};
        }

        @Override
        public void caseStaticInvokeInst(StaticInvokeInst i) {
            SootMethod m = i.getMethod();
            Object[] args = m.getParameterTypes().toArray();
            this.remove_types = new Type[args.length];
            for (int ii = 0; ii < args.length; ++ii) {
                this.remove_types[ii] = (Type)args[ii];
            }
            this.add_types = m.getReturnType() instanceof VoidType ? null : new Type[]{m.getReturnType()};
        }

        private void instanceinvoke(MethodArgInst i) {
            SootMethod m = i.getMethod();
            int length = m.getParameterCount();
            this.remove_types = new Type[length + 1];
            this.remove_types[0] = RefType.v();
            System.arraycopy(m.getParameterTypes().toArray(), 0, this.remove_types, 1, length);
            this.add_types = m.getReturnType() instanceof VoidType ? null : new Type[]{m.getReturnType()};
        }

        @Override
        public void caseVirtualInvokeInst(VirtualInvokeInst i) {
            this.instanceinvoke(i);
        }

        @Override
        public void caseInterfaceInvokeInst(InterfaceInvokeInst i) {
            this.instanceinvoke(i);
        }

        @Override
        public void caseSpecialInvokeInst(SpecialInvokeInst i) {
            this.instanceinvoke(i);
        }

        @Override
        public void caseThrowInst(ThrowInst i) {
            this.remove_types = new Type[]{RefType.v("java.lang.Throwable")};
            this.add_types = null;
        }

        @Override
        public void caseAddInst(AddInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        private void bitOps(OpTypeArgInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseAndInst(AndInst i) {
            this.bitOps(i);
        }

        @Override
        public void caseOrInst(OrInst i) {
            this.bitOps(i);
        }

        @Override
        public void caseXorInst(XorInst i) {
            this.bitOps(i);
        }

        @Override
        public void caseArrayLengthInst(ArrayLengthInst i) {
            this.remove_types = new Type[]{RefType.v()};
            this.add_types = new Type[]{IntType.v()};
        }

        @Override
        public void caseCmpInst(CmpInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{IntType.v()};
        }

        @Override
        public void caseCmpgInst(CmpgInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{IntType.v()};
        }

        @Override
        public void caseCmplInst(CmplInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{IntType.v()};
        }

        @Override
        public void caseDivInst(DivInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseIncInst(IncInst i) {
            this.remove_types = null;
            this.add_types = null;
        }

        @Override
        public void caseMulInst(MulInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseRemInst(RemInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseSubInst(SubInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseShlInst(ShlInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseShrInst(ShrInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseUshrInst(UshrInst i) {
            this.remove_types = new Type[]{i.getOpType(), i.getOpType()};
            this.add_types = new Type[]{i.getOpType()};
        }

        @Override
        public void caseNewInst(NewInst i) {
            this.remove_types = null;
            this.add_types = new Type[]{i.getBaseType()};
        }

        @Override
        public void caseNegInst(NegInst i) {
            this.remove_types = null;
            this.add_types = null;
        }

        @Override
        public void caseSwapInst(SwapInst i) {
            this.remove_types = new Type[]{i.getFromType(), i.getToType()};
            this.add_types = new Type[]{i.getToType(), i.getFromType()};
        }

        @Override
        public void caseDup1Inst(Dup1Inst i) {
            this.remove_types = new Type[]{i.getOp1Type()};
            this.add_types = new Type[]{i.getOp1Type(), i.getOp1Type()};
        }

        @Override
        public void caseDup2Inst(Dup2Inst i) {
            if (!(i.getOp1Type() instanceof DoubleType) && !(i.getOp1Type() instanceof LongType)) {
                this.add_types = new Type[]{i.getOp2Type(), i.getOp1Type()};
                this.remove_types = null;
            } else {
                this.add_types = new Type[]{i.getOp1Type()};
                this.remove_types = null;
            }
        }

        @Override
        public void caseDup1_x1Inst(Dup1_x1Inst i) {
            this.remove_types = new Type[]{i.getUnder1Type(), i.getOp1Type()};
            this.add_types = new Type[]{i.getOp1Type(), i.getUnder1Type(), i.getOp1Type()};
        }

        @Override
        public void caseDup1_x2Inst(Dup1_x2Inst i) {
            Type u1 = i.getUnder1Type();
            if (u1 instanceof DoubleType || u1 instanceof LongType) {
                this.remove_types = new Type[]{u1, i.getOp1Type()};
                this.add_types = new Type[]{i.getOp1Type(), u1, i.getOp1Type()};
            } else {
                this.remove_types = new Type[]{i.getUnder2Type(), u1, i.getOp1Type()};
                this.add_types = new Type[]{i.getOp1Type(), i.getUnder2Type(), u1, i.getOp1Type()};
            }
        }

        @Override
        public void caseDup2_x1Inst(Dup2_x1Inst i) {
            Type ot = i.getOp1Type();
            if (ot instanceof DoubleType || ot instanceof LongType) {
                this.remove_types = new Type[]{i.getUnder1Type(), ot};
                this.add_types = new Type[]{ot, i.getUnder1Type(), ot};
            } else {
                this.remove_types = new Type[]{i.getUnder1Type(), i.getOp2Type(), ot};
                this.add_types = new Type[]{i.getOp2Type(), ot, i.getUnder1Type(), i.getOp2Type(), ot};
            }
        }

        @Override
        public void caseDup2_x2Inst(Dup2_x2Inst i) {
            Type u1 = i.getUnder1Type();
            Type o1 = i.getOp1Type();
            if (u1 instanceof DoubleType || u1 instanceof LongType) {
                if (o1 instanceof DoubleType || o1 instanceof LongType) {
                    this.remove_types = new Type[]{u1, o1};
                    this.add_types = new Type[]{o1, u1, o1};
                } else {
                    this.remove_types = new Type[]{u1, i.getOp2Type(), o1};
                    this.add_types = new Type[]{i.getOp2Type(), o1, u1, i.getOp2Type(), o1};
                }
            } else if (o1 instanceof DoubleType || o1 instanceof LongType) {
                this.remove_types = new Type[]{i.getUnder2Type(), u1, o1};
                this.add_types = new Type[]{o1, i.getUnder2Type(), u1, o1};
            } else {
                this.remove_types = new Type[]{i.getUnder2Type(), u1, i.getOp2Type(), o1};
                this.add_types = new Type[]{i.getOp2Type(), o1, i.getUnder2Type(), u1, i.getOp2Type(), o1};
            }
        }

        @Override
        public void caseNewArrayInst(NewArrayInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = new Type[]{RefType.v()};
        }

        @Override
        public void caseNewMultiArrayInst(NewMultiArrayInst i) {
            this.remove_types = new Type[i.getDimensionCount()];
            for (int ii = 0; ii < this.remove_types.length; ++ii) {
                this.remove_types[ii] = IntType.v();
            }
            this.add_types = new Type[]{RefType.v()};
        }

        @Override
        public void caseLookupSwitchInst(LookupSwitchInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseTableSwitchInst(TableSwitchInst i) {
            this.remove_types = new Type[]{IntType.v()};
            this.add_types = null;
        }

        @Override
        public void caseEnterMonitorInst(EnterMonitorInst i) {
            this.remove_types = new Type[]{RefType.v("java.lang.Object")};
            this.add_types = null;
        }

        @Override
        public void caseExitMonitorInst(ExitMonitorInst i) {
            this.remove_types = new Type[]{RefType.v("java.lang.Object")};
            this.add_types = null;
        }
    }
}

