/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import soot.G;
import soot.HasPhaseOptions;
import soot.Pack;
import soot.PackManager;
import soot.RadioScenePack;
import soot.Singletons;
import soot.Transform;

public class PhaseOptions {
    private PackManager pm;
    private final Map<HasPhaseOptions, Map<String, String>> phaseToOptionMap = new HashMap<HasPhaseOptions, Map<String, String>>();

    public void setPackManager(PackManager m) {
        this.pm = m;
    }

    PackManager getPM() {
        if (this.pm == null) {
            PackManager.v();
        }
        return this.pm;
    }

    public PhaseOptions(Singletons.Global g) {
    }

    public static PhaseOptions v() {
        return G.v().soot_PhaseOptions();
    }

    public Map<String, String> getPhaseOptions(String phaseName) {
        return this.getPhaseOptions(this.getPM().getPhase(phaseName));
    }

    public Map<String, String> getPhaseOptions(HasPhaseOptions phase) {
        Map<String, String> ret = this.phaseToOptionMap.get(phase);
        ret = ret == null ? new HashMap<String, String>() : new HashMap<String, String>(ret);
        StringTokenizer st = new StringTokenizer(phase.getDefaultOptions());
        while (st.hasMoreTokens()) {
            String opt = st.nextToken();
            String key = this.getKey(opt);
            String value = this.getValue(opt);
            if (ret.containsKey(key)) continue;
            ret.put(key, value);
        }
        return Collections.unmodifiableMap(ret);
    }

    public boolean processPhaseOptions(String phaseName, String option) {
        StringTokenizer st = new StringTokenizer(option, ",");
        while (st.hasMoreTokens()) {
            if (this.setPhaseOption(phaseName, st.nextToken())) continue;
            return false;
        }
        return true;
    }

    public static boolean getBoolean(Map<String, String> options, String name) {
        return options.containsKey(name) && options.get(name).equals("true");
    }

    public static boolean getBoolean(Map<String, String> options, String name, boolean defaultValue) {
        if (!options.containsKey(name)) {
            return defaultValue;
        }
        return options.get(name).equals("true");
    }

    public static String getString(Map<String, String> options, String name) {
        return options.containsKey(name) ? options.get(name) : "";
    }

    public static float getFloat(Map<String, String> options, String name) {
        return options.containsKey(name) ? new Float(options.get(name)).floatValue() : 1.0f;
    }

    public static int getInt(Map<String, String> options, String name) {
        return options.containsKey(name) ? new Integer(options.get(name)) : 0;
    }

    private Map<String, String> mapForPhase(String phaseName) {
        HasPhaseOptions phase = this.getPM().getPhase(phaseName);
        if (phase == null) {
            return null;
        }
        return this.mapForPhase(phase);
    }

    private Map<String, String> mapForPhase(HasPhaseOptions phase) {
        Map<String, String> optionMap = this.phaseToOptionMap.get(phase);
        if (optionMap == null) {
            optionMap = new HashMap<String, String>();
            this.phaseToOptionMap.put(phase, optionMap);
        }
        return optionMap;
    }

    private String getKey(String option) {
        int delimLoc = option.indexOf(":");
        if (delimLoc < 0) {
            if (option.equals("on") || option.equals("off")) {
                return "enabled";
            }
            return option;
        }
        return option.substring(0, delimLoc);
    }

    private String getValue(String option) {
        int delimLoc = option.indexOf(":");
        if (delimLoc < 0) {
            if (option.equals("off")) {
                return "false";
            }
            return "true";
        }
        return option.substring(delimLoc + 1);
    }

    private void resetRadioPack(String phaseName) {
        for (Pack p : this.getPM().allPacks()) {
            if (!(p instanceof RadioScenePack) || p.get(phaseName) == null) continue;
            for (Transform t : p) {
                this.setPhaseOption(t.getPhaseName(), "enabled:false");
            }
        }
    }

    private boolean checkParentEnabled(String phaseName) {
        return true;
    }

    public boolean setPhaseOption(String phaseName, String option) {
        HasPhaseOptions phase = this.getPM().getPhase(phaseName);
        if (phase == null) {
            G.v().out.println("Option " + option + " given for nonexistent" + " phase " + phaseName);
            return false;
        }
        return this.setPhaseOption(phase, option);
    }

    public boolean setPhaseOption(HasPhaseOptions phase, String option) {
        Map<String, String> optionMap = this.mapForPhase(phase);
        if (!this.checkParentEnabled(phase.getPhaseName())) {
            return false;
        }
        if (optionMap == null) {
            G.v().out.println("Option " + option + " given for nonexistent" + " phase " + phase.getPhaseName());
            return false;
        }
        String key = this.getKey(option);
        if (key.equals("enabled") && this.getValue(option).equals("true")) {
            this.resetRadioPack(phase.getPhaseName());
        }
        if (this.declaresOption(phase, key)) {
            optionMap.put(key, this.getValue(option));
            return true;
        }
        G.v().out.println("Invalid option " + option + " for phase " + phase.getPhaseName());
        return false;
    }

    private boolean declaresOption(String phaseName, String option) {
        HasPhaseOptions phase = this.getPM().getPhase(phaseName);
        return this.declaresOption(phase, option);
    }

    private boolean declaresOption(HasPhaseOptions phase, String option) {
        String declareds = phase.getDeclaredOptions();
        StringTokenizer st = new StringTokenizer(declareds);
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals(option)) continue;
            return true;
        }
        return false;
    }

    public void setPhaseOptionIfUnset(String phaseName, String option) {
        Map<String, String> optionMap = this.mapForPhase(phaseName);
        if (optionMap == null) {
            throw new RuntimeException("No such phase " + phaseName);
        }
        if (optionMap.containsKey(this.getKey(option))) {
            return;
        }
        if (!this.declaresOption(phaseName, this.getKey(option))) {
            throw new RuntimeException("No option " + option + " for phase " + phaseName);
        }
        optionMap.put(this.getKey(option), this.getValue(option));
    }
}

