/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import soot.JastAddJ.BytecodeReader;
import soot.JastAddJ.CompilationUnit;
import soot.JastAddJ.JavaParser;
import soot.JastAddJ.Options;
import soot.JastAddJ.Program;

public class Frontend {
    protected Program program = new Program();

    protected Frontend() {
        this.program.state().reset();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(String[] args, BytecodeReader reader, JavaParser parser2) {
        this.program.initBytecodeReader(reader);
        this.program.initJavaParser(parser2);
        this.initOptions();
        this.processArgs(args);
        Collection files = this.program.options().files();
        if (this.program.options().hasOption("-version")) {
            this.printVersion();
            return true;
        }
        if (this.program.options().hasOption("-help") || files.isEmpty()) {
            this.printUsage();
            return true;
        }
        try {
            for (String name : files) {
                if (!new File(name).exists()) {
                    System.err.println("WARNING: file \"" + name + "\" does not exist");
                }
                this.program.addSourceFile(name);
            }
            Iterator iter = this.program.compilationUnitIterator();
            while (iter.hasNext()) {
                CompilationUnit unit = (CompilationUnit)iter.next();
                if (!unit.fromSource()) continue;
                try {
                    Collection errors = unit.parseErrors();
                    LinkedList warnings = new LinkedList();
                    if (errors.isEmpty() || this.program.options().hasOption("-recover")) {
                        unit.errorCheck(errors, warnings);
                    }
                    if (!errors.isEmpty()) {
                        this.processErrors(errors, unit);
                        return false;
                    }
                    if (!warnings.isEmpty()) {
                        this.processWarnings(warnings, unit);
                    }
                    this.processNoErrors(unit);
                }
                catch (Throwable t) {
                    System.err.println("Errors:");
                    System.err.println("Fatal exception while processing " + unit.pathName() + ":");
                    t.printStackTrace(System.err);
                    return false;
                }
            }
            return true;
        }
        catch (Throwable t) {
            System.err.println("Errors:");
            System.err.println("Fatal exception:");
            t.printStackTrace(System.err);
            return false;
        }
    }

    protected void initOptions() {
        Options options = this.program.options();
        options.initOptions();
        options.addKeyOption("-version");
        options.addKeyOption("-print");
        options.addKeyOption("-g");
        options.addKeyOption("-g:none");
        options.addKeyOption("-g:lines,vars,source");
        options.addKeyOption("-nowarn");
        options.addKeyOption("-verbose");
        options.addKeyOption("-deprecation");
        options.addKeyValueOption("-classpath");
        options.addKeyValueOption("-cp");
        options.addKeyValueOption("-sourcepath");
        options.addKeyValueOption("-bootclasspath");
        options.addKeyValueOption("-extdirs");
        options.addKeyValueOption("-d");
        options.addKeyValueOption("-encoding");
        options.addKeyValueOption("-source");
        options.addKeyValueOption("-target");
        options.addKeyOption("-help");
        options.addKeyOption("-O");
        options.addKeyOption("-J-Xmx128M");
        options.addKeyOption("-recover");
    }

    protected void processArgs(String[] args) {
        this.program.options().addOptions(args);
    }

    protected void processErrors(Collection errors, CompilationUnit unit) {
        System.err.println("Errors:");
        Iterator iter2 = errors.iterator();
        while (iter2.hasNext()) {
            System.err.println(iter2.next());
        }
    }

    protected void processWarnings(Collection warnings, CompilationUnit unit) {
        System.err.println("Warnings:");
        Iterator iter2 = warnings.iterator();
        while (iter2.hasNext()) {
            System.err.println(iter2.next());
        }
    }

    protected void processNoErrors(CompilationUnit unit) {
    }

    protected void printUsage() {
        this.printLongVersion();
        System.out.println("\n" + this.name() + "\n\n" + "Usage: java " + this.name() + " <options> <source files>\n" + "  -verbose                  Output messages about what the compiler is doing\n" + "  -classpath <path>         Specify where to find user class files\n" + "  -sourcepath <path>        Specify where to find input source files\n" + "  -bootclasspath <path>     Override location of bootstrap class files\n" + "  -extdirs <dirs>           Override location of installed extensions\n" + "  -d <directory>            Specify where to place generated class files\n" + "  -help                     Print a synopsis of standard options\n" + "  -version                  Print version information\n");
    }

    protected void printLongVersion() {
        System.out.println(this.name() + " " + this.url() + " Version " + this.version());
    }

    protected void printVersion() {
        System.out.println(this.name() + " " + this.version());
    }

    protected String name() {
        return "Java1.4Frontend";
    }

    protected String url() {
        return "(http://jastadd.cs.lth.se)";
    }

    protected String version() {
        return "R20070504";
    }
}

