/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.jf.util.ExceptionWithContext;

public class DexDataWriter
extends BufferedOutputStream {
    private int filePosition;
    private byte[] tempBuf = new byte[8];
    private byte[] zeroBuf = new byte[3];

    public DexDataWriter(@Nonnull OutputStream output, int filePosition) {
        this(output, filePosition, 262144);
    }

    public DexDataWriter(@Nonnull OutputStream output, int filePosition, int bufferSize) {
        super(output, bufferSize);
        this.filePosition = filePosition;
    }

    @Override
    public void write(int b) throws IOException {
        ++this.filePosition;
        super.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.filePosition += len;
        super.write(b, off, len);
    }

    public void writeLong(long value) throws IOException {
        this.writeInt((int)value);
        this.writeInt((int)(value >> 32));
    }

    public static void writeInt(OutputStream out, int value) throws IOException {
        out.write(value);
        out.write(value >> 8);
        out.write(value >> 16);
        out.write(value >> 24);
    }

    public void writeInt(int value) throws IOException {
        DexDataWriter.writeInt(this, value);
    }

    public void writeShort(int value) throws IOException {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new ExceptionWithContext("Short value out of range: %d", value);
        }
        this.write(value);
        this.write(value >> 8);
    }

    public void writeUshort(int value) throws IOException {
        if (value < 0 || value > 65535) {
            throw new ExceptionWithContext("Unsigned short value out of range: %d", value);
        }
        this.write(value);
        this.write(value >> 8);
    }

    public void writeUbyte(int value) throws IOException {
        if (value < 0 || value > 255) {
            throw new ExceptionWithContext("Unsigned byte value out of range: %d", value);
        }
        this.write(value);
    }

    public static void writeUleb128(OutputStream out, int value) throws IOException {
        while (value > 127) {
            out.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.write(value);
    }

    public void writeUleb128(int value) throws IOException {
        DexDataWriter.writeUleb128(this, value);
    }

    public static void writeSleb128(OutputStream out, int value) throws IOException {
        if (value >= 0) {
            while (value > 63) {
                out.write(value & 0x7F | 0x80);
                value >>>= 7;
            }
            out.write(value & 0x7F);
        } else {
            while (value < -64) {
                out.write(value & 0x7F | 0x80);
                value >>= 7;
            }
            out.write(value & 0x7F);
        }
    }

    public void writeSleb128(int value) throws IOException {
        DexDataWriter.writeSleb128(this, value);
    }

    public void writeEncodedValueHeader(int valueType, int valueArg) throws IOException {
        this.write(valueType | valueArg << 5);
    }

    public void writeEncodedInt(int valueType, int value) throws IOException {
        int index = 0;
        if (value >= 0) {
            while (value > 127) {
                this.tempBuf[index++] = (byte)value;
                value >>= 8;
            }
        } else {
            while (value < -128) {
                this.tempBuf[index++] = (byte)value;
                value >>= 8;
            }
        }
        this.tempBuf[index++] = (byte)value;
        this.writeEncodedValueHeader(valueType, index - 1);
        this.write(this.tempBuf, 0, index);
    }

    public void writeEncodedLong(int valueType, long value) throws IOException {
        int index = 0;
        if (value >= 0L) {
            while (value > 127L) {
                this.tempBuf[index++] = (byte)value;
                value >>= 8;
            }
        } else {
            while (value < -128L) {
                this.tempBuf[index++] = (byte)value;
                value >>= 8;
            }
        }
        this.tempBuf[index++] = (byte)value;
        this.writeEncodedValueHeader(valueType, index - 1);
        this.write(this.tempBuf, 0, index);
    }

    public void writeEncodedUint(int valueType, int value) throws IOException {
        int index = 0;
        do {
            this.tempBuf[index++] = (byte)value;
        } while ((value >>>= 8) != 0);
        this.writeEncodedValueHeader(valueType, index - 1);
        this.write(this.tempBuf, 0, index);
    }

    public void writeEncodedFloat(int valueType, float value) throws IOException {
        this.writeRightZeroExtendedInt(valueType, Float.floatToRawIntBits(value));
    }

    protected void writeRightZeroExtendedInt(int valueType, int value) throws IOException {
        int index = 3;
        do {
            this.tempBuf[index--] = (byte)((value & 0xFF000000) >>> 24);
        } while ((value <<= 8) != 0);
        int firstElement = index + 1;
        int encodedLength = 4 - firstElement;
        this.writeEncodedValueHeader(valueType, encodedLength - 1);
        this.write(this.tempBuf, firstElement, encodedLength);
    }

    public void writeEncodedDouble(int valueType, double value) throws IOException {
        this.writeRightZeroExtendedLong(valueType, Double.doubleToRawLongBits(value));
    }

    protected void writeRightZeroExtendedLong(int valueType, long value) throws IOException {
        int index = 7;
        do {
            this.tempBuf[index--] = (byte)((value & 0xFF00000000000000L) >>> 56);
        } while ((value <<= 8) != 0L);
        int firstElement = index + 1;
        int encodedLength = 8 - firstElement;
        this.writeEncodedValueHeader(valueType, encodedLength - 1);
        this.write(this.tempBuf, firstElement, encodedLength);
    }

    public void writeString(String string) throws IOException {
        int len = string.length();
        if (this.tempBuf.length <= string.length() * 3) {
            this.tempBuf = new byte[string.length() * 3];
        }
        byte[] buf = this.tempBuf;
        int bufPos = 0;
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c != '\u0000' && c < '\u0080') {
                buf[bufPos++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                buf[bufPos++] = (byte)(c >> 6 & 0x1F | 0xC0);
                buf[bufPos++] = (byte)(c & 0x3F | 0x80);
                continue;
            }
            buf[bufPos++] = (byte)(c >> 12 & 0xF | 0xE0);
            buf[bufPos++] = (byte)(c >> 6 & 0x3F | 0x80);
            buf[bufPos++] = (byte)(c & 0x3F | 0x80);
        }
        this.write(buf, 0, bufPos);
    }

    public void align() throws IOException {
        int zeros = -this.getPosition() & 3;
        if (zeros > 0) {
            this.write(this.zeroBuf, 0, zeros);
        }
    }

    public int getPosition() {
        return this.filePosition;
    }
}

