/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.launcher.setup;

import androidx.test.tools.crawler.common.base.Logger;
import androidx.test.tools.crawler.launcher.exceptions.CrawlSetupException;
import androidx.test.tools.crawler.proto.CrawlGuidanceProto;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;

public abstract class CrawlSetup {
    public static final String DEVICE_OUTPUT = "/sdcard/app_firebase_test_lab";
    public static final String ROBO_TEMP_FILES = "/sdcard/robo_tmp_files";
    private static final String APP_PACKAGE_NAME_FLAG = "--app-package-name";
    private static final String APK_FILE_FLAG = "--apk-file";
    private static final String GUIDE_FILE_FLAG = "--guide-file";
    private static final String TEXT_GUIDE_FILE_FLAG = "--text-guide-file";
    private static final String ROBO_SCRIPT_FILE_FLAG = "--robo-script-file";
    private static final String EXPERIMENTS_FILE_FLAG = "--experiments-file";
    private static final String CRAWL_TIMEOUT_FLAG = "--timeout-sec";
    private static final String OUTPUT_DIR_FLAG = "--output-dir";
    private static final String UI_AUTOMATOR_MODE_FLAG = "--ui-automator-mode";
    private static final String INSTANT_APPS_MODE_FLAG = "--instant-apps-mode";
    private static final String TEST_ACCESSIBILITY_FLAG = "--test-accessibility";
    private static final String WAKE_DEVICE_FLAG = "--wake-device";
    private static final String PAUSE_FLAG = "--pause";
    private static final String DEVICE_NAME_REGEX_FLAG = "--device-name";
    private static final String DEVICE_SERIAL_CODE_FLAG = "--device-serial-code";
    private static final String PRINT_NON_SDK_USAGE = "--print-non-sdk-usage";
    private String appPackageName = "";
    private String apkFilePath = "";
    protected Optional<Path> crawlGuidanceFilePath = Optional.empty();
    private String textGuideFilePath = "";
    protected Optional<Path> roboScriptFilePath = Optional.empty();
    private String experimentsFilePath = "";
    private int crawlTimeoutSeconds = 60;
    protected Path outputDirectoryPath = null;
    private boolean uiAutomatorMode = false;
    private boolean instantAppsMode = false;
    private boolean testAccessibility = false;
    private boolean wakeDevice = false;
    private boolean pauseBeforeCrawl = false;
    private String deviceNameRegex = "";
    private String deviceSerialCode = "";
    private boolean printNonSdkUsage = false;
    private final Properties experiments = new Properties();

    public String getAppPackageName() {
        return this.appPackageName;
    }

    public String getApkFilePath() {
        return this.apkFilePath;
    }

    public Optional<Path> getCrawlGuidanceFilePath() {
        return this.crawlGuidanceFilePath;
    }

    public Optional<Path> getRoboScriptFilePath() {
        return this.roboScriptFilePath;
    }

    public int getCrawlTimeoutSeconds() {
        return this.crawlTimeoutSeconds;
    }

    public Path getOutputDirectoryPath() {
        return this.outputDirectoryPath;
    }

    public boolean isUiAutomatorMode() {
        return this.uiAutomatorMode;
    }

    public boolean isInstantAppsMode() {
        return this.instantAppsMode;
    }

    public boolean isTestAccessibility() {
        return this.testAccessibility;
    }

    public boolean isWakeDevice() {
        return this.wakeDevice;
    }

    public boolean isPauseBeforeCrawl() {
        return this.pauseBeforeCrawl;
    }

    public Properties getExperiments() {
        return this.experiments;
    }

    public String getDeviceNameRegex() {
        return this.deviceNameRegex;
    }

    public String getDeviceSerialCode() {
        return this.deviceSerialCode;
    }

    public boolean getPrintNonSdkUsage() {
        return this.printNonSdkUsage;
    }

    public void processCrawlParameters(String[] crawlParameters) {
        for (int i = 0; i < crawlParameters.length; ++i) {
            String crawlParameter = crawlParameters[i];
            if (APP_PACKAGE_NAME_FLAG.equals(crawlParameter)) {
                this.appPackageName = crawlParameters[++i];
                continue;
            }
            if (APK_FILE_FLAG.equals(crawlParameter)) {
                this.apkFilePath = crawlParameters[++i];
                continue;
            }
            if (GUIDE_FILE_FLAG.equals(crawlParameter)) {
                this.crawlGuidanceFilePath = Optional.of(Paths.get(crawlParameters[++i], new String[0]));
                continue;
            }
            if (TEXT_GUIDE_FILE_FLAG.equals(crawlParameter)) {
                this.textGuideFilePath = crawlParameters[++i];
                continue;
            }
            if (ROBO_SCRIPT_FILE_FLAG.equals(crawlParameter)) {
                this.roboScriptFilePath = Optional.of(Paths.get(crawlParameters[++i], new String[0]));
                continue;
            }
            if (EXPERIMENTS_FILE_FLAG.equals(crawlParameter)) {
                this.experimentsFilePath = crawlParameters[++i];
                continue;
            }
            if (CRAWL_TIMEOUT_FLAG.equals(crawlParameter)) {
                try {
                    this.crawlTimeoutSeconds = Integer.parseInt(crawlParameters[++i]);
                }
                catch (NumberFormatException ignored) {
                    Logger.atWarning().log("Failed to parse the specified crawl timeout", new Object[0]);
                }
                continue;
            }
            if (OUTPUT_DIR_FLAG.equals(crawlParameter)) {
                this.outputDirectoryPath = Paths.get(crawlParameters[++i], new String[0]);
                continue;
            }
            if (UI_AUTOMATOR_MODE_FLAG.equals(crawlParameter)) {
                this.uiAutomatorMode = true;
                continue;
            }
            if (INSTANT_APPS_MODE_FLAG.equals(crawlParameter)) {
                this.instantAppsMode = true;
                continue;
            }
            if (TEST_ACCESSIBILITY_FLAG.equals(crawlParameter)) {
                this.testAccessibility = true;
                continue;
            }
            if (WAKE_DEVICE_FLAG.equals(crawlParameter)) {
                this.wakeDevice = true;
                continue;
            }
            if (PAUSE_FLAG.equals(crawlParameter)) {
                this.pauseBeforeCrawl = true;
                continue;
            }
            if (DEVICE_NAME_REGEX_FLAG.equals(crawlParameter)) {
                this.deviceNameRegex = crawlParameters[++i];
                continue;
            }
            if (DEVICE_SERIAL_CODE_FLAG.equals(crawlParameter)) {
                this.deviceSerialCode = crawlParameters[++i];
                continue;
            }
            if (!PRINT_NON_SDK_USAGE.equals(crawlParameter)) continue;
            this.printNonSdkUsage = true;
        }
        if (this.appPackageName.isEmpty() && this.apkFilePath.isEmpty()) {
            throw new CrawlSetupException("At least one of --app-package-name and --apk-file must be specified.");
        }
        if (!this.deviceNameRegex.isEmpty() && !this.deviceSerialCode.isEmpty()) {
            Logger.atInfo().log("Both device name regex and serial code specified, will use device name regex", new Object[0]);
        }
        this.apkFilePath = this.checkFileExistsAndNormalizeIfSpecified(this.apkFilePath, "app APK", true);
        CrawlSetup.checkFileExistsIfSpecified(this.crawlGuidanceFilePath, "crawl guidance proto");
        this.textGuideFilePath = this.checkFileExistsAndNormalizeIfSpecified(this.textGuideFilePath, "crawl guidance text proto", true);
        CrawlSetup.checkFileExistsIfSpecified(this.roboScriptFilePath, "Robo script");
        this.experimentsFilePath = this.checkFileExistsAndNormalizeIfSpecified(this.experimentsFilePath, "experiments", true);
        this.convertGuidanceTextProtoToBinary();
        if (!this.experimentsFilePath.isEmpty()) {
            try (FileInputStream inputStream = new FileInputStream(this.experimentsFilePath);){
                this.experiments.load(inputStream);
            }
            catch (Exception e) {
                throw new CrawlSetupException("Failed to load experiments from file " + this.experimentsFilePath, e);
            }
        }
        if (this.outputDirectoryPath == null) {
            this.outputDirectoryPath = this.getDefaultOutputDirectoryPath();
        }
        this.processModeSpecificCrawlParameters(crawlParameters);
    }

    private void convertGuidanceTextProtoToBinary() {
        if (!this.textGuideFilePath.isEmpty()) {
            if (this.crawlGuidanceFilePath.isPresent()) {
                Logger.atInfo().log("Both crawl guidance proto and text proto specified, will use text proto", new Object[0]);
            }
            Logger.atInfo().log("Converting crawl guidance text proto to binary", new Object[0]);
            CrawlGuidanceProto.CrawlGuidance.Builder crawlGuidanceBuilder = CrawlGuidanceProto.CrawlGuidance.newBuilder();
            try {
                try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.textGuideFilePath), StandardCharsets.UTF_8);){
                    TextFormat.merge(reader, (Message.Builder)crawlGuidanceBuilder);
                }
                File binaryProtoFile = File.createTempFile("crawl_guide_", ".proto");
                binaryProtoFile.deleteOnExit();
                try (FileOutputStream out = new FileOutputStream(binaryProtoFile);){
                    crawlGuidanceBuilder.build().writeTo(out);
                }
                this.crawlGuidanceFilePath = Optional.of(Paths.get(binaryProtoFile.getAbsolutePath(), new String[0]));
            }
            catch (Exception e) {
                throw new CrawlSetupException("Failed to convert crawl guidance text proto to binary", e);
            }
        }
    }

    String checkFileExistsAndNormalizeIfSpecified(String filePath, String fileDescription, boolean isFile) {
        if (!filePath.isEmpty()) {
            File file = new File(filePath);
            if (!file.exists()) {
                CrawlSetup.throwMissingFileException(filePath, fileDescription, isFile);
            }
            return file.getAbsolutePath();
        }
        return filePath;
    }

    private static void checkFileExistsIfSpecified(Optional<Path> filePath, String fileDescription) {
        if (filePath.isPresent() && !Files.exists(filePath.get(), new LinkOption[0])) {
            CrawlSetup.throwMissingFileException(filePath.get().toAbsolutePath().toString(), fileDescription, true);
        }
    }

    private static void throwMissingFileException(String filePath, String fileDescription, boolean isFile) {
        throw new CrawlSetupException(String.format("Could not find the specified %s %s %s", fileDescription, isFile ? "file" : "path", filePath));
    }

    private String getCrawlResultsPath() {
        return this.getOutputDirectoryPath().toAbsolutePath() + "/" + "app_firebase_test_lab";
    }

    public String getCrawlOutputsBinaryProtoPath() {
        return this.getCrawlResultsPath() + "/crawl_outputs.proto";
    }

    public String getCrawlOutputsTextProtoPath() {
        return this.getCrawlResultsPath() + "/crawl_outputs.txt";
    }

    protected abstract void processModeSpecificCrawlParameters(String[] var1);

    protected abstract Path getDefaultOutputDirectoryPath();

    public abstract void buildCrawler();

    public abstract String getKeyStorePath();

    public abstract String getKeyStorePassword();

    public abstract Path getCrawlerAppApkPath();

    public abstract File getCrawlerStubappApk();

    public abstract String getAndroidJarPath();

    public abstract Optional<File> getVideocatBinary(int var1);

    public abstract void postprocessVideocat(Path var1, String var2);

    public abstract File getExecutable(ExecutableType var1);

    public abstract Optional<Path> getSignaturesFilePath();

    public abstract String getCrawlDriverInitializerClass();

    public static enum ExecutableType {
        AAPT,
        ADB,
        ZIPALIGN;

    }
}

