/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.attributes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.attributes.SerializedName;
import hex.genmodel.attributes.Table;
import hex.genmodel.attributes.parameters.ColumnSpecifier;
import hex.genmodel.attributes.parameters.KeyValue;
import hex.genmodel.attributes.parameters.ParameterKey;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import water.logging.Logger;
import water.logging.LoggerFactory;

public class ModelJsonReader {
    private static final Logger LOG = LoggerFactory.getLogger(ModelJsonReader.class);
    public static final String MODEL_DETAILS_FILE = "experimental/modelDetails.json";
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\[\\]");
    private static final Pattern JSON_PATH_PATTERN = Pattern.compile("\\.|\\[|\\]");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject parseModelJson(MojoReaderBackend mojoReaderBackend) {
        try (BufferedReader fileReader = mojoReaderBackend.getTextFile(MODEL_DETAILS_FILE);){
            Gson gson = new GsonBuilder().create();
            JsonObject jsonObject = gson.fromJson((Reader)fileReader, JsonObject.class);
            return jsonObject;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Table[] readTableArray(JsonObject modelJson, String tablePath) {
        Objects.requireNonNull(modelJson);
        JsonElement jsonElement = ModelJsonReader.findInJson(modelJson, tablePath);
        if (jsonElement.isJsonNull()) {
            return null;
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        Table[] tableArray = new Table[jsonArray.size()];
        for (int i2 = 0; i2 < jsonArray.size(); ++i2) {
            Table table;
            tableArray[i2] = table = ModelJsonReader.readTableJson(jsonArray.get(i2).getAsJsonObject());
        }
        return tableArray;
    }

    private static Table readTableJson(JsonObject tableJson) {
        int rowCount = tableJson.get("rowcount").getAsInt();
        JsonArray columns = ModelJsonReader.findInJson(tableJson, "columns").getAsJsonArray();
        int columnCount = columns.size();
        String[] columnHeaders = new String[columnCount];
        Table.ColumnType[] columnTypes = new Table.ColumnType[columnCount];
        String[] columnFormats = new String[columnCount];
        for (int i2 = 0; i2 < columnCount; ++i2) {
            JsonObject column = columns.get(i2).getAsJsonObject();
            columnHeaders[i2] = column.get("description").getAsString();
            columnTypes[i2] = Table.ColumnType.extractType(column.get("type").getAsString());
            columnFormats[i2] = column.get("format").getAsString();
        }
        JsonArray dataColumns = ModelJsonReader.findInJson(tableJson, "data").getAsJsonArray();
        Object[][] data = new Object[columnCount][rowCount];
        for (int i3 = 0; i3 < columnCount; ++i3) {
            JsonArray column = dataColumns.get(i3).getAsJsonArray();
            block9: for (int j2 = 0; j2 < rowCount; ++j2) {
                JsonElement cellValue = column.get(j2);
                if (cellValue == null || !cellValue.isJsonPrimitive()) {
                    data[i3][j2] = null;
                    continue;
                }
                JsonPrimitive primitiveValue = cellValue.getAsJsonPrimitive();
                switch (columnTypes[i3]) {
                    case LONG: {
                        if (primitiveValue.isNumber()) {
                            data[i3][j2] = primitiveValue.getAsLong();
                            continue block9;
                        }
                        data[i3][j2] = null;
                        continue block9;
                    }
                    case DOUBLE: {
                        if (!primitiveValue.isJsonNull()) {
                            data[i3][j2] = primitiveValue.getAsDouble();
                            continue block9;
                        }
                        data[i3][j2] = null;
                        continue block9;
                    }
                    case FLOAT: {
                        data[i3][j2] = !primitiveValue.isJsonNull() ? Float.valueOf(primitiveValue.getAsFloat()) : null;
                    }
                    case INT: {
                        data[i3][j2] = primitiveValue.isNumber() ? Integer.valueOf(primitiveValue.getAsInt()) : null;
                    }
                    case STRING: {
                        data[i3][j2] = primitiveValue.getAsString();
                    }
                }
            }
        }
        return new Table(tableJson.get("name").getAsString(), tableJson.get("description").getAsString(), new String[rowCount], columnHeaders, columnTypes, null, columnFormats, data);
    }

    public static Table readTable(JsonObject modelJson, String tablePath) {
        Objects.requireNonNull(modelJson);
        JsonElement potentialTableJson = ModelJsonReader.findInJson(modelJson, tablePath);
        if (potentialTableJson.isJsonNull()) {
            LOG.debug(String.format("Table '%s' doesn't exist in MojoModel dump.", tablePath));
            return null;
        }
        return ModelJsonReader.readTableJson(potentialTableJson.getAsJsonObject());
    }

    public static <T> void fillObjects(List<T> objects, JsonArray from) {
        for (int i2 = 0; i2 < from.size(); ++i2) {
            JsonElement jsonElement = from.get(i2);
            ModelJsonReader.fillObject(objects.get(i2), jsonElement, "");
        }
    }

    public static void fillObject(Object object, JsonElement from, String elementPath) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(elementPath);
        JsonElement jsonSourceObject = ModelJsonReader.findInJson(from, elementPath);
        if (jsonSourceObject.isJsonNull()) {
            LOG.warn(String.format("Element '%s' not found in JSON. Skipping. Object '%s' is not populated by values.", elementPath, object.getClass().getName()));
            return;
        }
        JsonObject jsonSourceObj = jsonSourceObject.getAsJsonObject();
        Class<?> aClass = object.getClass();
        Field[] declaredFields = aClass.getFields();
        for (int i2 = 0; i2 < declaredFields.length; ++i2) {
            String name;
            Field field = declaredFields[i2];
            if (Modifier.isTransient(field.getModifiers())) continue;
            Class<Object> type = field.getType();
            SerializedName serializedName = field.getAnnotation(SerializedName.class);
            String fieldName = serializedName == null ? ((name = field.getName()).charAt(0) == '_' ? name.substring(1) : name) : serializedName.value();
            try {
                JsonElement jsonElement;
                field.setAccessible(true);
                assert (field.isAccessible());
                Object value = null;
                if (type.isAssignableFrom(Object.class)) {
                    jsonElement = jsonSourceObj.get(fieldName);
                    if (jsonElement != null) {
                        JsonElement typeElement = jsonSourceObj.get("type");
                        TypeHint typeHint = !typeElement.isJsonNull() ? TypeHint.fromStringIgnoreCase(typeElement.getAsString()) : null;
                        value = ModelJsonReader.convertBasedOnJsonType(jsonElement, typeHint);
                    }
                } else if (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class)) {
                    jsonElement = jsonSourceObj.get(fieldName);
                    if (jsonElement != null && !jsonElement.isJsonNull()) {
                        value = jsonElement.getAsDouble();
                    }
                } else if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
                    jsonElement = jsonSourceObj.get(fieldName);
                    if (jsonElement != null && !jsonElement.isJsonNull()) {
                        value = jsonElement.getAsInt();
                    }
                } else if (type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class)) {
                    jsonElement = jsonSourceObj.get(fieldName);
                    if (jsonElement != null && !jsonElement.isJsonNull()) {
                        value = jsonElement.getAsLong();
                    }
                } else if (type.isAssignableFrom(String.class)) {
                    jsonElement = jsonSourceObj.get(fieldName);
                    if (jsonElement != null && !jsonElement.isJsonNull()) {
                        value = jsonElement.getAsString();
                    }
                } else if (type.isAssignableFrom(Table.class) && (jsonElement = jsonSourceObj.get(fieldName)) != null && !jsonElement.isJsonNull()) {
                    value = ModelJsonReader.readTable(jsonElement.getAsJsonObject(), serializedName != null ? serializedName.insideElementPath() : "");
                }
                if (value == null) continue;
                field.set(object, value);
                continue;
            }
            catch (IllegalAccessException e2) {
                System.err.println(String.format("Field '%s' could not be accessed. Ignoring.", fieldName));
                continue;
            }
            catch (ClassCastException | UnsupportedOperationException e3) {
                System.err.println(String.format("Field '%s' could not be casted to '%s'. Ignoring.", fieldName, type.toString()));
            }
        }
    }

    private static Object convertBasedOnJsonType(JsonElement convertFrom, TypeHint typeHint) {
        Object convertTo;
        if (convertFrom.isJsonNull()) {
            convertTo = null;
        } else if (convertFrom.isJsonArray()) {
            JsonArray array = convertFrom.getAsJsonArray();
            if (typeHint == null) {
                convertTo = null;
            } else {
                switch (typeHint) {
                    case OBJECT_ARR: {
                        Object[] arrO = new Object[array.size()];
                        for (int i2 = 0; i2 < array.size(); ++i2) {
                            JsonElement e2 = array.get(i2);
                            arrO[i2] = e2.isJsonPrimitive() ? ModelJsonReader.convertBasedOnJsonType(e2, null) : ModelJsonReader.convertJsonObject(e2.getAsJsonObject());
                        }
                        convertTo = arrO;
                        break;
                    }
                    case DOUBLE_ARR: {
                        double[] arrD = new double[array.size()];
                        for (int i3 = 0; i3 < array.size(); ++i3) {
                            arrD[i3] = array.get(i3).getAsDouble();
                        }
                        convertTo = arrD;
                        break;
                    }
                    case FLOAT_ARR: {
                        double[] arrF = new double[array.size()];
                        for (int i4 = 0; i4 < array.size(); ++i4) {
                            arrF[i4] = array.get(i4).getAsDouble();
                        }
                        convertTo = arrF;
                        break;
                    }
                    case STRING_ARR: {
                        String[] arrS = new String[array.size()];
                        for (int i5 = 0; i5 < array.size(); ++i5) {
                            arrS[i5] = array.get(i5).getAsString();
                        }
                        convertTo = arrS;
                        break;
                    }
                    case STRING_ARR_ARR: {
                        String[][] arrSS = new String[array.size()][];
                        for (int i6 = 0; i6 < array.size(); ++i6) {
                            JsonArray arr2 = array.get(i6).getAsJsonArray();
                            arrSS[i6] = new String[arr2.size()];
                            for (int j2 = 0; j2 < arr2.size(); ++j2) {
                                arrSS[i6][j2] = arr2.get(j2).getAsString();
                            }
                        }
                        convertTo = arrSS;
                        break;
                    }
                    case INT_ARR: {
                        int[] arrI = new int[array.size()];
                        for (int i7 = 0; i7 < array.size(); ++i7) {
                            arrI[i7] = array.get(i7).getAsInt();
                        }
                        convertTo = arrI;
                        break;
                    }
                    case LONG_ARR: {
                        long[] arrL = new long[array.size()];
                        for (int i8 = 0; i8 < array.size(); ++i8) {
                            arrL[i8] = array.get(i8).getAsLong();
                        }
                        convertTo = arrL;
                        break;
                    }
                    default: {
                        convertTo = null;
                    }
                }
            }
        } else if (convertFrom.isJsonPrimitive()) {
            JsonPrimitive convertedPrimitive = convertFrom.getAsJsonPrimitive();
            if (convertedPrimitive.isBoolean()) {
                convertTo = convertedPrimitive.getAsBoolean();
            } else if (convertedPrimitive.isString()) {
                convertTo = convertedPrimitive.getAsString();
            } else if (convertedPrimitive.isNumber()) {
                if (typeHint == null) {
                    convertTo = convertedPrimitive.getAsDouble();
                } else {
                    switch (typeHint) {
                        case INT: {
                            convertTo = convertedPrimitive.getAsInt();
                            break;
                        }
                        case FLOAT: {
                            convertTo = Float.valueOf(convertedPrimitive.getAsFloat());
                            break;
                        }
                        case DOUBLE: {
                            convertTo = convertedPrimitive.getAsDouble();
                            break;
                        }
                        case LONG: {
                            convertTo = convertedPrimitive.getAsLong();
                            break;
                        }
                        default: {
                            convertTo = convertedPrimitive.getAsDouble();
                            break;
                        }
                    }
                }
            } else {
                convertTo = null;
            }
        } else {
            convertTo = convertFrom.isJsonObject() ? ModelJsonReader.convertJsonObject(convertFrom.getAsJsonObject()) : null;
        }
        return convertTo;
    }

    private static Object convertJsonObject(JsonObject convertFrom) {
        JsonElement meta = convertFrom.get("__meta");
        if (meta == null || meta.isJsonNull()) {
            return null;
        }
        String schemaName = ModelJsonReader.findInJson(meta, "schema_name").getAsString();
        if ("FrameKeyV3".equals(schemaName) || "ModelKeyV3".equals(schemaName)) {
            String name = convertFrom.get("name").getAsString();
            String type = convertFrom.get("type").getAsString();
            ParameterKey.Type convertedType = ModelJsonReader.convertKeyType(type);
            String url = convertFrom.get("URL").getAsString();
            return new ParameterKey(name, convertedType, url);
        }
        if ("ColSpecifierV3".equals(schemaName)) {
            String columnName = convertFrom.get("column_name").getAsString();
            JsonElement is_member_of_frames = convertFrom.get("is_member_of_frames");
            String[] memberOfFrames = is_member_of_frames.isJsonArray() ? ModelJsonReader.convertStringJsonArray(convertFrom.get("is_member_of_frames").getAsJsonArray()) : null;
            return new ColumnSpecifier(columnName, memberOfFrames);
        }
        if ("KeyValueV3".equals(schemaName)) {
            return new KeyValue(convertFrom.get("key").getAsString(), convertFrom.get("value").getAsDouble());
        }
        LOG.error(String.format("Error reading MOJO JSON: Object not supported: \n %s ", convertFrom.toString()));
        return null;
    }

    private static String[] convertStringJsonArray(JsonArray jsonArray) {
        Objects.requireNonNull(jsonArray);
        if (jsonArray.isJsonNull()) {
            return null;
        }
        String[] strings = new String[jsonArray.size()];
        for (int i2 = 0; i2 < jsonArray.size(); ++i2) {
            JsonElement potentialStringMember = jsonArray.get(i2);
            if (potentialStringMember.isJsonNull()) continue;
            strings[i2] = jsonArray.get(i2).getAsString();
        }
        return strings;
    }

    private static final ParameterKey.Type convertKeyType(String type) {
        if ("Key<Frame>".equals(type)) {
            return ParameterKey.Type.FRAME;
        }
        if ("Key<Model>".equals(type)) {
            return ParameterKey.Type.MODEL;
        }
        return ParameterKey.Type.GENERIC;
    }

    protected static JsonElement findInJson(JsonElement jsonElement, String jsonPath) {
        String[] route = JSON_PATH_PATTERN.split(jsonPath);
        JsonElement result = jsonElement;
        for (String key : route) {
            if ((key = key.trim()).isEmpty()) continue;
            if (result == null) break;
            if (result.isJsonObject()) {
                result = ((JsonObject)result).get(key);
                continue;
            }
            if (!result.isJsonArray()) break;
            int value = Integer.valueOf(key) - 1;
            result = ((JsonArray)result).get(value);
        }
        if (result == null) {
            return JsonNull.INSTANCE;
        }
        return result;
    }

    public static boolean elementExists(JsonElement jsonElement, String jsonPath) {
        boolean isEmpty = ModelJsonReader.findInJson(jsonElement, jsonPath).isJsonNull();
        return !isEmpty;
    }

    private static enum TypeHint {
        INT,
        FLOAT,
        DOUBLE,
        LONG,
        DOUBLE_ARR,
        FLOAT_ARR,
        STRING_ARR,
        STRING_ARR_ARR,
        INT_ARR,
        LONG_ARR,
        OBJECT_ARR;


        private static TypeHint fromStringIgnoreCase(String from) {
            Matcher matcher = ARRAY_PATTERN.matcher(from);
            boolean isArray = matcher.find();
            String transformedType = matcher.replaceAll("_ARR");
            try {
                return TypeHint.valueOf(transformedType.toUpperCase());
            }
            catch (IllegalArgumentException e2) {
                if (isArray) {
                    return OBJECT_ARR;
                }
                return null;
            }
        }
    }
}

