/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.targetencoder;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EncodingMap
implements Serializable {
    private static final Integer NO_TARGET_CLASS = -1;
    private Map<Integer, Map<Integer, double[]>> _encodingMap = new HashMap<Integer, Map<Integer, double[]>>();
    private Map<Integer, Double> priors = new HashMap<Integer, Double>();
    private int _nclasses;

    public EncodingMap(int nclasses) {
        this._nclasses = nclasses;
    }

    public double[] getNumDen(int category) {
        Map<Integer, double[]> targetMap = this._encodingMap.get(category);
        assert (this._nclasses == 1 || this._nclasses == 2);
        assert (targetMap.size() == 1);
        return targetMap.get(NO_TARGET_CLASS);
    }

    public double[] getNumDen(int category, int targetClass) {
        Map<Integer, double[]> targetMap = this._encodingMap.get(category);
        assert (this._nclasses > 2);
        assert (targetMap.size() > 1);
        return targetMap.get(targetClass);
    }

    public int getNACategory() {
        return this._encodingMap.size() - 1;
    }

    public void add(int categorical, double[] encodingComponents) {
        if (this._nclasses <= 2) {
            assert (encodingComponents.length == 2);
            this._encodingMap.put(categorical, Collections.singletonMap(NO_TARGET_CLASS, encodingComponents));
        } else {
            assert (encodingComponents.length == 3);
            if (!this._encodingMap.containsKey(categorical)) {
                this._encodingMap.put(categorical, new HashMap());
            }
            Integer targetClass = (int)encodingComponents[encodingComponents.length - 1];
            double[] numDen = Arrays.copyOf(encodingComponents, 2);
            this._encodingMap.get(categorical).put(targetClass, numDen);
        }
    }

    public double getPriorMean() {
        assert (this._nclasses == 1 || this._nclasses == 2);
        if (!this.priors.containsKey(NO_TARGET_CLASS)) {
            this.priors.put(NO_TARGET_CLASS, this.doComputePriorMean(NO_TARGET_CLASS));
        }
        return this.priors.get(NO_TARGET_CLASS);
    }

    public double getPriorMean(int targetClass) {
        assert (this._nclasses > 2);
        assert (targetClass >= 0 && targetClass < this._nclasses);
        if (!this.priors.containsKey(targetClass)) {
            this.priors.put(targetClass, this.doComputePriorMean(targetClass));
        }
        return this.priors.get(targetClass);
    }

    private double doComputePriorMean(int targetClass) {
        double num = 0.0;
        double den = 0.0;
        for (Map<Integer, double[]> targetMapping : this._encodingMap.values()) {
            double[] numDen = targetMapping.get(targetClass);
            num += numDen[0];
            den += numDen[1];
        }
        return num / den;
    }
}

