import { Duration } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * A State Machine
 */
export interface IStateMachine {
    /**
     * The ARN of the state machine
     */
    readonly stateMachineArn: string;
}
/**
 * Properties for a StateMachineCustomResourceProvider
 */
export interface StateMachineCustomResourceProviderProps {
    /**
     * The state machine
     */
    readonly stateMachine: IStateMachine;
    /**
     * Timeout
     *
     * @default Duration.minutes(30)
     */
    readonly timeout?: Duration;
}
/**
 * A state machine custom resource provider
 */
export declare class StateMachineCustomResourceProvider extends Construct {
    /**
     * The service token
     */
    readonly serviceToken: string;
    constructor(scope: Construct, id: string, props: StateMachineCustomResourceProviderProps);
    private createCfnResponseFn;
}
//# sourceMappingURL=index.d.ts.map