import * as ecs from 'aws-cdk-lib/aws-ecs';
import * as events from 'aws-cdk-lib/aws-events';
import { Construct } from 'constructs';
/**
 * Properties for a EcsServiceRoller
 */
export interface EcsServiceRollerProps {
    /**
     * The ECS cluster where the services run
     */
    readonly cluster: ecs.ICluster;
    /**
     * The ECS service for which tasks should be rolled
     */
    readonly service: ecs.IService;
    /**
     * The rule or schedule that should trigger a roll
     *
     * @default - roll everyday at midnight
     */
    readonly trigger?: RollTrigger;
}
/**
 * The rule or schedule that should trigger a roll
 */
export declare abstract class RollTrigger {
    /**
     * Schedule that should trigger a roll
     */
    static fromSchedule(schedule: events.Schedule): RollTrigger;
    /**
     * Rule that should trigger a roll
     */
    static fromRule(rule: events.Rule): RollTrigger;
    /**
     * Roll schedule
     *
     * @default - roll everyday at midnight
     */
    abstract readonly schedule?: events.Schedule;
    /**
     * Roll rule
     *
     * @default - roll everyday at midnight
     */
    abstract readonly rule?: events.Rule;
}
/**
 * Roll your ECS service tasks on schedule or with a rule
 */
export declare class EcsServiceRoller extends Construct {
    constructor(scope: Construct, id: string, props: EcsServiceRollerProps);
}
//# sourceMappingURL=index.d.ts.map