# Generated by Django 2.0.8 on 2019-02-12 15:19

from django.db import migrations


def migrate(apps, schema):
    for model in apps.get_models():
        for field in model._meta.fields:
            if field.__class__.__name__ == 'ImageField':
                default = field.default
                if default and type(default) in (bytes, str):
                    if type(default) == bytes:
                        default = default.decode()
                        model.objects.filter(**{'{}__contains'.format(field.name): '/static/'}).update(
                            **{field.name: default.split('/')[-1]})


class Migration(migrations.Migration):

    dependencies = [
        ('admin', '0007_auto_20180416_1854'),
    ]

    operations = [migrations.RunPython(migrate)]
