# Generated by /Users/tillrostalski/Git/fhan/src/fhan/client/scripts/create_from_template.py at 2023-10-05 16:18:26.129010
from typing import Literal


class AccountBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return AccountSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return AccountSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class AccountValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return AccountBooleanEnd(search_string=search_string)


class AccountSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "owner",
            "identifier",
            "period",
            "patient",
            "subject",
            "name",
            "guarantor",
            "type",
            "relatedaccount",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return AccountValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Account:owner",
            "Account:patient",
            "Account:subject",
            "Account:guarantor",
            "Account:relatedaccount",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return AccountBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Account:relatedaccount",
            "ChargeItem:account",
            "Encounter:account",
            "Invoice:account",
            "PaymentReconciliation:allocation-account",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return AccountBooleanEnd(search_string=search_string)


class ActivityDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ActivityDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ActivityDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ActivityDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ActivityDefinitionBooleanEnd(search_string=search_string)


class ActivityDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "successor",
            "context-type-value",
            "kind",
            "jurisdiction",
            "derived-from",
            "description",
            "context-type",
            "predecessor",
            "composed-of",
            "title",
            "version",
            "url",
            "context-quantity",
            "depends-on",
            "effective",
            "context",
            "name",
            "publisher",
            "topic",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ActivityDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ActivityDefinition:successor",
            "ActivityDefinition:derived-from",
            "ActivityDefinition:predecessor",
            "ActivityDefinition:composed-of",
            "ActivityDefinition:depends-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ActivityDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "CarePlan:instantiates-canonical",
            "ClinicalUseDefinition:product",
            "ClinicalUseDefinition:subject",
            "Communication:instantiates-canonical",
            "DeviceRequest:instantiates-canonical",
            "FamilyMemberHistory:instantiates-canonical",
            "MessageDefinition:parent",
            "PlanDefinition:definition",
            "Procedure:instantiates-canonical",
            "RegulatedAuthorization:subject",
            "ServiceRequest:instantiates-canonical",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ActivityDefinitionBooleanEnd(search_string=search_string)


class ActorDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ActorDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ActorDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ActorDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ActorDefinitionBooleanEnd(search_string=search_string)


class ActorDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "context-type-value",
            "jurisdiction",
            "description",
            "context-type",
            "title",
            "type",
            "version",
            "url",
            "context-quantity",
            "context",
            "publisher",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ActorDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ActorDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["Requirements:actor"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ActorDefinitionBooleanEnd(search_string=search_string)


class AdministrableProductDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return AdministrableProductDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return AdministrableProductDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class AdministrableProductDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return AdministrableProductDefinitionBooleanEnd(search_string=search_string)


class AdministrableProductDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "manufactured-item",
            "ingredient",
            "route",
            "dose-form",
            "device",
            "form-of",
            "target-species",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return AdministrableProductDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "AdministrableProductDefinition:manufactured-item",
            "AdministrableProductDefinition:device",
            "AdministrableProductDefinition:form-of",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return AdministrableProductDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["Ingredient:for"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return AdministrableProductDefinitionBooleanEnd(search_string=search_string)


class AdverseEventBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return AdverseEventSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return AdverseEventSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class AdverseEventValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return AdverseEventBooleanEnd(search_string=search_string)


class AdverseEventSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "recorder",
            "study",
            "code",
            "actuality",
            "subject",
            "substance",
            "patient",
            "resultingeffect",
            "seriousness",
            "location",
            "category",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return AdverseEventValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "AdverseEvent:recorder",
            "AdverseEvent:study",
            "AdverseEvent:subject",
            "AdverseEvent:substance",
            "AdverseEvent:patient",
            "AdverseEvent:resultingeffect",
            "AdverseEvent:location",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return AdverseEventBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return AdverseEventBooleanEnd(search_string=search_string)


class AllergyIntoleranceBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return AllergyIntoleranceSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return AllergyIntoleranceSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class AllergyIntoleranceValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return AllergyIntoleranceBooleanEnd(search_string=search_string)


class AllergyIntoleranceSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "severity",
            "identifier",
            "code",
            "verification-status",
            "criticality",
            "manifestation-reference",
            "clinical-status",
            "type",
            "participant",
            "manifestation-code",
            "route",
            "patient",
            "category",
            "last-date",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return AllergyIntoleranceValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "AllergyIntolerance:manifestation-reference",
            "AllergyIntolerance:participant",
            "AllergyIntolerance:patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return AllergyIntoleranceBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["ClinicalImpression:problem"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return AllergyIntoleranceBooleanEnd(search_string=search_string)


class AppointmentBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return AppointmentSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return AppointmentSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class AppointmentValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return AppointmentBooleanEnd(search_string=search_string)


class AppointmentSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "specialty",
            "service-category",
            "practitioner",
            "appointment-type",
            "part-status",
            "subject",
            "service-type",
            "slot",
            "reason-code",
            "actor",
            "based-on",
            "patient",
            "reason-reference",
            "supporting-info",
            "requested-period",
            "location",
            "group",
            "service-type-reference",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return AppointmentValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Appointment:practitioner",
            "Appointment:subject",
            "Appointment:slot",
            "Appointment:actor",
            "Appointment:based-on",
            "Appointment:patient",
            "Appointment:reason-reference",
            "Appointment:supporting-info",
            "Appointment:location",
            "Appointment:group",
            "Appointment:service-type-reference",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return AppointmentBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AppointmentResponse:appointment",
            "CarePlan:activity-reference",
            "DocumentReference:based-on",
            "DocumentReference:context",
            "Encounter:appointment",
            "ImagingSelection:based-on",
            "ImagingStudy:based-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return AppointmentBooleanEnd(search_string=search_string)


class AppointmentResponseBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return AppointmentResponseSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return AppointmentResponseSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class AppointmentResponseValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return AppointmentResponseBooleanEnd(search_string=search_string)


class AppointmentResponseSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "actor",
            "identifier",
            "practitioner",
            "part-status",
            "patient",
            "appointment",
            "location",
            "group",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return AppointmentResponseValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "AppointmentResponse:actor",
            "AppointmentResponse:practitioner",
            "AppointmentResponse:patient",
            "AppointmentResponse:appointment",
            "AppointmentResponse:location",
            "AppointmentResponse:group",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return AppointmentResponseBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "DocumentReference:based-on",
            "ImagingSelection:based-on",
            "ImagingStudy:based-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return AppointmentResponseBooleanEnd(search_string=search_string)


class ArtifactAssessmentBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ArtifactAssessmentSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ArtifactAssessmentSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ArtifactAssessmentValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ArtifactAssessmentBooleanEnd(search_string=search_string)


class ArtifactAssessmentSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ArtifactAssessmentValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ArtifactAssessmentBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ArtifactAssessmentBooleanEnd(search_string=search_string)


class AuditEventBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return AuditEventSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return AuditEventSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class AuditEventValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return AuditEventBooleanEnd(search_string=search_string)


class AuditEventSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "agent",
            "entity-role",
            "code",
            "purpose",
            "encounter",
            "source",
            "based-on",
            "patient",
            "action",
            "agent-role",
            "category",
            "entity",
            "outcome",
            "policy",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return AuditEventValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "AuditEvent:agent",
            "AuditEvent:encounter",
            "AuditEvent:source",
            "AuditEvent:based-on",
            "AuditEvent:patient",
            "AuditEvent:entity",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return AuditEventBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return AuditEventBooleanEnd(search_string=search_string)


class BasicBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return BasicSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return BasicSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class BasicValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return BasicBooleanEnd(search_string=search_string)


class BasicSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "code",
            "author",
            "created",
            "patient",
            "subject",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return BasicValue(search_string=search_string)

    def include(
        self,
        value: Literal["Basic:author", "Basic:patient", "Basic:subject"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return BasicBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return BasicBooleanEnd(search_string=search_string)


class BinaryBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return BinarySearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return BinarySearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class BinaryValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return BinaryBooleanEnd(search_string=search_string)


class BinarySearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return BinaryValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return BinaryBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return BinaryBooleanEnd(search_string=search_string)


class BiologicallyDerivedProductBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return BiologicallyDerivedProductSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return BiologicallyDerivedProductSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class BiologicallyDerivedProductValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return BiologicallyDerivedProductBooleanEnd(search_string=search_string)


class BiologicallyDerivedProductSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "request",
            "code",
            "product-status",
            "serial-number",
            "biological-source-event",
            "product-category",
            "collector",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return BiologicallyDerivedProductValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "BiologicallyDerivedProduct:request", "BiologicallyDerivedProduct:collector"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return BiologicallyDerivedProductBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdverseEvent:substance",
            "BiologicallyDerivedProductDispense:product",
            "ClinicalUseDefinition:product",
            "ClinicalUseDefinition:subject",
            "DetectedIssue:subject",
            "DetectedIssue:patient",
            "DiagnosticReport:subject",
            "DiagnosticReport:patient",
            "GenomicStudy:patient",
            "GenomicStudy:subject",
            "MolecularSequence:subject",
            "MolecularSequence:patient",
            "Observation:subject",
            "Observation:patient",
            "RegulatedAuthorization:subject",
            "ResearchSubject:subject",
            "ResearchSubject:patient",
            "Specimen:patient",
            "Specimen:subject",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return BiologicallyDerivedProductBooleanEnd(search_string=search_string)


class BiologicallyDerivedProductDispenseBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return BiologicallyDerivedProductDispenseSearchBuilder(
            search_string=search_string
        )

    def OR(self):
        search_string = self.search_string + "|"
        return BiologicallyDerivedProductDispenseSearchBuilder(
            search_string=search_string
        )

    def build(self):
        return self.search_string


class BiologicallyDerivedProductDispenseValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return BiologicallyDerivedProductDispenseBooleanEnd(search_string=search_string)


class BiologicallyDerivedProductDispenseSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "product",
            "performer",
            "patient",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return BiologicallyDerivedProductDispenseValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "BiologicallyDerivedProductDispense:product",
            "BiologicallyDerivedProductDispense:performer",
            "BiologicallyDerivedProductDispense:patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return BiologicallyDerivedProductDispenseBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return BiologicallyDerivedProductDispenseBooleanEnd(search_string=search_string)


class BodyStructureBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return BodyStructureSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return BodyStructureSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class BodyStructureValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return BodyStructureBooleanEnd(search_string=search_string)


class BodyStructureSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "included_structure",
            "excluded_structure",
            "morphology",
            "patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return BodyStructureValue(search_string=search_string)

    def include(
        self,
        value: Literal["BodyStructure:patient"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return BodyStructureBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["ServiceRequest:body-structure"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return BodyStructureBooleanEnd(search_string=search_string)


class BundleBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return BundleSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return BundleSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class BundleValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return BundleBooleanEnd(search_string=search_string)


class BundleSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "composition",
            "message",
            "type",
            "timestamp",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return BundleValue(search_string=search_string)

    def include(
        self,
        value: Literal["Bundle:composition", "Bundle:message"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return BundleBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return BundleBooleanEnd(search_string=search_string)


class CapabilityStatementBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return CapabilityStatementSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return CapabilityStatementSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class CapabilityStatementValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return CapabilityStatementBooleanEnd(search_string=search_string)


class CapabilityStatementSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "resource-profile",
            "context-type-value",
            "software",
            "resource",
            "jurisdiction",
            "format",
            "description",
            "context-type",
            "fhirversion",
            "title",
            "version",
            "supported-profile",
            "url",
            "mode",
            "context-quantity",
            "security-service",
            "context",
            "name",
            "publisher",
            "context-type-quantity",
            "guide",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return CapabilityStatementValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "CapabilityStatement:resource-profile",
            "CapabilityStatement:supported-profile",
            "CapabilityStatement:guide",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return CapabilityStatementBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["RequestOrchestration:participant"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return CapabilityStatementBooleanEnd(search_string=search_string)


class CarePlanBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return CarePlanSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return CarePlanSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class CarePlanValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return CarePlanBooleanEnd(search_string=search_string)


class CarePlanSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "care-team",
            "date",
            "identifier",
            "goal",
            "custodian",
            "replaces",
            "subject",
            "instantiates-canonical",
            "part-of",
            "encounter",
            "intent",
            "activity-reference",
            "condition",
            "based-on",
            "patient",
            "instantiates-uri",
            "category",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return CarePlanValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "CarePlan:care-team",
            "CarePlan:goal",
            "CarePlan:custodian",
            "CarePlan:replaces",
            "CarePlan:subject",
            "CarePlan:instantiates-canonical",
            "CarePlan:part-of",
            "CarePlan:encounter",
            "CarePlan:activity-reference",
            "CarePlan:condition",
            "CarePlan:based-on",
            "CarePlan:patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return CarePlanBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Appointment:based-on",
            "AuditEvent:based-on",
            "CarePlan:replaces",
            "CarePlan:part-of",
            "CarePlan:based-on",
            "DiagnosticReport:based-on",
            "DocumentReference:based-on",
            "Encounter:based-on",
            "ImagingSelection:based-on",
            "ImagingStudy:based-on",
            "Observation:based-on",
            "Procedure:based-on",
            "Provenance:based-on",
            "QuestionnaireResponse:based-on",
            "ServiceRequest:based-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return CarePlanBooleanEnd(search_string=search_string)


class CareTeamBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return CareTeamSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return CareTeamSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class CareTeamValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return CareTeamBooleanEnd(search_string=search_string)


class CareTeamSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "patient",
            "subject",
            "name",
            "category",
            "participant",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return CareTeamValue(search_string=search_string)

    def include(
        self,
        value: Literal["CareTeam:patient", "CareTeam:subject", "CareTeam:participant"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return CareTeamBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AllergyIntolerance:participant",
            "Appointment:practitioner",
            "Appointment:actor",
            "Appointment:patient",
            "Appointment:location",
            "Appointment:group",
            "AuditEvent:agent",
            "AuditEvent:source",
            "Basic:author",
            "CarePlan:care-team",
            "CarePlan:custodian",
            "CareTeam:participant",
            "ChargeItem:performer-actor",
            "Communication:sender",
            "Communication:recipient",
            "CommunicationRequest:recipient",
            "Condition:participant-actor",
            "Consent:grantee",
            "Consent:actor",
            "DiagnosticReport:performer",
            "DiagnosticReport:results-interpreter",
            "DocumentReference:author",
            "Encounter:careteam",
            "Group:member",
            "ImagingStudy:performer",
            "List:source",
            "MeasureReport:patient",
            "MeasureReport:subject",
            "MedicationDispense:performer",
            "MedicationRequest:intended-performer",
            "Observation:performer",
            "Procedure:performer",
            "Provenance:agent",
            "RequestOrchestration:subject",
            "RequestOrchestration:participant",
            "RequestOrchestration:patient",
            "Schedule:actor",
            "ServiceRequest:performer",
            "Subscription:owner",
            "SupplyRequest:requester",
            "Task:owner",
            "Task:actor",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return CareTeamBooleanEnd(search_string=search_string)


class ChargeItemBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ChargeItemSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ChargeItemSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ChargeItemValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ChargeItemBooleanEnd(search_string=search_string)


class ChargeItemSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "performing-organization",
            "code",
            "quantity",
            "subject",
            "encounter",
            "occurrence",
            "entered-date",
            "performer-function",
            "factor-override",
            "patient",
            "service",
            "price-override",
            "enterer",
            "performer-actor",
            "account",
            "requesting-organization",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ChargeItemValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ChargeItem:performing-organization",
            "ChargeItem:subject",
            "ChargeItem:encounter",
            "ChargeItem:patient",
            "ChargeItem:service",
            "ChargeItem:enterer",
            "ChargeItem:performer-actor",
            "ChargeItem:account",
            "ChargeItem:requesting-organization",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ChargeItemBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ChargeItemBooleanEnd(search_string=search_string)


class ChargeItemDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ChargeItemDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ChargeItemDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ChargeItemDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ChargeItemDefinitionBooleanEnd(search_string=search_string)


class ChargeItemDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "context-type-value",
            "jurisdiction",
            "description",
            "context-type",
            "title",
            "version",
            "url",
            "context-quantity",
            "effective",
            "context",
            "publisher",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ChargeItemDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ChargeItemDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ChargeItemDefinitionBooleanEnd(search_string=search_string)


class CitationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return CitationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return CitationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class CitationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return CitationBooleanEnd(search_string=search_string)


class CitationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "context-type-value",
            "jurisdiction",
            "description",
            "classification-type",
            "context-type",
            "title",
            "classification",
            "version",
            "url",
            "context-quantity",
            "effective",
            "context",
            "name",
            "classifier",
            "publisher",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return CitationValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return CitationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return CitationBooleanEnd(search_string=search_string)


class ClaimBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ClaimSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ClaimSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ClaimValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ClaimBooleanEnd(search_string=search_string)


class ClaimSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "care-team",
            "identifier",
            "created",
            "use",
            "encounter",
            "priority",
            "payee",
            "provider",
            "insurer",
            "patient",
            "detail-udi",
            "enterer",
            "procedure-udi",
            "subdetail-udi",
            "facility",
            "item-udi",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ClaimValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Claim:care-team",
            "Claim:encounter",
            "Claim:payee",
            "Claim:provider",
            "Claim:insurer",
            "Claim:patient",
            "Claim:detail-udi",
            "Claim:enterer",
            "Claim:procedure-udi",
            "Claim:subdetail-udi",
            "Claim:facility",
            "Claim:item-udi",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ClaimBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "ClaimResponse:request",
            "DocumentReference:based-on",
            "ExplanationOfBenefit:claim",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ClaimBooleanEnd(search_string=search_string)


class ClaimResponseBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ClaimResponseSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ClaimResponseSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ClaimResponseValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ClaimResponseBooleanEnd(search_string=search_string)


class ClaimResponseSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "request",
            "disposition",
            "created",
            "insurer",
            "patient",
            "use",
            "payment-date",
            "outcome",
            "requestor",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ClaimResponseValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ClaimResponse:request",
            "ClaimResponse:insurer",
            "ClaimResponse:patient",
            "ClaimResponse:requestor",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ClaimResponseBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["DeviceRequest:insurance"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ClaimResponseBooleanEnd(search_string=search_string)


class ClinicalImpressionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ClinicalImpressionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ClinicalImpressionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ClinicalImpressionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ClinicalImpressionBooleanEnd(search_string=search_string)


class ClinicalImpressionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "performer",
            "problem",
            "previous",
            "finding-code",
            "patient",
            "subject",
            "supporting-info",
            "encounter",
            "finding-ref",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ClinicalImpressionValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ClinicalImpression:performer",
            "ClinicalImpression:problem",
            "ClinicalImpression:previous",
            "ClinicalImpression:patient",
            "ClinicalImpression:subject",
            "ClinicalImpression:supporting-info",
            "ClinicalImpression:encounter",
            "ClinicalImpression:finding-ref",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ClinicalImpressionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["ClinicalImpression:previous"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ClinicalImpressionBooleanEnd(search_string=search_string)


class ClinicalUseDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ClinicalUseDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ClinicalUseDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ClinicalUseDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ClinicalUseDefinitionBooleanEnd(search_string=search_string)


class ClinicalUseDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "contraindication-reference",
            "identifier",
            "indication-reference",
            "product",
            "subject",
            "effect",
            "interaction",
            "indication",
            "type",
            "contraindication",
            "effect-reference",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ClinicalUseDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ClinicalUseDefinition:contraindication-reference",
            "ClinicalUseDefinition:indication-reference",
            "ClinicalUseDefinition:product",
            "ClinicalUseDefinition:subject",
            "ClinicalUseDefinition:effect-reference",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ClinicalUseDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ClinicalUseDefinitionBooleanEnd(search_string=search_string)


class CodeSystemBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return CodeSystemSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return CodeSystemSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class CodeSystemValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return CodeSystemBooleanEnd(search_string=search_string)


class CodeSystemSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "code",
            "context-type-value",
            "content-mode",
            "jurisdiction",
            "description",
            "derived-from",
            "context-type",
            "language",
            "predecessor",
            "title",
            "version",
            "url",
            "context-quantity",
            "supplements",
            "effective",
            "system",
            "context",
            "name",
            "publisher",
            "topic",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return CodeSystemValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "CodeSystem:derived-from",
            "CodeSystem:predecessor",
            "CodeSystem:supplements",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return CodeSystemBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "CodeSystem:supplements",
            "ConceptMap:target-group-system",
            "ConceptMap:source-group-system",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return CodeSystemBooleanEnd(search_string=search_string)


class CommunicationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return CommunicationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return CommunicationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class CommunicationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return CommunicationBooleanEnd(search_string=search_string)


class CommunicationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "subject",
            "instantiates-canonical",
            "part-of",
            "received",
            "encounter",
            "medium",
            "sent",
            "based-on",
            "sender",
            "patient",
            "recipient",
            "topic",
            "instantiates-uri",
            "category",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return CommunicationValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Communication:subject",
            "Communication:instantiates-canonical",
            "Communication:part-of",
            "Communication:encounter",
            "Communication:based-on",
            "Communication:sender",
            "Communication:patient",
            "Communication:recipient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return CommunicationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return CommunicationBooleanEnd(search_string=search_string)


class CommunicationRequestBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return CommunicationRequestSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return CommunicationRequestSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class CommunicationRequestValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return CommunicationRequestBooleanEnd(search_string=search_string)


class CommunicationRequestSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "authored",
            "requester",
            "identifier",
            "replaces",
            "subject",
            "encounter",
            "medium",
            "occurrence",
            "priority",
            "group-identifier",
            "based-on",
            "patient",
            "recipient",
            "information-provider",
            "category",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return CommunicationRequestValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "CommunicationRequest:requester",
            "CommunicationRequest:replaces",
            "CommunicationRequest:subject",
            "CommunicationRequest:encounter",
            "CommunicationRequest:based-on",
            "CommunicationRequest:patient",
            "CommunicationRequest:recipient",
            "CommunicationRequest:information-provider",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return CommunicationRequestBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "CarePlan:activity-reference",
            "CommunicationRequest:replaces",
            "DocumentReference:based-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return CommunicationRequestBooleanEnd(search_string=search_string)


class CompartmentDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return CompartmentDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return CompartmentDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class CompartmentDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return CompartmentDefinitionBooleanEnd(search_string=search_string)


class CompartmentDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "code",
            "context-type-value",
            "resource",
            "description",
            "context-type",
            "version",
            "url",
            "context-quantity",
            "context",
            "name",
            "publisher",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return CompartmentDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return CompartmentDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return CompartmentDefinitionBooleanEnd(search_string=search_string)


class CompositionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return CompositionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return CompositionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class CompositionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return CompositionBooleanEnd(search_string=search_string)


class CompositionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "period",
            "event-code",
            "author",
            "subject",
            "section",
            "encounter",
            "title",
            "type",
            "version",
            "attester",
            "url",
            "event-reference",
            "section-text",
            "entry",
            "related",
            "patient",
            "category",
            "section-code-text",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return CompositionValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Composition:author",
            "Composition:subject",
            "Composition:encounter",
            "Composition:attester",
            "Composition:event-reference",
            "Composition:entry",
            "Composition:related",
            "Composition:patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return CompositionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["Procedure:report"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return CompositionBooleanEnd(search_string=search_string)


class ConceptMapBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ConceptMapSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ConceptMapSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ConceptMapValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ConceptMapBooleanEnd(search_string=search_string)


class ConceptMapSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "target-scope",
            "context-type-value",
            "jurisdiction",
            "description",
            "target-group-system",
            "derived-from",
            "context-type",
            "predecessor",
            "title",
            "context-quantity",
            "effective",
            "source-scope",
            "context",
            "context-type-quantity",
            "target-code",
            "identifier",
            "source-scope-uri",
            "source-group-system",
            "mapping-property",
            "other-map",
            "version",
            "url",
            "source-code",
            "target-scope-uri",
            "name",
            "publisher",
            "topic",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ConceptMapValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ConceptMap:target-scope",
            "ConceptMap:target-group-system",
            "ConceptMap:derived-from",
            "ConceptMap:predecessor",
            "ConceptMap:source-scope",
            "ConceptMap:source-group-system",
            "ConceptMap:other-map",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ConceptMapBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["ConceptMap:other-map"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ConceptMapBooleanEnd(search_string=search_string)


class ConditionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ConditionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ConditionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ConditionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ConditionBooleanEnd(search_string=search_string)


class ConditionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "evidence-detail",
            "severity",
            "identifier",
            "onset-info",
            "recorded-date",
            "code",
            "evidence",
            "participant-function",
            "subject",
            "participant-actor",
            "verification-status",
            "clinical-status",
            "encounter",
            "onset-date",
            "abatement-date",
            "stage",
            "abatement-string",
            "patient",
            "abatement-age",
            "onset-age",
            "body-site",
            "category",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ConditionValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Condition:evidence-detail",
            "Condition:subject",
            "Condition:participant-actor",
            "Condition:encounter",
            "Condition:patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ConditionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdverseEvent:resultingeffect",
            "ClinicalImpression:problem",
            "Goal:addresses",
            "RiskAssessment:condition",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ConditionBooleanEnd(search_string=search_string)


class ConditionDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ConditionDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ConditionDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ConditionDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ConditionDefinitionBooleanEnd(search_string=search_string)


class ConditionDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "context-type-value",
            "jurisdiction",
            "description",
            "context-type",
            "title",
            "version",
            "url",
            "context-quantity",
            "context",
            "name",
            "publisher",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ConditionDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ConditionDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ConditionDefinitionBooleanEnd(search_string=search_string)


class ConsentBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ConsentSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ConsentSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ConsentValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ConsentBooleanEnd(search_string=search_string)


class ConsentSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "controller",
            "period",
            "data",
            "manager",
            "purpose",
            "subject",
            "verified-date",
            "grantee",
            "source-reference",
            "verified",
            "actor",
            "security-label",
            "patient",
            "action",
            "category",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ConsentValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Consent:controller",
            "Consent:data",
            "Consent:manager",
            "Consent:subject",
            "Consent:grantee",
            "Consent:source-reference",
            "Consent:actor",
            "Consent:patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ConsentBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["Consent:source-reference"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ConsentBooleanEnd(search_string=search_string)


class ContractBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ContractSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ContractSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ContractValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ContractBooleanEnd(search_string=search_string)


class ContractSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "instantiates",
            "patient",
            "subject",
            "authority",
            "domain",
            "issued",
            "url",
            "signer",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ContractValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Contract:patient",
            "Contract:subject",
            "Contract:authority",
            "Contract:domain",
            "Contract:signer",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ContractBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["Consent:source-reference", "DocumentReference:based-on"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ContractBooleanEnd(search_string=search_string)


class CoverageBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return CoverageSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return CoverageSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class CoverageValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return CoverageBooleanEnd(search_string=search_string)


class CoverageSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "subscriber",
            "subscriberid",
            "type",
            "beneficiary",
            "patient",
            "insurer",
            "class-value",
            "paymentby-party",
            "class-type",
            "dependent",
            "policy-holder",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return CoverageValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Coverage:subscriber",
            "Coverage:beneficiary",
            "Coverage:patient",
            "Coverage:insurer",
            "Coverage:paymentby-party",
            "Coverage:policy-holder",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return CoverageBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["DeviceRequest:insurance", "ExplanationOfBenefit:coverage"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return CoverageBooleanEnd(search_string=search_string)


class CoverageEligibilityRequestBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return CoverageEligibilityRequestSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return CoverageEligibilityRequestSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class CoverageEligibilityRequestValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return CoverageEligibilityRequestBooleanEnd(search_string=search_string)


class CoverageEligibilityRequestSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "provider",
            "created",
            "patient",
            "enterer",
            "facility",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return CoverageEligibilityRequestValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "CoverageEligibilityRequest:provider",
            "CoverageEligibilityRequest:patient",
            "CoverageEligibilityRequest:enterer",
            "CoverageEligibilityRequest:facility",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return CoverageEligibilityRequestBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "CoverageEligibilityResponse:request", "DocumentReference:based-on"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return CoverageEligibilityRequestBooleanEnd(search_string=search_string)


class CoverageEligibilityResponseBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return CoverageEligibilityResponseSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return CoverageEligibilityResponseSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class CoverageEligibilityResponseValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return CoverageEligibilityResponseBooleanEnd(search_string=search_string)


class CoverageEligibilityResponseSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "request",
            "disposition",
            "created",
            "insurer",
            "patient",
            "outcome",
            "requestor",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return CoverageEligibilityResponseValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "CoverageEligibilityResponse:request",
            "CoverageEligibilityResponse:insurer",
            "CoverageEligibilityResponse:patient",
            "CoverageEligibilityResponse:requestor",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return CoverageEligibilityResponseBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return CoverageEligibilityResponseBooleanEnd(search_string=search_string)


class DetectedIssueBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return DetectedIssueSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return DetectedIssueSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class DetectedIssueValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return DetectedIssueBooleanEnd(search_string=search_string)


class DetectedIssueSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "code",
            "identified",
            "author",
            "subject",
            "patient",
            "implicated",
            "category",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return DetectedIssueValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "DetectedIssue:author",
            "DetectedIssue:subject",
            "DetectedIssue:patient",
            "DetectedIssue:implicated",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return DetectedIssueBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return DetectedIssueBooleanEnd(search_string=search_string)


class DeviceBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return DeviceSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return DeviceSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class DeviceValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return DeviceBooleanEnd(search_string=search_string)


class DeviceSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "udi-di",
            "identifier",
            "parent",
            "manufacture-date",
            "udi-carrier",
            "code",
            "device-name",
            "lot-number",
            "serial-number",
            "specification",
            "type",
            "version",
            "url",
            "manufacturer",
            "code-value-concept",
            "organization",
            "biological-source-event",
            "definition",
            "location",
            "model",
            "expiration-date",
            "specification-version",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return DeviceValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Device:parent",
            "Device:organization",
            "Device:definition",
            "Device:location",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return DeviceBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Account:patient",
            "Account:subject",
            "AdverseEvent:substance",
            "AllergyIntolerance:participant",
            "Appointment:practitioner",
            "Appointment:actor",
            "Appointment:patient",
            "Appointment:location",
            "Appointment:group",
            "AppointmentResponse:actor",
            "AppointmentResponse:practitioner",
            "AppointmentResponse:patient",
            "AppointmentResponse:location",
            "AppointmentResponse:group",
            "AuditEvent:agent",
            "AuditEvent:source",
            "Basic:author",
            "CarePlan:custodian",
            "ChargeItem:enterer",
            "ChargeItem:performer-actor",
            "Claim:detail-udi",
            "Claim:procedure-udi",
            "Claim:subdetail-udi",
            "Claim:item-udi",
            "ClinicalUseDefinition:product",
            "ClinicalUseDefinition:subject",
            "Communication:sender",
            "Communication:recipient",
            "CommunicationRequest:requester",
            "CommunicationRequest:recipient",
            "CommunicationRequest:information-provider",
            "Composition:author",
            "Condition:participant-actor",
            "Consent:actor",
            "DetectedIssue:author",
            "DetectedIssue:subject",
            "DetectedIssue:patient",
            "Device:parent",
            "DeviceAssociation:subject",
            "DeviceAssociation:patient",
            "DeviceAssociation:device",
            "DeviceMetric:device",
            "DeviceRequest:requester",
            "DeviceRequest:subject",
            "DeviceRequest:patient",
            "DiagnosticReport:subject",
            "DiagnosticReport:patient",
            "DocumentReference:author",
            "Encounter:participant",
            "Encounter:practitioner",
            "ExplanationOfBenefit:detail-udi",
            "ExplanationOfBenefit:procedure-udi",
            "ExplanationOfBenefit:subdetail-udi",
            "ExplanationOfBenefit:item-udi",
            "Flag:author",
            "Group:member",
            "ImagingSelection:subject",
            "ImagingSelection:patient",
            "ImagingStudy:performer",
            "ImagingStudy:subject",
            "ImagingStudy:patient",
            "Invoice:participant",
            "List:source",
            "MeasureReport:patient",
            "MeasureReport:subject",
            "MedicationDispense:performer",
            "MedicationRequest:requester",
            "MessageHeader:sender",
            "MessageHeader:author",
            "MessageHeader:target",
            "Observation:subject",
            "Observation:patient",
            "Observation:device",
            "Procedure:performer",
            "Procedure:subject",
            "Procedure:patient",
            "Provenance:agent",
            "QuestionnaireResponse:author",
            "QuestionnaireResponse:source",
            "RequestOrchestration:author",
            "RequestOrchestration:subject",
            "RequestOrchestration:participant",
            "RequestOrchestration:patient",
            "ResearchSubject:subject",
            "ResearchSubject:patient",
            "RiskAssessment:performer",
            "Schedule:actor",
            "ServiceRequest:requester",
            "ServiceRequest:performer",
            "ServiceRequest:subject",
            "ServiceRequest:patient",
            "Specimen:patient",
            "Specimen:subject",
            "Specimen:container-device",
            "SupplyRequest:requester",
            "Task:requester",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return DeviceBooleanEnd(search_string=search_string)


class DeviceAssociationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return DeviceAssociationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return DeviceAssociationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class DeviceAssociationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return DeviceAssociationBooleanEnd(search_string=search_string)


class DeviceAssociationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "subject",
            "patient",
            "device",
            "operator",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return DeviceAssociationValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "DeviceAssociation:subject",
            "DeviceAssociation:patient",
            "DeviceAssociation:device",
            "DeviceAssociation:operator",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return DeviceAssociationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return DeviceAssociationBooleanEnd(search_string=search_string)


class DeviceDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return DeviceDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return DeviceDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class DeviceDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return DeviceDefinitionBooleanEnd(search_string=search_string)


class DeviceDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "device-name",
            "organization",
            "specification",
            "type",
            "specification-version",
            "manufacturer",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return DeviceDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "DeviceDefinition:organization", "DeviceDefinition:manufacturer"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return DeviceDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdministrableProductDefinition:device",
            "ClinicalUseDefinition:product",
            "ClinicalUseDefinition:subject",
            "MedicationRequest:intended-performer",
            "RegulatedAuthorization:subject",
            "RequestOrchestration:participant",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return DeviceDefinitionBooleanEnd(search_string=search_string)


class DeviceDispenseBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return DeviceDispenseSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return DeviceDispenseSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class DeviceDispenseValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return DeviceDispenseBooleanEnd(search_string=search_string)


class DeviceDispenseSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "code",
            "subject",
            "patient",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return DeviceDispenseValue(search_string=search_string)

    def include(
        self,
        value: Literal["DeviceDispense:subject", "DeviceDispense:patient"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return DeviceDispenseBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return DeviceDispenseBooleanEnd(search_string=search_string)


class DeviceMetricBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return DeviceMetricSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return DeviceMetricSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class DeviceMetricValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return DeviceMetricBooleanEnd(search_string=search_string)


class DeviceMetricSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "category",
            "type",
            "device",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return DeviceMetricValue(search_string=search_string)

    def include(
        self,
        value: Literal["DeviceMetric:device"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return DeviceMetricBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["Observation:device"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return DeviceMetricBooleanEnd(search_string=search_string)


class DeviceRequestBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return DeviceRequestSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return DeviceRequestSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class DeviceRequestValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return DeviceRequestBooleanEnd(search_string=search_string)


class DeviceRequestSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "insurance",
            "performer-code",
            "requester",
            "identifier",
            "code",
            "performer",
            "event-date",
            "subject",
            "instantiates-canonical",
            "encounter",
            "authored-on",
            "intent",
            "group-identifier",
            "based-on",
            "patient",
            "instantiates-uri",
            "device",
            "prior-request",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return DeviceRequestValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "DeviceRequest:insurance",
            "DeviceRequest:requester",
            "DeviceRequest:performer",
            "DeviceRequest:subject",
            "DeviceRequest:instantiates-canonical",
            "DeviceRequest:encounter",
            "DeviceRequest:based-on",
            "DeviceRequest:patient",
            "DeviceRequest:device",
            "DeviceRequest:prior-request",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return DeviceRequestBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Appointment:based-on",
            "AuditEvent:based-on",
            "CarePlan:activity-reference",
            "DeviceRequest:prior-request",
            "DocumentReference:based-on",
            "Encounter:based-on",
            "Observation:based-on",
            "Provenance:based-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return DeviceRequestBooleanEnd(search_string=search_string)


class DeviceUsageBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return DeviceUsageSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return DeviceUsageSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class DeviceUsageValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return DeviceUsageBooleanEnd(search_string=search_string)


class DeviceUsageSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "patient",
            "device",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return DeviceUsageValue(search_string=search_string)

    def include(
        self,
        value: Literal["DeviceUsage:patient"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return DeviceUsageBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return DeviceUsageBooleanEnd(search_string=search_string)


class DiagnosticReportBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return DiagnosticReportSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return DiagnosticReportSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class DiagnosticReportValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return DiagnosticReportBooleanEnd(search_string=search_string)


class DiagnosticReportSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "study",
            "code",
            "performer",
            "subject",
            "encounter",
            "media",
            "conclusion",
            "result",
            "based-on",
            "patient",
            "specimen",
            "category",
            "issued",
            "results-interpreter",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return DiagnosticReportValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "DiagnosticReport:study",
            "DiagnosticReport:performer",
            "DiagnosticReport:subject",
            "DiagnosticReport:encounter",
            "DiagnosticReport:media",
            "DiagnosticReport:result",
            "DiagnosticReport:based-on",
            "DiagnosticReport:patient",
            "DiagnosticReport:specimen",
            "DiagnosticReport:results-interpreter",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return DiagnosticReportBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["Procedure:report"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return DiagnosticReportBooleanEnd(search_string=search_string)


class DocumentReferenceBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return DocumentReferenceSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return DocumentReferenceSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class DocumentReferenceValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return DocumentReferenceBooleanEnd(search_string=search_string)


class DocumentReferenceSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "modality",
            "subject",
            "description",
            "language",
            "type",
            "relation",
            "setting",
            "doc-status",
            "based-on",
            "format-canonical",
            "patient",
            "context",
            "relationship",
            "creation",
            "identifier",
            "period",
            "event-code",
            "bodysite",
            "custodian",
            "author",
            "format-code",
            "bodysite-reference",
            "format-uri",
            "version",
            "attester",
            "contenttype",
            "event-reference",
            "security-label",
            "location",
            "category",
            "relatesto",
            "facility",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return DocumentReferenceValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "DocumentReference:subject",
            "DocumentReference:based-on",
            "DocumentReference:format-canonical",
            "DocumentReference:patient",
            "DocumentReference:context",
            "DocumentReference:custodian",
            "DocumentReference:author",
            "DocumentReference:bodysite-reference",
            "DocumentReference:attester",
            "DocumentReference:event-reference",
            "DocumentReference:relatesto",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return DocumentReferenceBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Consent:source-reference",
            "DiagnosticReport:media",
            "DocumentReference:relatesto",
            "ImagingSelection:derived-from",
            "MedicationKnowledge:monograph",
            "MedicinalProductDefinition:master-file",
            "Observation:derived-from",
            "Procedure:report",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return DocumentReferenceBooleanEnd(search_string=search_string)


class EncounterBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return EncounterSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return EncounterSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class EncounterValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return EncounterBooleanEnd(search_string=search_string)


class EncounterSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "participant-type",
            "subject",
            "subject-status",
            "appointment",
            "part-of",
            "type",
            "participant",
            "reason-code",
            "based-on",
            "date-start",
            "patient",
            "location-period",
            "special-arrangement",
            "class",
            "identifier",
            "diagnosis-code",
            "practitioner",
            "episode-of-care",
            "length",
            "careteam",
            "end-date",
            "diagnosis-reference",
            "reason-reference",
            "location",
            "service-provider",
            "account",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return EncounterValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Encounter:subject",
            "Encounter:appointment",
            "Encounter:part-of",
            "Encounter:participant",
            "Encounter:based-on",
            "Encounter:patient",
            "Encounter:practitioner",
            "Encounter:episode-of-care",
            "Encounter:careteam",
            "Encounter:diagnosis-reference",
            "Encounter:reason-reference",
            "Encounter:location",
            "Encounter:service-provider",
            "Encounter:account",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return EncounterBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AuditEvent:encounter",
            "CarePlan:encounter",
            "ChargeItem:encounter",
            "Claim:encounter",
            "ClinicalImpression:encounter",
            "Communication:encounter",
            "CommunicationRequest:encounter",
            "Composition:encounter",
            "Condition:encounter",
            "DeviceRequest:encounter",
            "DiagnosticReport:encounter",
            "DocumentReference:context",
            "Encounter:part-of",
            "EncounterHistory:encounter",
            "ExplanationOfBenefit:encounter",
            "Flag:encounter",
            "ImagingStudy:encounter",
            "List:encounter",
            "MedicationAdministration:encounter",
            "MedicationDispense:encounter",
            "MedicationRequest:encounter",
            "MedicationStatement:encounter",
            "NutritionIntake:encounter",
            "NutritionOrder:encounter",
            "Observation:encounter",
            "PaymentReconciliation:allocation-encounter",
            "Procedure:encounter",
            "Provenance:encounter",
            "QuestionnaireResponse:encounter",
            "RequestOrchestration:encounter",
            "RiskAssessment:encounter",
            "ServiceRequest:encounter",
            "Task:encounter",
            "VisionPrescription:encounter",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return EncounterBooleanEnd(search_string=search_string)


class EncounterHistoryBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return EncounterHistorySearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return EncounterHistorySearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class EncounterHistoryValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return EncounterHistoryBooleanEnd(search_string=search_string)


class EncounterHistorySearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "patient",
            "subject",
            "encounter",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return EncounterHistoryValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "EncounterHistory:patient",
            "EncounterHistory:subject",
            "EncounterHistory:encounter",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return EncounterHistoryBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return EncounterHistoryBooleanEnd(search_string=search_string)


class EndpointBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return EndpointSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return EndpointSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class EndpointValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return EndpointBooleanEnd(search_string=search_string)


class EndpointSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "payload-type",
            "identifier",
            "connection-type",
            "organization",
            "name",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return EndpointValue(search_string=search_string)

    def include(
        self,
        value: Literal["Endpoint:organization"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return EndpointBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Communication:sender",
            "Communication:recipient",
            "CommunicationRequest:recipient",
            "CommunicationRequest:information-provider",
            "HealthcareService:endpoint",
            "ImagingStudy:endpoint",
            "InsurancePlan:endpoint",
            "Location:endpoint",
            "Organization:endpoint",
            "OrganizationAffiliation:endpoint",
            "PractitionerRole:endpoint",
            "RequestOrchestration:participant",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return EndpointBooleanEnd(search_string=search_string)


class EnrollmentRequestBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return EnrollmentRequestSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return EnrollmentRequestSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class EnrollmentRequestValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return EnrollmentRequestBooleanEnd(search_string=search_string)


class EnrollmentRequestSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "patient",
            "subject",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return EnrollmentRequestValue(search_string=search_string)

    def include(
        self,
        value: Literal["EnrollmentRequest:patient", "EnrollmentRequest:subject"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return EnrollmentRequestBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["DocumentReference:based-on", "EnrollmentResponse:request"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return EnrollmentRequestBooleanEnd(search_string=search_string)


class EnrollmentResponseBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return EnrollmentResponseSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return EnrollmentResponseSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class EnrollmentResponseValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return EnrollmentResponseBooleanEnd(search_string=search_string)


class EnrollmentResponseSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "request",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return EnrollmentResponseValue(search_string=search_string)

    def include(
        self,
        value: Literal["EnrollmentResponse:request"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return EnrollmentResponseBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return EnrollmentResponseBooleanEnd(search_string=search_string)


class EpisodeOfCareBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return EpisodeOfCareSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return EpisodeOfCareSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class EpisodeOfCareValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return EpisodeOfCareBooleanEnd(search_string=search_string)


class EpisodeOfCareSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "diagnosis-code",
            "diagnosis-reference",
            "patient",
            "organization",
            "reason-reference",
            "type",
            "care-manager",
            "reason-code",
            "incoming-referral",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return EpisodeOfCareValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "EpisodeOfCare:diagnosis-reference",
            "EpisodeOfCare:patient",
            "EpisodeOfCare:organization",
            "EpisodeOfCare:reason-reference",
            "EpisodeOfCare:care-manager",
            "EpisodeOfCare:incoming-referral",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return EpisodeOfCareBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["DocumentReference:context", "Encounter:episode-of-care"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return EpisodeOfCareBooleanEnd(search_string=search_string)


class EventDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return EventDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return EventDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class EventDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return EventDefinitionBooleanEnd(search_string=search_string)


class EventDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "successor",
            "context-type-value",
            "jurisdiction",
            "derived-from",
            "description",
            "context-type",
            "predecessor",
            "composed-of",
            "title",
            "version",
            "url",
            "context-quantity",
            "depends-on",
            "effective",
            "context",
            "name",
            "publisher",
            "topic",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return EventDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "EventDefinition:successor",
            "EventDefinition:derived-from",
            "EventDefinition:predecessor",
            "EventDefinition:composed-of",
            "EventDefinition:depends-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return EventDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return EventDefinitionBooleanEnd(search_string=search_string)


class EvidenceBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return EvidenceSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return EvidenceSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class EvidenceValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return EvidenceBooleanEnd(search_string=search_string)


class EvidenceSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "context-type-value",
            "description",
            "context-type",
            "title",
            "version",
            "url",
            "context-quantity",
            "context",
            "publisher",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return EvidenceValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return EvidenceBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return EvidenceBooleanEnd(search_string=search_string)


class EvidenceReportBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return EvidenceReportSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return EvidenceReportSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class EvidenceReportValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return EvidenceReportBooleanEnd(search_string=search_string)


class EvidenceReportSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "context-quantity",
            "identifier",
            "context-type-value",
            "context",
            "publisher",
            "context-type",
            "context-type-quantity",
            "url",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return EvidenceReportValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return EvidenceReportBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return EvidenceReportBooleanEnd(search_string=search_string)


class EvidenceVariableBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return EvidenceVariableSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return EvidenceVariableSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class EvidenceVariableValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return EvidenceVariableBooleanEnd(search_string=search_string)


class EvidenceVariableSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "successor",
            "context-type-value",
            "derived-from",
            "description",
            "context-type",
            "predecessor",
            "composed-of",
            "title",
            "version",
            "url",
            "context-quantity",
            "depends-on",
            "context",
            "name",
            "publisher",
            "topic",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return EvidenceVariableValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "EvidenceVariable:successor",
            "EvidenceVariable:derived-from",
            "EvidenceVariable:predecessor",
            "EvidenceVariable:composed-of",
            "EvidenceVariable:depends-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return EvidenceVariableBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["ResearchStudy:eligibility"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return EvidenceVariableBooleanEnd(search_string=search_string)


class ExampleScenarioBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ExampleScenarioSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ExampleScenarioSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ExampleScenarioValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ExampleScenarioBooleanEnd(search_string=search_string)


class ExampleScenarioSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "context-type-value",
            "jurisdiction",
            "context-type",
            "version",
            "url",
            "context-quantity",
            "context",
            "name",
            "publisher",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ExampleScenarioValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ExampleScenarioBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ExampleScenarioBooleanEnd(search_string=search_string)


class ExplanationOfBenefitBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ExplanationOfBenefitSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ExplanationOfBenefitSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ExplanationOfBenefitValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ExplanationOfBenefitBooleanEnd(search_string=search_string)


class ExplanationOfBenefitSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "care-team",
            "coverage",
            "identifier",
            "created",
            "encounter",
            "payee",
            "disposition",
            "provider",
            "patient",
            "detail-udi",
            "claim",
            "enterer",
            "procedure-udi",
            "subdetail-udi",
            "facility",
            "item-udi",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ExplanationOfBenefitValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ExplanationOfBenefit:care-team",
            "ExplanationOfBenefit:coverage",
            "ExplanationOfBenefit:encounter",
            "ExplanationOfBenefit:payee",
            "ExplanationOfBenefit:provider",
            "ExplanationOfBenefit:patient",
            "ExplanationOfBenefit:detail-udi",
            "ExplanationOfBenefit:claim",
            "ExplanationOfBenefit:enterer",
            "ExplanationOfBenefit:procedure-udi",
            "ExplanationOfBenefit:subdetail-udi",
            "ExplanationOfBenefit:facility",
            "ExplanationOfBenefit:item-udi",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ExplanationOfBenefitBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ExplanationOfBenefitBooleanEnd(search_string=search_string)


class FamilyMemberHistoryBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return FamilyMemberHistorySearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return FamilyMemberHistorySearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class FamilyMemberHistoryValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return FamilyMemberHistoryBooleanEnd(search_string=search_string)


class FamilyMemberHistorySearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "code",
            "patient",
            "sex",
            "instantiates-canonical",
            "instantiates-uri",
            "relationship",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return FamilyMemberHistoryValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "FamilyMemberHistory:patient", "FamilyMemberHistory:instantiates-canonical"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return FamilyMemberHistoryBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return FamilyMemberHistoryBooleanEnd(search_string=search_string)


class FlagBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return FlagSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return FlagSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class FlagValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return FlagBooleanEnd(search_string=search_string)


class FlagSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "author",
            "patient",
            "subject",
            "encounter",
            "category",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return FlagValue(search_string=search_string)

    def include(
        self,
        value: Literal["Flag:author", "Flag:patient", "Flag:subject", "Flag:encounter"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return FlagBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return FlagBooleanEnd(search_string=search_string)


class FormularyItemBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return FormularyItemSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return FormularyItemSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class FormularyItemValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return FormularyItemBooleanEnd(search_string=search_string)


class FormularyItemSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "code",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return FormularyItemValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return FormularyItemBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return FormularyItemBooleanEnd(search_string=search_string)


class GenomicStudyBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return GenomicStudySearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return GenomicStudySearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class GenomicStudyValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return GenomicStudyBooleanEnd(search_string=search_string)


class GenomicStudySearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "patient",
            "subject",
            "focus",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return GenomicStudyValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "GenomicStudy:patient", "GenomicStudy:subject", "GenomicStudy:focus"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return GenomicStudyBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "DiagnosticReport:study", "Observation:derived-from", "Observation:part-of"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return GenomicStudyBooleanEnd(search_string=search_string)


class GoalBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return GoalSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return GoalSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class GoalValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return GoalBooleanEnd(search_string=search_string)


class GoalSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "target-measure",
            "identifier",
            "addresses",
            "lifecycle-status",
            "achievement-status",
            "patient",
            "subject",
            "description",
            "start-date",
            "category",
            "target-date",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return GoalValue(search_string=search_string)

    def include(
        self,
        value: Literal["Goal:addresses", "Goal:patient", "Goal:subject"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return GoalBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["CarePlan:goal"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return GoalBooleanEnd(search_string=search_string)


class GraphDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return GraphDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return GraphDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class GraphDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return GraphDefinitionBooleanEnd(search_string=search_string)


class GraphDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "context-type-value",
            "jurisdiction",
            "start",
            "description",
            "context-type",
            "version",
            "url",
            "context-quantity",
            "context",
            "name",
            "publisher",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return GraphDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return GraphDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return GraphDefinitionBooleanEnd(search_string=search_string)


class GroupBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return GroupSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return GroupSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class GroupValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return GroupBooleanEnd(search_string=search_string)


class GroupSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "characteristic-value",
            "managing-entity",
            "code",
            "member",
            "name",
            "exclude",
            "membership",
            "type",
            "characteristic-reference",
            "value",
            "characteristic",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return GroupValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Group:managing-entity", "Group:member", "Group:characteristic-reference"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return GroupBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdverseEvent:subject",
            "AdverseEvent:patient",
            "Appointment:practitioner",
            "Appointment:subject",
            "Appointment:actor",
            "Appointment:patient",
            "Appointment:location",
            "Appointment:group",
            "AppointmentResponse:actor",
            "AppointmentResponse:practitioner",
            "AppointmentResponse:patient",
            "AppointmentResponse:location",
            "AppointmentResponse:group",
            "CarePlan:subject",
            "CarePlan:patient",
            "CareTeam:patient",
            "CareTeam:subject",
            "ChargeItem:subject",
            "ChargeItem:patient",
            "ClinicalImpression:patient",
            "ClinicalImpression:subject",
            "Communication:subject",
            "Communication:patient",
            "Communication:recipient",
            "CommunicationRequest:subject",
            "CommunicationRequest:patient",
            "CommunicationRequest:recipient",
            "Condition:subject",
            "Condition:patient",
            "Consent:subject",
            "Consent:actor",
            "Consent:patient",
            "DetectedIssue:subject",
            "DetectedIssue:patient",
            "DeviceAssociation:subject",
            "DeviceAssociation:patient",
            "DeviceRequest:subject",
            "DeviceRequest:patient",
            "DiagnosticReport:subject",
            "DiagnosticReport:patient",
            "Encounter:subject",
            "Encounter:participant",
            "Encounter:patient",
            "Encounter:practitioner",
            "EncounterHistory:patient",
            "EncounterHistory:subject",
            "Flag:patient",
            "Flag:subject",
            "GenomicStudy:patient",
            "GenomicStudy:subject",
            "Goal:patient",
            "Goal:subject",
            "Group:member",
            "GuidanceResponse:patient",
            "GuidanceResponse:subject",
            "ImagingSelection:subject",
            "ImagingSelection:patient",
            "ImagingStudy:subject",
            "ImagingStudy:patient",
            "Invoice:subject",
            "Invoice:patient",
            "MeasureReport:patient",
            "MeasureReport:subject",
            "MeasureReport:reporter",
            "MedicationAdministration:subject",
            "MedicationAdministration:patient",
            "MedicationDispense:subject",
            "MedicationDispense:patient",
            "MedicationRequest:subject",
            "MedicationRequest:patient",
            "MedicationStatement:patient",
            "MedicationStatement:subject",
            "MolecularSequence:subject",
            "MolecularSequence:patient",
            "NutritionIntake:patient",
            "NutritionIntake:subject",
            "NutritionOrder:subject",
            "NutritionOrder:patient",
            "Observation:subject",
            "Observation:patient",
            "Observation:specimen",
            "Procedure:subject",
            "Procedure:patient",
            "RequestOrchestration:subject",
            "RequestOrchestration:participant",
            "RequestOrchestration:patient",
            "ResearchStudy:eligibility",
            "ResearchSubject:subject",
            "ResearchSubject:patient",
            "RiskAssessment:patient",
            "RiskAssessment:subject",
            "ServiceRequest:subject",
            "ServiceRequest:patient",
            "Specimen:patient",
            "Specimen:subject",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return GroupBooleanEnd(search_string=search_string)


class GuidanceResponseBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return GuidanceResponseSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return GuidanceResponseSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class GuidanceResponseValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return GuidanceResponseBooleanEnd(search_string=search_string)


class GuidanceResponseSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "request",
            "patient",
            "subject",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return GuidanceResponseValue(search_string=search_string)

    def include(
        self,
        value: Literal["GuidanceResponse:patient", "GuidanceResponse:subject"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return GuidanceResponseBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return GuidanceResponseBooleanEnd(search_string=search_string)


class HealthcareServiceBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return HealthcareServiceSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return HealthcareServiceSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class HealthcareServiceValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return HealthcareServiceBooleanEnd(search_string=search_string)


class HealthcareServiceSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "specialty",
            "service-category",
            "service-type",
            "active",
            "eligibility",
            "program",
            "characteristic",
            "endpoint",
            "coverage-area",
            "organization",
            "offered-in",
            "name",
            "location",
            "communication",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return HealthcareServiceValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "HealthcareService:endpoint",
            "HealthcareService:coverage-area",
            "HealthcareService:organization",
            "HealthcareService:offered-in",
            "HealthcareService:location",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return HealthcareServiceBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Account:patient",
            "Account:subject",
            "Appointment:practitioner",
            "Appointment:actor",
            "Appointment:patient",
            "Appointment:location",
            "Appointment:group",
            "AppointmentResponse:actor",
            "AppointmentResponse:practitioner",
            "AppointmentResponse:patient",
            "AppointmentResponse:location",
            "AppointmentResponse:group",
            "ChargeItem:performer-actor",
            "Communication:sender",
            "Communication:recipient",
            "CommunicationRequest:recipient",
            "CommunicationRequest:information-provider",
            "Consent:controller",
            "Consent:manager",
            "Consent:grantee",
            "Encounter:participant",
            "Encounter:practitioner",
            "Group:member",
            "HealthcareService:offered-in",
            "ImagingStudy:performer",
            "MeasureReport:patient",
            "MeasureReport:subject",
            "MedicationRequest:intended-performer",
            "OrganizationAffiliation:service",
            "PractitionerRole:service",
            "Procedure:performer",
            "RequestOrchestration:subject",
            "RequestOrchestration:participant",
            "RequestOrchestration:patient",
            "Schedule:actor",
            "ServiceRequest:performer",
            "Subscription:owner",
            "SupplyRequest:supplier",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return HealthcareServiceBooleanEnd(search_string=search_string)


class ImagingSelectionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ImagingSelectionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ImagingSelectionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ImagingSelectionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ImagingSelectionBooleanEnd(search_string=search_string)


class ImagingSelectionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "body-structure",
            "based-on",
            "code",
            "subject",
            "patient",
            "derived-from",
            "issued",
            "body-site",
            "study-uid",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ImagingSelectionValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ImagingSelection:body-structure",
            "ImagingSelection:based-on",
            "ImagingSelection:subject",
            "ImagingSelection:patient",
            "ImagingSelection:derived-from",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ImagingSelectionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["Observation:derived-from"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ImagingSelectionBooleanEnd(search_string=search_string)


class ImagingStudyBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ImagingStudySearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ImagingStudySearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ImagingStudyValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ImagingStudyBooleanEnd(search_string=search_string)


class ImagingStudySearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "reason",
            "dicom-class",
            "instance",
            "modality",
            "performer",
            "subject",
            "started",
            "encounter",
            "referrer",
            "body-structure",
            "endpoint",
            "based-on",
            "patient",
            "series",
            "body-site",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ImagingStudyValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ImagingStudy:performer",
            "ImagingStudy:subject",
            "ImagingStudy:encounter",
            "ImagingStudy:referrer",
            "ImagingStudy:body-structure",
            "ImagingStudy:endpoint",
            "ImagingStudy:based-on",
            "ImagingStudy:patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ImagingStudyBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "DiagnosticReport:study",
            "ImagingSelection:derived-from",
            "Observation:derived-from",
            "Observation:part-of",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ImagingStudyBooleanEnd(search_string=search_string)


class ImmunizationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ImmunizationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ImmunizationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ImmunizationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ImmunizationBooleanEnd(search_string=search_string)


class ImmunizationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "performer",
            "reaction",
            "lot-number",
            "status-reason",
            "reason-code",
            "manufacturer",
            "target-disease",
            "patient",
            "series",
            "vaccine-code",
            "reason-reference",
            "location",
            "reaction-date",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ImmunizationValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Immunization:performer",
            "Immunization:reaction",
            "Immunization:manufacturer",
            "Immunization:patient",
            "Immunization:reason-reference",
            "Immunization:location",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ImmunizationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdverseEvent:substance",
            "ImmunizationEvaluation:immunization-event",
            "ImmunizationRecommendation:support",
            "Observation:part-of",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ImmunizationBooleanEnd(search_string=search_string)


class ImmunizationEvaluationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ImmunizationEvaluationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ImmunizationEvaluationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ImmunizationEvaluationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ImmunizationEvaluationBooleanEnd(search_string=search_string)


class ImmunizationEvaluationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "target-disease",
            "patient",
            "dose-status",
            "immunization-event",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ImmunizationEvaluationValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ImmunizationEvaluation:patient",
            "ImmunizationEvaluation:immunization-event",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ImmunizationEvaluationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["ImmunizationRecommendation:support"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ImmunizationEvaluationBooleanEnd(search_string=search_string)


class ImmunizationRecommendationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ImmunizationRecommendationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ImmunizationRecommendationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ImmunizationRecommendationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ImmunizationRecommendationBooleanEnd(search_string=search_string)


class ImmunizationRecommendationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "target-disease",
            "patient",
            "vaccine-type",
            "information",
            "support",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ImmunizationRecommendationValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ImmunizationRecommendation:patient",
            "ImmunizationRecommendation:information",
            "ImmunizationRecommendation:support",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ImmunizationRecommendationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AuditEvent:based-on",
            "CarePlan:activity-reference",
            "DiagnosticReport:based-on",
            "DocumentReference:based-on",
            "Observation:based-on",
            "Provenance:based-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ImmunizationRecommendationBooleanEnd(search_string=search_string)


class ImplementationGuideBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ImplementationGuideSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ImplementationGuideSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ImplementationGuideValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ImplementationGuideBooleanEnd(search_string=search_string)


class ImplementationGuideSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "context-type-value",
            "resource",
            "jurisdiction",
            "description",
            "context-type",
            "experimental",
            "global",
            "title",
            "version",
            "url",
            "context-quantity",
            "depends-on",
            "context",
            "name",
            "publisher",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ImplementationGuideValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ImplementationGuide:resource",
            "ImplementationGuide:global",
            "ImplementationGuide:depends-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ImplementationGuideBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["CapabilityStatement:guide", "ImplementationGuide:depends-on"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ImplementationGuideBooleanEnd(search_string=search_string)


class IngredientBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return IngredientSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return IngredientSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class IngredientValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return IngredientBooleanEnd(search_string=search_string)


class IngredientSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "role",
            "substance",
            "strength-concentration-ratio",
            "for",
            "substance-code",
            "strength-concentration-quantity",
            "manufacturer",
            "substance-definition",
            "function",
            "strength-presentation-ratio",
            "strength-presentation-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return IngredientValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Ingredient:substance",
            "Ingredient:for",
            "Ingredient:manufacturer",
            "Ingredient:substance-definition",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return IngredientBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["RegulatedAuthorization:subject"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return IngredientBooleanEnd(search_string=search_string)


class InsurancePlanBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return InsurancePlanSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return InsurancePlanSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class InsurancePlanValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return InsurancePlanBooleanEnd(search_string=search_string)


class InsurancePlanSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "address",
            "address-state",
            "owned-by",
            "type",
            "address-postalcode",
            "address-country",
            "administered-by",
            "endpoint",
            "phonetic",
            "address-use",
            "name",
            "address-city",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return InsurancePlanValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "InsurancePlan:owned-by",
            "InsurancePlan:administered-by",
            "InsurancePlan:endpoint",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return InsurancePlanBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return InsurancePlanBooleanEnd(search_string=search_string)


class InventoryItemBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return InventoryItemSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return InventoryItemSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class InventoryItemValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return InventoryItemBooleanEnd(search_string=search_string)


class InventoryItemSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "code",
            "subject",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return InventoryItemValue(search_string=search_string)

    def include(
        self,
        value: Literal["InventoryItem:subject"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return InventoryItemBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return InventoryItemBooleanEnd(search_string=search_string)


class InventoryReportBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return InventoryReportSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return InventoryReportSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class InventoryReportValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return InventoryReportBooleanEnd(search_string=search_string)


class InventoryReportSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "item-reference",
            "identifier",
            "item",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return InventoryReportValue(search_string=search_string)

    def include(
        self,
        value: Literal["InventoryReport:item-reference"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return InventoryReportBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return InventoryReportBooleanEnd(search_string=search_string)


class InvoiceBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return InvoiceSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return InvoiceSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class InvoiceValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return InvoiceBooleanEnd(search_string=search_string)


class InvoiceSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "totalgross",
            "participant-role",
            "subject",
            "type",
            "issuer",
            "participant",
            "totalnet",
            "patient",
            "recipient",
            "account",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return InvoiceValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Invoice:subject",
            "Invoice:issuer",
            "Invoice:participant",
            "Invoice:patient",
            "Invoice:recipient",
            "Invoice:account",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return InvoiceBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return InvoiceBooleanEnd(search_string=search_string)


class LibraryBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return LibrarySearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return LibrarySearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class LibraryValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return LibraryBooleanEnd(search_string=search_string)


class LibrarySearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "successor",
            "context-type-value",
            "jurisdiction",
            "derived-from",
            "description",
            "context-type",
            "predecessor",
            "composed-of",
            "title",
            "type",
            "version",
            "url",
            "context-quantity",
            "depends-on",
            "effective",
            "context",
            "name",
            "publisher",
            "topic",
            "content-type",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return LibraryValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Library:successor",
            "Library:derived-from",
            "Library:predecessor",
            "Library:composed-of",
            "Library:depends-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return LibraryBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "ActivityDefinition:depends-on",
            "Measure:depends-on",
            "PlanDefinition:depends-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return LibraryBooleanEnd(search_string=search_string)


class LinkageBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return LinkageSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return LinkageSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class LinkageValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return LinkageBooleanEnd(search_string=search_string)


class LinkageSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "item",
            "author",
            "source",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return LinkageValue(search_string=search_string)

    def include(
        self,
        value: Literal["Linkage:item", "Linkage:author", "Linkage:source"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return LinkageBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return LinkageBooleanEnd(search_string=search_string)


class ListBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ListSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ListSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ListValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ListBooleanEnd(search_string=search_string)


class ListSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "empty-reason",
            "item",
            "code",
            "notes",
            "patient",
            "subject",
            "encounter",
            "source",
            "title",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ListValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "List:item", "List:patient", "List:subject", "List:encounter", "List:source"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ListBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ListBooleanEnd(search_string=search_string)


class LocationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return LocationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return LocationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class LocationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return LocationBooleanEnd(search_string=search_string)


class LocationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "partof",
            "address",
            "address-state",
            "operational-status",
            "type",
            "address-postalcode",
            "characteristic",
            "address-country",
            "endpoint",
            "contains",
            "organization",
            "address-use",
            "name",
            "near",
            "address-city",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return LocationValue(search_string=search_string)

    def include(
        self,
        value: Literal["Location:partof", "Location:endpoint", "Location:organization"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return LocationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Account:patient",
            "Account:subject",
            "AdverseEvent:location",
            "Appointment:practitioner",
            "Appointment:actor",
            "Appointment:patient",
            "Appointment:location",
            "Appointment:group",
            "AppointmentResponse:actor",
            "AppointmentResponse:practitioner",
            "AppointmentResponse:patient",
            "AppointmentResponse:location",
            "AppointmentResponse:group",
            "Claim:facility",
            "Communication:recipient",
            "Contract:domain",
            "CoverageEligibilityRequest:facility",
            "DetectedIssue:subject",
            "DetectedIssue:patient",
            "Device:location",
            "DeviceRequest:subject",
            "DeviceRequest:patient",
            "DiagnosticReport:subject",
            "DiagnosticReport:patient",
            "Encounter:location",
            "ExplanationOfBenefit:facility",
            "Flag:patient",
            "Flag:subject",
            "Group:member",
            "HealthcareService:coverage-area",
            "HealthcareService:location",
            "ImagingSelection:subject",
            "ImagingSelection:patient",
            "Immunization:location",
            "Location:partof",
            "MeasureReport:patient",
            "MeasureReport:subject",
            "MeasureReport:location",
            "MedicationDispense:receiver",
            "MedicationDispense:destination",
            "MedicationDispense:location",
            "Observation:subject",
            "Observation:patient",
            "OrganizationAffiliation:location",
            "PractitionerRole:location",
            "Procedure:subject",
            "Procedure:patient",
            "Procedure:location",
            "Provenance:location",
            "RegulatedAuthorization:subject",
            "RequestOrchestration:subject",
            "RequestOrchestration:participant",
            "RequestOrchestration:patient",
            "ResearchStudy:site",
            "Schedule:actor",
            "ServiceRequest:subject",
            "ServiceRequest:patient",
            "Specimen:patient",
            "Specimen:subject",
            "SupplyRequest:subject",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return LocationBooleanEnd(search_string=search_string)


class ManufacturedItemDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ManufacturedItemDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ManufacturedItemDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ManufacturedItemDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ManufacturedItemDefinitionBooleanEnd(search_string=search_string)


class ManufacturedItemDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "ingredient",
            "name",
            "dose-form",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ManufacturedItemDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ManufacturedItemDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdministrableProductDefinition:manufactured-item",
            "Ingredient:for",
            "RegulatedAuthorization:subject",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ManufacturedItemDefinitionBooleanEnd(search_string=search_string)


class MeasureBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return MeasureSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return MeasureSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class MeasureValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return MeasureBooleanEnd(search_string=search_string)


class MeasureSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "successor",
            "context-type-value",
            "jurisdiction",
            "derived-from",
            "description",
            "context-type",
            "predecessor",
            "composed-of",
            "title",
            "version",
            "url",
            "context-quantity",
            "depends-on",
            "effective",
            "context",
            "name",
            "publisher",
            "topic",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return MeasureValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Measure:successor",
            "Measure:derived-from",
            "Measure:predecessor",
            "Measure:composed-of",
            "Measure:depends-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return MeasureBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "CarePlan:instantiates-canonical",
            "Communication:instantiates-canonical",
            "FamilyMemberHistory:instantiates-canonical",
            "MeasureReport:measure",
            "Procedure:instantiates-canonical",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return MeasureBooleanEnd(search_string=search_string)


class MeasureReportBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return MeasureReportSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return MeasureReportSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class MeasureReportValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return MeasureReportBooleanEnd(search_string=search_string)


class MeasureReportSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "period",
            "measure",
            "patient",
            "subject",
            "reporter",
            "location",
            "evaluated-resource",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return MeasureReportValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "MeasureReport:measure",
            "MeasureReport:patient",
            "MeasureReport:subject",
            "MeasureReport:reporter",
            "MeasureReport:location",
            "MeasureReport:evaluated-resource",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return MeasureReportBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return MeasureReportBooleanEnd(search_string=search_string)


class MedicationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return MedicationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return MedicationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class MedicationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return MedicationBooleanEnd(search_string=search_string)


class MedicationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "ingredient-code",
            "identifier",
            "code",
            "ingredient",
            "form",
            "lot-number",
            "serial-number",
            "expiration-date",
            "marketingauthorizationholder",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return MedicationValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Medication:ingredient", "Medication:marketingauthorizationholder"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return MedicationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdverseEvent:substance",
            "ClinicalUseDefinition:product",
            "ClinicalUseDefinition:subject",
            "DetectedIssue:subject",
            "DetectedIssue:patient",
            "DiagnosticReport:subject",
            "DiagnosticReport:patient",
            "Flag:patient",
            "Flag:subject",
            "ImagingSelection:subject",
            "ImagingSelection:patient",
            "Observation:subject",
            "Observation:patient",
            "ResearchSubject:subject",
            "ResearchSubject:patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return MedicationBooleanEnd(search_string=search_string)


class MedicationAdministrationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return MedicationAdministrationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return MedicationAdministrationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class MedicationAdministrationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return MedicationAdministrationBooleanEnd(search_string=search_string)


class MedicationAdministrationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "request",
            "code",
            "performer",
            "performer-device-code",
            "subject",
            "medication",
            "reason-given",
            "encounter",
            "reason-given-code",
            "patient",
            "reason-not-given",
            "device",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return MedicationAdministrationValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "MedicationAdministration:request",
            "MedicationAdministration:performer",
            "MedicationAdministration:subject",
            "MedicationAdministration:medication",
            "MedicationAdministration:reason-given",
            "MedicationAdministration:encounter",
            "MedicationAdministration:patient",
            "MedicationAdministration:device",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return MedicationAdministrationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdverseEvent:substance", "Observation:part-of", "Procedure:part-of"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return MedicationAdministrationBooleanEnd(search_string=search_string)


class MedicationDispenseBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return MedicationDispenseSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return MedicationDispenseSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class MedicationDispenseValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return MedicationDispenseBooleanEnd(search_string=search_string)


class MedicationDispenseSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "code",
            "performer",
            "receiver",
            "subject",
            "destination",
            "medication",
            "responsibleparty",
            "encounter",
            "type",
            "recorded",
            "whenhandedover",
            "whenprepared",
            "prescription",
            "patient",
            "location",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return MedicationDispenseValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "MedicationDispense:performer",
            "MedicationDispense:receiver",
            "MedicationDispense:subject",
            "MedicationDispense:destination",
            "MedicationDispense:medication",
            "MedicationDispense:responsibleparty",
            "MedicationDispense:encounter",
            "MedicationDispense:prescription",
            "MedicationDispense:patient",
            "MedicationDispense:location",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return MedicationDispenseBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["Observation:part-of"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return MedicationDispenseBooleanEnd(search_string=search_string)


class MedicationKnowledgeBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return MedicationKnowledgeSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return MedicationKnowledgeSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class MedicationKnowledgeValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return MedicationKnowledgeBooleanEnd(search_string=search_string)


class MedicationKnowledgeSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "product-type",
            "identifier",
            "code",
            "ingredient",
            "doseform",
            "classification-type",
            "monograph-type",
            "classification",
            "ingredient-code",
            "packaging-cost-concept",
            "source-cost",
            "monitoring-program-name",
            "monograph",
            "monitoring-program-type",
            "packaging-cost",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return MedicationKnowledgeValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "MedicationKnowledge:ingredient", "MedicationKnowledge:monograph"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return MedicationKnowledgeBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return MedicationKnowledgeBooleanEnd(search_string=search_string)


class MedicationRequestBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return MedicationRequestSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return MedicationRequestSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class MedicationRequestValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return MedicationRequestBooleanEnd(search_string=search_string)


class MedicationRequestSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "requester",
            "identifier",
            "intended-dispenser",
            "authoredon",
            "code",
            "combo-date",
            "subject",
            "medication",
            "encounter",
            "priority",
            "intent",
            "group-identifier",
            "intended-performer",
            "patient",
            "intended-performertype",
            "category",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return MedicationRequestValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "MedicationRequest:requester",
            "MedicationRequest:intended-dispenser",
            "MedicationRequest:subject",
            "MedicationRequest:medication",
            "MedicationRequest:encounter",
            "MedicationRequest:intended-performer",
            "MedicationRequest:patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return MedicationRequestBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Appointment:based-on",
            "AuditEvent:based-on",
            "CarePlan:activity-reference",
            "DiagnosticReport:based-on",
            "DocumentReference:based-on",
            "Encounter:based-on",
            "Goal:addresses",
            "MedicationAdministration:request",
            "MedicationDispense:prescription",
            "Observation:based-on",
            "Provenance:based-on",
            "ServiceRequest:based-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return MedicationRequestBooleanEnd(search_string=search_string)


class MedicationStatementBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return MedicationStatementSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return MedicationStatementSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class MedicationStatementValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return MedicationStatementBooleanEnd(search_string=search_string)


class MedicationStatementSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "effective",
            "identifier",
            "code",
            "adherence",
            "patient",
            "subject",
            "medication",
            "encounter",
            "source",
            "category",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return MedicationStatementValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "MedicationStatement:patient",
            "MedicationStatement:subject",
            "MedicationStatement:medication",
            "MedicationStatement:encounter",
            "MedicationStatement:source",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return MedicationStatementBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdverseEvent:substance", "Goal:addresses", "Observation:part-of"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return MedicationStatementBooleanEnd(search_string=search_string)


class MedicinalProductDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return MedicinalProductDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return MedicinalProductDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class MedicinalProductDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return MedicinalProductDefinitionBooleanEnd(search_string=search_string)


class MedicinalProductDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "ingredient",
            "master-file",
            "contact",
            "domain",
            "name",
            "name-language",
            "type",
            "characteristic",
            "characteristic-type",
            "product-classification",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return MedicinalProductDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "MedicinalProductDefinition:master-file",
            "MedicinalProductDefinition:contact",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return MedicinalProductDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdministrableProductDefinition:form-of",
            "ClinicalUseDefinition:product",
            "ClinicalUseDefinition:subject",
            "Ingredient:for",
            "PackagedProductDefinition:package-for",
            "RegulatedAuthorization:subject",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return MedicinalProductDefinitionBooleanEnd(search_string=search_string)


class MessageDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return MessageDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return MessageDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class MessageDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return MessageDefinitionBooleanEnd(search_string=search_string)


class MessageDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "parent",
            "context-type-value",
            "jurisdiction",
            "description",
            "focus",
            "context-type",
            "title",
            "version",
            "url",
            "context-quantity",
            "context",
            "name",
            "publisher",
            "category",
            "event",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return MessageDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal["MessageDefinition:parent"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return MessageDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["PlanDefinition:definition"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return MessageDefinitionBooleanEnd(search_string=search_string)


class MessageHeaderBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return MessageHeaderSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return MessageHeaderSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class MessageHeaderValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return MessageHeaderBooleanEnd(search_string=search_string)


class MessageHeaderSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "code",
            "receiver",
            "sender",
            "author",
            "responsible",
            "destination",
            "focus",
            "response-id",
            "source",
            "event",
            "target",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return MessageHeaderValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "MessageHeader:receiver",
            "MessageHeader:sender",
            "MessageHeader:author",
            "MessageHeader:responsible",
            "MessageHeader:focus",
            "MessageHeader:target",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return MessageHeaderBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return MessageHeaderBooleanEnd(search_string=search_string)


class MolecularSequenceBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return MolecularSequenceSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return MolecularSequenceSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class MolecularSequenceValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return MolecularSequenceBooleanEnd(search_string=search_string)


class MolecularSequenceSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "subject",
            "patient",
            "focus",
            "type",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return MolecularSequenceValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "MolecularSequence:subject",
            "MolecularSequence:patient",
            "MolecularSequence:focus",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return MolecularSequenceBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Observation:derived-from",
            "Observation:has-member",
            "Observation:value-reference",
            "Observation:component-value-reference",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return MolecularSequenceBooleanEnd(search_string=search_string)


class NamingSystemBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return NamingSystemSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return NamingSystemSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class NamingSystemValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return NamingSystemBooleanEnd(search_string=search_string)


class NamingSystemSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "context-type-value",
            "jurisdiction",
            "description",
            "derived-from",
            "context-type",
            "predecessor",
            "type",
            "context-quantity",
            "effective",
            "contact",
            "responsible",
            "context",
            "telecom",
            "value",
            "context-type-quantity",
            "identifier",
            "period",
            "kind",
            "version",
            "url",
            "id-type",
            "name",
            "publisher",
            "topic",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return NamingSystemValue(search_string=search_string)

    def include(
        self,
        value: Literal["NamingSystem:derived-from", "NamingSystem:predecessor"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return NamingSystemBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return NamingSystemBooleanEnd(search_string=search_string)


class NutritionIntakeBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return NutritionIntakeSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return NutritionIntakeSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class NutritionIntakeValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return NutritionIntakeBooleanEnd(search_string=search_string)


class NutritionIntakeSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "nutrition",
            "code",
            "patient",
            "subject",
            "encounter",
            "source",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return NutritionIntakeValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "NutritionIntake:patient",
            "NutritionIntake:subject",
            "NutritionIntake:encounter",
            "NutritionIntake:source",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return NutritionIntakeBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return NutritionIntakeBooleanEnd(search_string=search_string)


class NutritionOrderBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return NutritionOrderSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return NutritionOrderSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class NutritionOrderValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return NutritionOrderBooleanEnd(search_string=search_string)


class NutritionOrderSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "group-identifier",
            "datetime",
            "provider",
            "subject",
            "patient",
            "supplement",
            "formula",
            "encounter",
            "oraldiet",
            "additive",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return NutritionOrderValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "NutritionOrder:provider",
            "NutritionOrder:subject",
            "NutritionOrder:patient",
            "NutritionOrder:encounter",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return NutritionOrderBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AuditEvent:based-on",
            "CarePlan:activity-reference",
            "CarePlan:based-on",
            "DiagnosticReport:based-on",
            "DocumentReference:based-on",
            "Goal:addresses",
            "Observation:based-on",
            "Provenance:based-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return NutritionOrderBooleanEnd(search_string=search_string)


class NutritionProductBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return NutritionProductSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return NutritionProductSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class NutritionProductValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return NutritionProductBooleanEnd(search_string=search_string)


class NutritionProductSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "code",
            "lot-number",
            "serial-number",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return NutritionProductValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return NutritionProductBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "ClinicalUseDefinition:product",
            "ClinicalUseDefinition:subject",
            "DetectedIssue:subject",
            "DetectedIssue:patient",
            "GenomicStudy:patient",
            "GenomicStudy:subject",
            "MolecularSequence:subject",
            "MolecularSequence:patient",
            "Observation:subject",
            "Observation:patient",
            "RegulatedAuthorization:subject",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return NutritionProductBooleanEnd(search_string=search_string)


class ObservationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ObservationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ObservationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ObservationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ObservationBooleanEnd(search_string=search_string)


class ObservationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "combo-data-absent-reason",
            "code",
            "combo-code-value-quantity",
            "component-data-absent-reason",
            "subject",
            "value-concept",
            "value-date",
            "derived-from",
            "focus",
            "part-of",
            "component-value-canonical",
            "has-member",
            "value-reference",
            "code-value-string",
            "component-code-value-quantity",
            "based-on",
            "code-value-date",
            "patient",
            "specimen",
            "code-value-quantity",
            "component-code",
            "value-markdown",
            "combo-code-value-concept",
            "identifier",
            "component-value-reference",
            "performer",
            "combo-code",
            "method",
            "value-quantity",
            "component-value-quantity",
            "data-absent-reason",
            "combo-value-quantity",
            "encounter",
            "code-value-concept",
            "component-code-value-concept",
            "component-value-concept",
            "category",
            "device",
            "combo-value-concept",
            "value-canonical",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ObservationValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Observation:subject",
            "Observation:derived-from",
            "Observation:focus",
            "Observation:part-of",
            "Observation:has-member",
            "Observation:value-reference",
            "Observation:based-on",
            "Observation:patient",
            "Observation:specimen",
            "Observation:component-value-reference",
            "Observation:performer",
            "Observation:encounter",
            "Observation:device",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ObservationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdverseEvent:resultingeffect",
            "DiagnosticReport:result",
            "Goal:addresses",
            "Observation:derived-from",
            "Observation:has-member",
            "Procedure:part-of",
            "QuestionnaireResponse:part-of",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ObservationBooleanEnd(search_string=search_string)


class ObservationDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ObservationDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ObservationDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ObservationDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ObservationDefinitionBooleanEnd(search_string=search_string)


class ObservationDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "code",
            "method",
            "experimental",
            "category",
            "title",
            "url",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ObservationDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ObservationDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["PlanDefinition:definition", "RegulatedAuthorization:subject"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ObservationDefinitionBooleanEnd(search_string=search_string)


class OperationDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return OperationDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return OperationDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class OperationDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return OperationDefinitionBooleanEnd(search_string=search_string)


class OperationDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "code",
            "instance",
            "context-type-value",
            "kind",
            "jurisdiction",
            "description",
            "context-type",
            "title",
            "type",
            "version",
            "url",
            "context-quantity",
            "input-profile",
            "output-profile",
            "system",
            "context",
            "name",
            "publisher",
            "context-type-quantity",
            "base",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return OperationDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "OperationDefinition:input-profile",
            "OperationDefinition:output-profile",
            "OperationDefinition:base",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return OperationDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "CarePlan:instantiates-canonical",
            "Communication:instantiates-canonical",
            "FamilyMemberHistory:instantiates-canonical",
            "OperationDefinition:base",
            "Procedure:instantiates-canonical",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return OperationDefinitionBooleanEnd(search_string=search_string)


class OperationOutcomeBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return OperationOutcomeSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return OperationOutcomeSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class OperationOutcomeValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return OperationOutcomeBooleanEnd(search_string=search_string)


class OperationOutcomeSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return OperationOutcomeValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return OperationOutcomeBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return OperationOutcomeBooleanEnd(search_string=search_string)


class OrganizationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return OrganizationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return OrganizationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class OrganizationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return OrganizationBooleanEnd(search_string=search_string)


class OrganizationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "partof",
            "address",
            "address-state",
            "active",
            "type",
            "address-postalcode",
            "address-country",
            "endpoint",
            "phonetic",
            "address-use",
            "name",
            "address-city",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return OrganizationValue(search_string=search_string)

    def include(
        self,
        value: Literal["Organization:partof", "Organization:endpoint"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return OrganizationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Account:owner",
            "Account:patient",
            "Account:subject",
            "Account:guarantor",
            "AllergyIntolerance:participant",
            "AuditEvent:agent",
            "AuditEvent:source",
            "Basic:author",
            "CarePlan:custodian",
            "CareTeam:participant",
            "ChargeItem:performing-organization",
            "ChargeItem:enterer",
            "ChargeItem:performer-actor",
            "ChargeItem:requesting-organization",
            "Claim:care-team",
            "Claim:payee",
            "Claim:provider",
            "Claim:insurer",
            "Claim:facility",
            "ClaimResponse:insurer",
            "ClaimResponse:requestor",
            "Communication:sender",
            "Communication:recipient",
            "CommunicationRequest:requester",
            "CommunicationRequest:recipient",
            "CommunicationRequest:information-provider",
            "Composition:author",
            "Composition:attester",
            "Condition:participant-actor",
            "Consent:controller",
            "Consent:manager",
            "Consent:grantee",
            "Consent:actor",
            "Contract:authority",
            "Contract:signer",
            "Coverage:insurer",
            "Coverage:paymentby-party",
            "Coverage:policy-holder",
            "CoverageEligibilityRequest:provider",
            "CoverageEligibilityResponse:insurer",
            "CoverageEligibilityResponse:requestor",
            "DetectedIssue:subject",
            "DetectedIssue:patient",
            "Device:organization",
            "DeviceDefinition:organization",
            "DeviceDefinition:manufacturer",
            "DeviceRequest:requester",
            "DiagnosticReport:performer",
            "DiagnosticReport:subject",
            "DiagnosticReport:patient",
            "DiagnosticReport:results-interpreter",
            "DocumentReference:custodian",
            "DocumentReference:author",
            "DocumentReference:attester",
            "Encounter:service-provider",
            "Endpoint:organization",
            "EpisodeOfCare:organization",
            "ExplanationOfBenefit:care-team",
            "ExplanationOfBenefit:payee",
            "ExplanationOfBenefit:provider",
            "ExplanationOfBenefit:facility",
            "Flag:author",
            "Flag:patient",
            "Flag:subject",
            "Goal:patient",
            "Goal:subject",
            "Group:managing-entity",
            "Group:member",
            "HealthcareService:organization",
            "ImagingSelection:subject",
            "ImagingSelection:patient",
            "ImagingStudy:performer",
            "Immunization:performer",
            "InsurancePlan:owned-by",
            "InsurancePlan:administered-by",
            "InventoryItem:subject",
            "Invoice:issuer",
            "Invoice:participant",
            "Invoice:recipient",
            "Linkage:author",
            "List:source",
            "Location:organization",
            "MeasureReport:patient",
            "MeasureReport:subject",
            "MeasureReport:reporter",
            "Medication:marketingauthorizationholder",
            "MedicationDispense:performer",
            "MedicationDispense:responsibleparty",
            "MedicationRequest:requester",
            "MedicationRequest:intended-dispenser",
            "MedicationRequest:intended-performer",
            "MedicationStatement:source",
            "MedicinalProductDefinition:contact",
            "MessageHeader:receiver",
            "MessageHeader:sender",
            "MessageHeader:author",
            "MessageHeader:responsible",
            "NutritionIntake:source",
            "Observation:subject",
            "Observation:patient",
            "Observation:performer",
            "Organization:partof",
            "OrganizationAffiliation:primary-organization",
            "OrganizationAffiliation:network",
            "OrganizationAffiliation:participating-organization",
            "Patient:general-practitioner",
            "Patient:organization",
            "PaymentNotice:reporter",
            "PaymentReconciliation:payment-issuer",
            "PaymentReconciliation:requestor",
            "Person:organization",
            "PractitionerRole:organization",
            "Procedure:performer",
            "Procedure:subject",
            "Procedure:patient",
            "Provenance:agent",
            "QuestionnaireResponse:author",
            "QuestionnaireResponse:source",
            "RegulatedAuthorization:subject",
            "RegulatedAuthorization:holder",
            "RequestOrchestration:subject",
            "RequestOrchestration:participant",
            "RequestOrchestration:patient",
            "ResearchStudy:site",
            "ServiceRequest:requester",
            "ServiceRequest:performer",
            "Subscription:owner",
            "SupplyDelivery:receiver",
            "SupplyDelivery:supplier",
            "SupplyRequest:requester",
            "SupplyRequest:subject",
            "SupplyRequest:supplier",
            "Task:owner",
            "Task:requester",
            "Task:actor",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return OrganizationBooleanEnd(search_string=search_string)


class OrganizationAffiliationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return OrganizationAffiliationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return OrganizationAffiliationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class OrganizationAffiliationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return OrganizationAffiliationBooleanEnd(search_string=search_string)


class OrganizationAffiliationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "specialty",
            "role",
            "active",
            "primary-organization",
            "network",
            "endpoint",
            "phone",
            "service",
            "participating-organization",
            "location",
            "telecom",
            "email",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return OrganizationAffiliationValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "OrganizationAffiliation:primary-organization",
            "OrganizationAffiliation:network",
            "OrganizationAffiliation:endpoint",
            "OrganizationAffiliation:service",
            "OrganizationAffiliation:participating-organization",
            "OrganizationAffiliation:location",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return OrganizationAffiliationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return OrganizationAffiliationBooleanEnd(search_string=search_string)


class PackagedProductDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return PackagedProductDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return PackagedProductDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class PackagedProductDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return PackagedProductDefinitionBooleanEnd(search_string=search_string)


class PackagedProductDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "manufactured-item",
            "nutrition",
            "package",
            "name",
            "biological",
            "package-for",
            "contained-item",
            "medication",
            "device",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return PackagedProductDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "PackagedProductDefinition:manufactured-item",
            "PackagedProductDefinition:nutrition",
            "PackagedProductDefinition:package",
            "PackagedProductDefinition:biological",
            "PackagedProductDefinition:package-for",
            "PackagedProductDefinition:contained-item",
            "PackagedProductDefinition:medication",
            "PackagedProductDefinition:device",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return PackagedProductDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["RegulatedAuthorization:subject"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return PackagedProductDefinitionBooleanEnd(search_string=search_string)


class PatientBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return PatientSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return PatientSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class PatientValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return PatientBooleanEnd(search_string=search_string)


class PatientSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "given",
            "identifier",
            "address",
            "birthdate",
            "deceased",
            "address-state",
            "gender",
            "general-practitioner",
            "link",
            "active",
            "language",
            "address-postalcode",
            "address-country",
            "death-date",
            "phonetic",
            "phone",
            "organization",
            "address-use",
            "name",
            "telecom",
            "address-city",
            "family",
            "email",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return PatientValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Patient:general-practitioner", "Patient:link", "Patient:organization"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return PatientBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Account:patient",
            "Account:subject",
            "Account:guarantor",
            "AdverseEvent:recorder",
            "AdverseEvent:subject",
            "AdverseEvent:patient",
            "AllergyIntolerance:participant",
            "AllergyIntolerance:patient",
            "Appointment:practitioner",
            "Appointment:subject",
            "Appointment:actor",
            "Appointment:patient",
            "Appointment:location",
            "Appointment:group",
            "AppointmentResponse:actor",
            "AppointmentResponse:practitioner",
            "AppointmentResponse:patient",
            "AppointmentResponse:location",
            "AppointmentResponse:group",
            "AuditEvent:agent",
            "AuditEvent:source",
            "AuditEvent:patient",
            "Basic:author",
            "BiologicallyDerivedProductDispense:patient",
            "BodyStructure:patient",
            "CarePlan:custodian",
            "CarePlan:subject",
            "CarePlan:patient",
            "CareTeam:patient",
            "CareTeam:subject",
            "CareTeam:participant",
            "ChargeItem:subject",
            "ChargeItem:patient",
            "ChargeItem:enterer",
            "ChargeItem:performer-actor",
            "Claim:payee",
            "Claim:patient",
            "Claim:enterer",
            "ClaimResponse:patient",
            "ClinicalImpression:patient",
            "ClinicalImpression:subject",
            "Communication:subject",
            "Communication:sender",
            "Communication:patient",
            "Communication:recipient",
            "CommunicationRequest:requester",
            "CommunicationRequest:subject",
            "CommunicationRequest:patient",
            "CommunicationRequest:recipient",
            "CommunicationRequest:information-provider",
            "Composition:author",
            "Composition:attester",
            "Condition:subject",
            "Condition:participant-actor",
            "Condition:patient",
            "Consent:controller",
            "Consent:manager",
            "Consent:subject",
            "Consent:grantee",
            "Consent:actor",
            "Consent:patient",
            "Contract:signer",
            "Coverage:subscriber",
            "Coverage:beneficiary",
            "Coverage:patient",
            "Coverage:paymentby-party",
            "Coverage:policy-holder",
            "CoverageEligibilityRequest:patient",
            "CoverageEligibilityResponse:patient",
            "DetectedIssue:author",
            "DetectedIssue:subject",
            "DetectedIssue:patient",
            "DeviceAssociation:subject",
            "DeviceAssociation:patient",
            "DeviceAssociation:operator",
            "DeviceDispense:subject",
            "DeviceDispense:patient",
            "DeviceRequest:subject",
            "DeviceRequest:patient",
            "DeviceUsage:patient",
            "DiagnosticReport:subject",
            "DiagnosticReport:patient",
            "DocumentReference:author",
            "DocumentReference:attester",
            "Encounter:subject",
            "Encounter:participant",
            "Encounter:patient",
            "Encounter:practitioner",
            "EncounterHistory:patient",
            "EncounterHistory:subject",
            "EnrollmentRequest:patient",
            "EnrollmentRequest:subject",
            "EpisodeOfCare:patient",
            "ExplanationOfBenefit:payee",
            "ExplanationOfBenefit:patient",
            "ExplanationOfBenefit:enterer",
            "FamilyMemberHistory:patient",
            "Flag:author",
            "Flag:patient",
            "Flag:subject",
            "GenomicStudy:patient",
            "GenomicStudy:subject",
            "Goal:patient",
            "Goal:subject",
            "Group:member",
            "GuidanceResponse:patient",
            "GuidanceResponse:subject",
            "ImagingSelection:subject",
            "ImagingSelection:patient",
            "ImagingStudy:performer",
            "ImagingStudy:subject",
            "ImagingStudy:patient",
            "Immunization:performer",
            "Immunization:patient",
            "ImmunizationEvaluation:patient",
            "ImmunizationRecommendation:patient",
            "InventoryItem:subject",
            "Invoice:subject",
            "Invoice:participant",
            "Invoice:patient",
            "Invoice:recipient",
            "List:source",
            "MeasureReport:patient",
            "MeasureReport:subject",
            "MedicationAdministration:subject",
            "MedicationAdministration:patient",
            "MedicationDispense:performer",
            "MedicationDispense:receiver",
            "MedicationDispense:subject",
            "MedicationDispense:patient",
            "MedicationRequest:requester",
            "MedicationRequest:subject",
            "MedicationRequest:intended-performer",
            "MedicationRequest:patient",
            "MedicationStatement:patient",
            "MedicationStatement:subject",
            "MedicationStatement:source",
            "MolecularSequence:subject",
            "MolecularSequence:patient",
            "NutritionIntake:patient",
            "NutritionIntake:subject",
            "NutritionIntake:source",
            "NutritionOrder:subject",
            "NutritionOrder:patient",
            "Observation:subject",
            "Observation:patient",
            "Observation:performer",
            "Patient:link",
            "PaymentReconciliation:payment-issuer",
            "Person:practitioner",
            "Person:link",
            "Person:relatedperson",
            "Person:patient",
            "Procedure:performer",
            "Procedure:subject",
            "Procedure:patient",
            "Provenance:agent",
            "Provenance:patient",
            "QuestionnaireResponse:author",
            "QuestionnaireResponse:source",
            "RelatedPerson:patient",
            "RequestOrchestration:subject",
            "RequestOrchestration:participant",
            "RequestOrchestration:patient",
            "ResearchSubject:subject",
            "ResearchSubject:patient",
            "RiskAssessment:performer",
            "RiskAssessment:patient",
            "RiskAssessment:subject",
            "Schedule:actor",
            "ServiceRequest:requester",
            "ServiceRequest:performer",
            "ServiceRequest:subject",
            "ServiceRequest:patient",
            "Specimen:patient",
            "Specimen:subject",
            "Specimen:collector",
            "Subscription:owner",
            "SupplyDelivery:patient",
            "SupplyRequest:requester",
            "SupplyRequest:patient",
            "SupplyRequest:subject",
            "Task:owner",
            "Task:requester",
            "Task:actor",
            "VisionPrescription:patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return PatientBooleanEnd(search_string=search_string)


class PaymentNoticeBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return PaymentNoticeSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return PaymentNoticeSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class PaymentNoticeValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return PaymentNoticeBooleanEnd(search_string=search_string)


class PaymentNoticeSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "request",
            "created",
            "response",
            "reporter",
            "payment-status",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return PaymentNoticeValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "PaymentNotice:request", "PaymentNotice:response", "PaymentNotice:reporter"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return PaymentNoticeBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return PaymentNoticeBooleanEnd(search_string=search_string)


class PaymentReconciliationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return PaymentReconciliationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return PaymentReconciliationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class PaymentReconciliationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return PaymentReconciliationBooleanEnd(search_string=search_string)


class PaymentReconciliationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "request",
            "disposition",
            "created",
            "allocation-encounter",
            "allocation-account",
            "outcome",
            "payment-issuer",
            "requestor",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return PaymentReconciliationValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "PaymentReconciliation:request",
            "PaymentReconciliation:allocation-encounter",
            "PaymentReconciliation:allocation-account",
            "PaymentReconciliation:payment-issuer",
            "PaymentReconciliation:requestor",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return PaymentReconciliationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return PaymentReconciliationBooleanEnd(search_string=search_string)


class PermissionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return PermissionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return PermissionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class PermissionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return PermissionBooleanEnd(search_string=search_string)


class PermissionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return PermissionValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return PermissionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return PermissionBooleanEnd(search_string=search_string)


class PersonBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return PersonSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return PersonSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class PersonValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return PersonBooleanEnd(search_string=search_string)


class PersonSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "given",
            "address",
            "birthdate",
            "deceased",
            "address-state",
            "gender",
            "practitioner",
            "link",
            "relatedperson",
            "address-postalcode",
            "address-country",
            "death-date",
            "phonetic",
            "phone",
            "patient",
            "organization",
            "address-use",
            "name",
            "telecom",
            "address-city",
            "family",
            "email",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return PersonValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Person:practitioner",
            "Person:link",
            "Person:relatedperson",
            "Person:patient",
            "Person:organization",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return PersonBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Person:practitioner",
            "Person:link",
            "Person:relatedperson",
            "Person:patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return PersonBooleanEnd(search_string=search_string)


class PlanDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return PlanDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return PlanDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class PlanDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return PlanDefinitionBooleanEnd(search_string=search_string)


class PlanDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "successor",
            "context-type-value",
            "jurisdiction",
            "derived-from",
            "description",
            "context-type",
            "predecessor",
            "composed-of",
            "title",
            "type",
            "version",
            "url",
            "context-quantity",
            "depends-on",
            "effective",
            "context",
            "name",
            "publisher",
            "topic",
            "definition",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return PlanDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "PlanDefinition:successor",
            "PlanDefinition:derived-from",
            "PlanDefinition:predecessor",
            "PlanDefinition:composed-of",
            "PlanDefinition:depends-on",
            "PlanDefinition:definition",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return PlanDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "CarePlan:instantiates-canonical",
            "ClinicalUseDefinition:product",
            "ClinicalUseDefinition:subject",
            "Communication:instantiates-canonical",
            "DeviceRequest:instantiates-canonical",
            "FamilyMemberHistory:instantiates-canonical",
            "Flag:patient",
            "Flag:subject",
            "MessageDefinition:parent",
            "PlanDefinition:definition",
            "Procedure:instantiates-canonical",
            "RegulatedAuthorization:subject",
            "ResearchStudy:protocol",
            "ServiceRequest:instantiates-canonical",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return PlanDefinitionBooleanEnd(search_string=search_string)


class PractitionerBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return PractitionerSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return PractitionerSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class PractitionerValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return PractitionerBooleanEnd(search_string=search_string)


class PractitionerSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "given",
            "identifier",
            "address",
            "deceased",
            "address-state",
            "gender",
            "qualification-period",
            "active",
            "address-postalcode",
            "address-country",
            "death-date",
            "phonetic",
            "phone",
            "address-use",
            "name",
            "telecom",
            "address-city",
            "communication",
            "family",
            "email",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return PractitionerValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return PractitionerBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Account:patient",
            "Account:subject",
            "AdverseEvent:recorder",
            "AdverseEvent:subject",
            "AdverseEvent:patient",
            "AllergyIntolerance:participant",
            "Appointment:practitioner",
            "Appointment:actor",
            "Appointment:patient",
            "Appointment:location",
            "Appointment:group",
            "AppointmentResponse:actor",
            "AppointmentResponse:practitioner",
            "AppointmentResponse:patient",
            "AppointmentResponse:location",
            "AppointmentResponse:group",
            "AuditEvent:agent",
            "AuditEvent:source",
            "Basic:author",
            "BiologicallyDerivedProduct:collector",
            "BiologicallyDerivedProductDispense:performer",
            "CarePlan:custodian",
            "CareTeam:participant",
            "ChargeItem:enterer",
            "ChargeItem:performer-actor",
            "Claim:care-team",
            "Claim:payee",
            "Claim:provider",
            "Claim:enterer",
            "ClaimResponse:requestor",
            "ClinicalImpression:performer",
            "Communication:sender",
            "Communication:recipient",
            "CommunicationRequest:requester",
            "CommunicationRequest:recipient",
            "CommunicationRequest:information-provider",
            "Composition:author",
            "Composition:attester",
            "Condition:participant-actor",
            "Consent:controller",
            "Consent:manager",
            "Consent:subject",
            "Consent:grantee",
            "Consent:actor",
            "Consent:patient",
            "Contract:signer",
            "CoverageEligibilityRequest:provider",
            "CoverageEligibilityRequest:enterer",
            "CoverageEligibilityResponse:requestor",
            "DetectedIssue:author",
            "DetectedIssue:subject",
            "DetectedIssue:patient",
            "DeviceAssociation:subject",
            "DeviceAssociation:patient",
            "DeviceAssociation:operator",
            "DeviceDispense:subject",
            "DeviceDispense:patient",
            "DeviceRequest:requester",
            "DiagnosticReport:performer",
            "DiagnosticReport:subject",
            "DiagnosticReport:patient",
            "DiagnosticReport:results-interpreter",
            "DocumentReference:author",
            "DocumentReference:attester",
            "Encounter:participant",
            "Encounter:practitioner",
            "EpisodeOfCare:care-manager",
            "ExplanationOfBenefit:care-team",
            "ExplanationOfBenefit:payee",
            "ExplanationOfBenefit:provider",
            "ExplanationOfBenefit:enterer",
            "Flag:author",
            "Flag:patient",
            "Flag:subject",
            "Group:managing-entity",
            "Group:member",
            "ImagingSelection:subject",
            "ImagingSelection:patient",
            "ImagingStudy:performer",
            "ImagingStudy:referrer",
            "Immunization:performer",
            "Invoice:participant",
            "Linkage:author",
            "List:source",
            "MeasureReport:patient",
            "MeasureReport:subject",
            "MeasureReport:reporter",
            "MedicationDispense:performer",
            "MedicationDispense:receiver",
            "MedicationDispense:responsibleparty",
            "MedicationRequest:requester",
            "MedicationRequest:intended-performer",
            "MedicationStatement:source",
            "MessageHeader:receiver",
            "MessageHeader:sender",
            "MessageHeader:author",
            "MessageHeader:responsible",
            "NutritionIntake:source",
            "NutritionOrder:provider",
            "Observation:subject",
            "Observation:patient",
            "Observation:performer",
            "Patient:general-practitioner",
            "PaymentNotice:reporter",
            "PaymentReconciliation:requestor",
            "Person:practitioner",
            "Person:link",
            "Person:relatedperson",
            "Person:patient",
            "PractitionerRole:practitioner",
            "Procedure:performer",
            "Procedure:subject",
            "Procedure:patient",
            "Provenance:agent",
            "QuestionnaireResponse:author",
            "QuestionnaireResponse:source",
            "RegulatedAuthorization:subject",
            "RequestOrchestration:author",
            "RequestOrchestration:subject",
            "RequestOrchestration:participant",
            "RequestOrchestration:patient",
            "RiskAssessment:performer",
            "Schedule:actor",
            "ServiceRequest:requester",
            "ServiceRequest:performer",
            "Specimen:collector",
            "Subscription:owner",
            "SupplyDelivery:receiver",
            "SupplyDelivery:supplier",
            "SupplyRequest:requester",
            "Task:owner",
            "Task:requester",
            "Task:actor",
            "VisionPrescription:prescriber",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return PractitionerBooleanEnd(search_string=search_string)


class PractitionerRoleBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return PractitionerRoleSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return PractitionerRoleSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class PractitionerRoleValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return PractitionerRoleBooleanEnd(search_string=search_string)


class PractitionerRoleSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "specialty",
            "role",
            "practitioner",
            "active",
            "characteristic",
            "endpoint",
            "phone",
            "service",
            "organization",
            "location",
            "telecom",
            "communication",
            "email",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return PractitionerRoleValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "PractitionerRole:practitioner",
            "PractitionerRole:endpoint",
            "PractitionerRole:service",
            "PractitionerRole:organization",
            "PractitionerRole:location",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return PractitionerRoleBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Account:patient",
            "Account:subject",
            "AdverseEvent:recorder",
            "AllergyIntolerance:participant",
            "Appointment:practitioner",
            "Appointment:actor",
            "Appointment:patient",
            "Appointment:location",
            "Appointment:group",
            "AppointmentResponse:actor",
            "AppointmentResponse:practitioner",
            "AppointmentResponse:patient",
            "AppointmentResponse:location",
            "AppointmentResponse:group",
            "AuditEvent:agent",
            "AuditEvent:source",
            "Basic:author",
            "BiologicallyDerivedProduct:collector",
            "CarePlan:custodian",
            "CareTeam:participant",
            "ChargeItem:enterer",
            "ChargeItem:performer-actor",
            "Claim:care-team",
            "Claim:payee",
            "Claim:provider",
            "Claim:enterer",
            "ClaimResponse:requestor",
            "ClinicalImpression:performer",
            "Communication:sender",
            "Communication:recipient",
            "CommunicationRequest:requester",
            "CommunicationRequest:recipient",
            "CommunicationRequest:information-provider",
            "Composition:author",
            "Composition:attester",
            "Condition:participant-actor",
            "Consent:grantee",
            "Consent:actor",
            "Contract:signer",
            "CoverageEligibilityRequest:provider",
            "CoverageEligibilityRequest:enterer",
            "CoverageEligibilityResponse:requestor",
            "DetectedIssue:author",
            "DeviceRequest:requester",
            "DiagnosticReport:performer",
            "DiagnosticReport:results-interpreter",
            "DocumentReference:author",
            "DocumentReference:attester",
            "Encounter:participant",
            "Encounter:practitioner",
            "EpisodeOfCare:care-manager",
            "ExplanationOfBenefit:care-team",
            "ExplanationOfBenefit:payee",
            "ExplanationOfBenefit:provider",
            "ExplanationOfBenefit:enterer",
            "Flag:author",
            "Flag:patient",
            "Flag:subject",
            "Group:managing-entity",
            "Group:member",
            "ImagingStudy:performer",
            "ImagingStudy:referrer",
            "Immunization:performer",
            "Invoice:participant",
            "Linkage:author",
            "List:source",
            "MeasureReport:patient",
            "MeasureReport:subject",
            "MeasureReport:reporter",
            "MedicationDispense:performer",
            "MedicationDispense:receiver",
            "MedicationDispense:responsibleparty",
            "MedicationRequest:requester",
            "MedicationRequest:intended-performer",
            "MedicationStatement:source",
            "MedicinalProductDefinition:contact",
            "MessageHeader:receiver",
            "MessageHeader:sender",
            "MessageHeader:author",
            "MessageHeader:responsible",
            "NutritionIntake:source",
            "NutritionOrder:provider",
            "Observation:performer",
            "Patient:general-practitioner",
            "PaymentNotice:reporter",
            "PaymentReconciliation:requestor",
            "Procedure:performer",
            "Provenance:agent",
            "QuestionnaireResponse:author",
            "QuestionnaireResponse:source",
            "RequestOrchestration:author",
            "RequestOrchestration:subject",
            "RequestOrchestration:participant",
            "RequestOrchestration:patient",
            "RiskAssessment:performer",
            "Schedule:actor",
            "ServiceRequest:requester",
            "ServiceRequest:performer",
            "Specimen:collector",
            "Subscription:owner",
            "SupplyDelivery:receiver",
            "SupplyDelivery:supplier",
            "SupplyRequest:requester",
            "Task:owner",
            "Task:requester",
            "Task:actor",
            "VisionPrescription:prescriber",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return PractitionerRoleBooleanEnd(search_string=search_string)


class ProcedureBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ProcedureSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ProcedureSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ProcedureValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ProcedureBooleanEnd(search_string=search_string)


class ProcedureSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "code",
            "performer",
            "subject",
            "instantiates-canonical",
            "part-of",
            "encounter",
            "reason-code",
            "based-on",
            "patient",
            "reason-reference",
            "report",
            "instantiates-uri",
            "location",
            "category",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ProcedureValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Procedure:performer",
            "Procedure:subject",
            "Procedure:instantiates-canonical",
            "Procedure:part-of",
            "Procedure:encounter",
            "Procedure:based-on",
            "Procedure:patient",
            "Procedure:reason-reference",
            "Procedure:report",
            "Procedure:location",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ProcedureBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdverseEvent:substance",
            "DetectedIssue:subject",
            "DetectedIssue:patient",
            "Flag:patient",
            "Flag:subject",
            "Goal:addresses",
            "ImagingSelection:subject",
            "ImagingSelection:patient",
            "Observation:subject",
            "Observation:part-of",
            "Observation:patient",
            "Procedure:part-of",
            "QuestionnaireResponse:part-of",
            "Specimen:procedure",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ProcedureBooleanEnd(search_string=search_string)


class ProvenanceBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ProvenanceSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ProvenanceSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ProvenanceValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ProvenanceBooleanEnd(search_string=search_string)


class ProvenanceSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "agent-type",
            "agent",
            "signature-type",
            "activity",
            "encounter",
            "recorded",
            "when",
            "target",
            "based-on",
            "patient",
            "location",
            "agent-role",
            "entity",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ProvenanceValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Provenance:agent",
            "Provenance:encounter",
            "Provenance:target",
            "Provenance:based-on",
            "Provenance:patient",
            "Provenance:location",
            "Provenance:entity",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ProvenanceBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ProvenanceBooleanEnd(search_string=search_string)


class QuestionnaireBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return QuestionnaireSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return QuestionnaireSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class QuestionnaireValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return QuestionnaireBooleanEnd(search_string=search_string)


class QuestionnaireSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "combo-code",
            "context-type-value",
            "jurisdiction",
            "description",
            "context-type",
            "title",
            "version",
            "url",
            "context-quantity",
            "effective",
            "subject-type",
            "context",
            "name",
            "publisher",
            "questionnaire-code",
            "definition",
            "context-type-quantity",
            "item-code",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return QuestionnaireValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return QuestionnaireBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "CarePlan:instantiates-canonical",
            "Communication:instantiates-canonical",
            "FamilyMemberHistory:instantiates-canonical",
            "PlanDefinition:definition",
            "Procedure:instantiates-canonical",
            "QuestionnaireResponse:questionnaire",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return QuestionnaireBooleanEnd(search_string=search_string)


class QuestionnaireResponseBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return QuestionnaireResponseSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return QuestionnaireResponseSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class QuestionnaireResponseValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return QuestionnaireResponseBooleanEnd(search_string=search_string)


class QuestionnaireResponseSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "authored",
            "identifier",
            "questionnaire",
            "based-on",
            "author",
            "patient",
            "subject",
            "part-of",
            "encounter",
            "source",
            "item-subject",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return QuestionnaireResponseValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "QuestionnaireResponse:questionnaire",
            "QuestionnaireResponse:based-on",
            "QuestionnaireResponse:author",
            "QuestionnaireResponse:patient",
            "QuestionnaireResponse:subject",
            "QuestionnaireResponse:part-of",
            "QuestionnaireResponse:encounter",
            "QuestionnaireResponse:source",
            "QuestionnaireResponse:item-subject",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return QuestionnaireResponseBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Consent:source-reference",
            "Observation:derived-from",
            "Observation:has-member",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return QuestionnaireResponseBooleanEnd(search_string=search_string)


class RegulatedAuthorizationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return RegulatedAuthorizationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return RegulatedAuthorizationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class RegulatedAuthorizationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return RegulatedAuthorizationBooleanEnd(search_string=search_string)


class RegulatedAuthorizationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "subject",
            "case-type",
            "holder",
            "region",
            "case",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return RegulatedAuthorizationValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "RegulatedAuthorization:subject", "RegulatedAuthorization:holder"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return RegulatedAuthorizationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return RegulatedAuthorizationBooleanEnd(search_string=search_string)


class RelatedPersonBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return RelatedPersonSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return RelatedPersonSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class RelatedPersonValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return RelatedPersonBooleanEnd(search_string=search_string)


class RelatedPersonSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "given",
            "address",
            "birthdate",
            "address-state",
            "gender",
            "active",
            "address-postalcode",
            "address-country",
            "phonetic",
            "phone",
            "patient",
            "address-use",
            "name",
            "telecom",
            "address-city",
            "family",
            "relationship",
            "email",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return RelatedPersonValue(search_string=search_string)

    def include(
        self,
        value: Literal["RelatedPerson:patient"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return RelatedPersonBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Account:guarantor",
            "AdverseEvent:recorder",
            "AdverseEvent:subject",
            "AdverseEvent:patient",
            "AllergyIntolerance:participant",
            "Appointment:practitioner",
            "Appointment:actor",
            "Appointment:patient",
            "Appointment:location",
            "Appointment:group",
            "AppointmentResponse:actor",
            "AppointmentResponse:practitioner",
            "AppointmentResponse:patient",
            "AppointmentResponse:location",
            "AppointmentResponse:group",
            "AuditEvent:agent",
            "AuditEvent:source",
            "Basic:author",
            "CarePlan:custodian",
            "CareTeam:participant",
            "ChargeItem:enterer",
            "ChargeItem:performer-actor",
            "Claim:payee",
            "Claim:enterer",
            "Communication:sender",
            "Communication:recipient",
            "CommunicationRequest:requester",
            "CommunicationRequest:recipient",
            "CommunicationRequest:information-provider",
            "Composition:author",
            "Composition:attester",
            "Condition:participant-actor",
            "Consent:grantee",
            "Consent:actor",
            "Contract:signer",
            "Coverage:subscriber",
            "Coverage:paymentby-party",
            "Coverage:policy-holder",
            "DetectedIssue:author",
            "DeviceAssociation:subject",
            "DeviceAssociation:patient",
            "DeviceAssociation:operator",
            "DocumentReference:author",
            "DocumentReference:attester",
            "Encounter:participant",
            "Encounter:practitioner",
            "ExplanationOfBenefit:payee",
            "ExplanationOfBenefit:enterer",
            "Flag:author",
            "Flag:patient",
            "Flag:subject",
            "Group:managing-entity",
            "Group:member",
            "ImagingStudy:performer",
            "Immunization:performer",
            "Invoice:participant",
            "Invoice:recipient",
            "List:source",
            "MeasureReport:patient",
            "MeasureReport:subject",
            "MedicationDispense:performer",
            "MedicationDispense:receiver",
            "MedicationRequest:requester",
            "MedicationRequest:intended-performer",
            "MedicationStatement:source",
            "NutritionIntake:source",
            "Observation:performer",
            "Patient:link",
            "PaymentReconciliation:payment-issuer",
            "Person:practitioner",
            "Person:link",
            "Person:relatedperson",
            "Person:patient",
            "Procedure:performer",
            "Provenance:agent",
            "QuestionnaireResponse:author",
            "QuestionnaireResponse:source",
            "RequestOrchestration:subject",
            "RequestOrchestration:participant",
            "RequestOrchestration:patient",
            "RiskAssessment:performer",
            "Schedule:actor",
            "ServiceRequest:requester",
            "ServiceRequest:performer",
            "Specimen:collector",
            "Subscription:owner",
            "SupplyRequest:requester",
            "SupplyRequest:subject",
            "Task:owner",
            "Task:requester",
            "Task:actor",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return RelatedPersonBooleanEnd(search_string=search_string)


class RequestOrchestrationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return RequestOrchestrationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return RequestOrchestrationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class RequestOrchestrationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return RequestOrchestrationBooleanEnd(search_string=search_string)


class RequestOrchestrationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "authored",
            "identifier",
            "code",
            "author",
            "subject",
            "instantiates-canonical",
            "encounter",
            "priority",
            "intent",
            "participant",
            "group-identifier",
            "based-on",
            "patient",
            "instantiates-uri",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return RequestOrchestrationValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "RequestOrchestration:author",
            "RequestOrchestration:subject",
            "RequestOrchestration:instantiates-canonical",
            "RequestOrchestration:encounter",
            "RequestOrchestration:participant",
            "RequestOrchestration:based-on",
            "RequestOrchestration:patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return RequestOrchestrationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "CarePlan:activity-reference",
            "CarePlan:based-on",
            "DocumentReference:based-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return RequestOrchestrationBooleanEnd(search_string=search_string)


class RequirementsBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return RequirementsSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return RequirementsSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class RequirementsValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return RequirementsBooleanEnd(search_string=search_string)


class RequirementsSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "context-type-value",
            "jurisdiction",
            "description",
            "derived-from",
            "context-type",
            "title",
            "version",
            "url",
            "actor",
            "context-quantity",
            "context",
            "name",
            "publisher",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return RequirementsValue(search_string=search_string)

    def include(
        self,
        value: Literal["Requirements:derived-from", "Requirements:actor"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return RequirementsBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["Requirements:derived-from"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return RequirementsBooleanEnd(search_string=search_string)


class ResearchStudyBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ResearchStudySearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ResearchStudySearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ResearchStudyValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ResearchStudyBooleanEnd(search_string=search_string)


class ResearchStudySearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "objective-type",
            "study-design",
            "description",
            "eligibility",
            "part-of",
            "title",
            "progress-status-state-period-actual",
            "recruitment-target",
            "protocol",
            "classifier",
            "keyword",
            "focus-code",
            "phase",
            "identifier",
            "progress-status-state-actual",
            "focus-reference",
            "objective-description",
            "progress-status-state-period",
            "condition",
            "site",
            "name",
            "recruitment-actual",
            "region",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ResearchStudyValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ResearchStudy:eligibility",
            "ResearchStudy:part-of",
            "ResearchStudy:protocol",
            "ResearchStudy:focus-reference",
            "ResearchStudy:site",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ResearchStudyBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdverseEvent:study",
            "AdverseEvent:substance",
            "RegulatedAuthorization:subject",
            "ResearchStudy:part-of",
            "ResearchStudy:site",
            "ResearchSubject:study",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ResearchStudyBooleanEnd(search_string=search_string)


class ResearchSubjectBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ResearchSubjectSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ResearchSubjectSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ResearchSubjectValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ResearchSubjectBooleanEnd(search_string=search_string)


class ResearchSubjectSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "subject_state",
            "study",
            "subject",
            "patient",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ResearchSubjectValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ResearchSubject:study",
            "ResearchSubject:subject",
            "ResearchSubject:patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ResearchSubjectBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdverseEvent:recorder", "AdverseEvent:subject", "AdverseEvent:patient"
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ResearchSubjectBooleanEnd(search_string=search_string)


class RiskAssessmentBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return RiskAssessmentSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return RiskAssessmentSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class RiskAssessmentValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return RiskAssessmentBooleanEnd(search_string=search_string)


class RiskAssessmentSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "condition",
            "performer",
            "method",
            "patient",
            "probability",
            "subject",
            "risk",
            "encounter",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return RiskAssessmentValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "RiskAssessment:condition",
            "RiskAssessment:performer",
            "RiskAssessment:patient",
            "RiskAssessment:subject",
            "RiskAssessment:encounter",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return RiskAssessmentBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["Goal:addresses"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return RiskAssessmentBooleanEnd(search_string=search_string)


class ScheduleBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ScheduleSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ScheduleSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ScheduleValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ScheduleBooleanEnd(search_string=search_string)


class ScheduleSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "actor",
            "date",
            "identifier",
            "specialty",
            "service-category",
            "service-type",
            "name",
            "active",
            "service-type-reference",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ScheduleValue(search_string=search_string)

    def include(
        self,
        value: Literal["Schedule:actor", "Schedule:service-type-reference"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ScheduleBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["Slot:schedule"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ScheduleBooleanEnd(search_string=search_string)


class SearchParameterBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SearchParameterSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SearchParameterSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SearchParameterValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SearchParameterBooleanEnd(search_string=search_string)


class SearchParameterSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "code",
            "context-type-value",
            "jurisdiction",
            "derived-from",
            "description",
            "context-type",
            "type",
            "version",
            "url",
            "target",
            "context-quantity",
            "component",
            "context",
            "name",
            "publisher",
            "context-type-quantity",
            "base",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SearchParameterValue(search_string=search_string)

    def include(
        self,
        value: Literal["SearchParameter:derived-from", "SearchParameter:component"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SearchParameterBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["SearchParameter:derived-from", "SearchParameter:component"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SearchParameterBooleanEnd(search_string=search_string)


class ServiceRequestBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ServiceRequestSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ServiceRequestSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ServiceRequestValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ServiceRequestBooleanEnd(search_string=search_string)


class ServiceRequestSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "authored",
            "requester",
            "identifier",
            "performer",
            "requisition",
            "replaces",
            "subject",
            "instantiates-canonical",
            "encounter",
            "occurrence",
            "priority",
            "intent",
            "performer-type",
            "body-structure",
            "based-on",
            "code-reference",
            "patient",
            "specimen",
            "code-concept",
            "instantiates-uri",
            "body-site",
            "category",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ServiceRequestValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "ServiceRequest:requester",
            "ServiceRequest:performer",
            "ServiceRequest:replaces",
            "ServiceRequest:subject",
            "ServiceRequest:instantiates-canonical",
            "ServiceRequest:encounter",
            "ServiceRequest:body-structure",
            "ServiceRequest:based-on",
            "ServiceRequest:code-reference",
            "ServiceRequest:patient",
            "ServiceRequest:specimen",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ServiceRequestBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "Appointment:based-on",
            "AuditEvent:based-on",
            "BiologicallyDerivedProduct:request",
            "CarePlan:activity-reference",
            "CarePlan:based-on",
            "DiagnosticReport:based-on",
            "DocumentReference:based-on",
            "Encounter:based-on",
            "EpisodeOfCare:incoming-referral",
            "Goal:addresses",
            "ImagingSelection:based-on",
            "ImagingStudy:based-on",
            "Observation:based-on",
            "Procedure:based-on",
            "Provenance:based-on",
            "QuestionnaireResponse:based-on",
            "ServiceRequest:replaces",
            "ServiceRequest:based-on",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ServiceRequestBooleanEnd(search_string=search_string)


class SlotBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SlotSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SlotSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SlotValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SlotBooleanEnd(search_string=search_string)


class SlotSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "schedule",
            "specialty",
            "service-category",
            "appointment-type",
            "service-type",
            "start",
            "service-type-reference",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SlotValue(search_string=search_string)

    def include(
        self,
        value: Literal["Slot:schedule", "Slot:service-type-reference"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SlotBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["Appointment:slot"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SlotBooleanEnd(search_string=search_string)


class SpecimenBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SpecimenSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SpecimenSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SpecimenValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SpecimenBooleanEnd(search_string=search_string)


class SpecimenSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "parent",
            "bodysite",
            "patient",
            "subject",
            "collected",
            "accession",
            "procedure",
            "type",
            "collector",
            "container-device",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SpecimenValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Specimen:parent",
            "Specimen:bodysite",
            "Specimen:patient",
            "Specimen:subject",
            "Specimen:procedure",
            "Specimen:collector",
            "Specimen:container-device",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SpecimenBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "DiagnosticReport:specimen",
            "Group:member",
            "ImagingSelection:subject",
            "ImagingSelection:patient",
            "Observation:specimen",
            "ResearchSubject:subject",
            "ResearchSubject:patient",
            "ServiceRequest:specimen",
            "Specimen:parent",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SpecimenBooleanEnd(search_string=search_string)


class SpecimenDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SpecimenDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SpecimenDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SpecimenDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SpecimenDefinitionBooleanEnd(search_string=search_string)


class SpecimenDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "container",
            "identifier",
            "is-derived",
            "experimental",
            "type-tested",
            "title",
            "type",
            "url",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SpecimenDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SpecimenDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["PlanDefinition:definition"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SpecimenDefinitionBooleanEnd(search_string=search_string)


class StructureDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return StructureDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return StructureDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class StructureDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return StructureDefinitionBooleanEnd(search_string=search_string)


class StructureDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "context-type-value",
            "ext-context-type",
            "jurisdiction",
            "description",
            "context-type",
            "experimental",
            "title",
            "type",
            "context-quantity",
            "path",
            "base-path",
            "context",
            "keyword",
            "context-type-quantity",
            "ext-context-expression",
            "identifier",
            "valueset",
            "kind",
            "abstract",
            "version",
            "url",
            "ext-context",
            "name",
            "publisher",
            "derivation",
            "base",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return StructureDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal["StructureDefinition:valueset", "StructureDefinition:base"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return StructureDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "CapabilityStatement:resource-profile",
            "CapabilityStatement:supported-profile",
            "ImplementationGuide:global",
            "OperationDefinition:input-profile",
            "OperationDefinition:output-profile",
            "StructureDefinition:base",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return StructureDefinitionBooleanEnd(search_string=search_string)


class StructureMapBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return StructureMapSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return StructureMapSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class StructureMapValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return StructureMapBooleanEnd(search_string=search_string)


class StructureMapSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "context-type-value",
            "jurisdiction",
            "description",
            "context-type",
            "title",
            "version",
            "url",
            "context-quantity",
            "context",
            "name",
            "publisher",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return StructureMapValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return StructureMapBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return StructureMapBooleanEnd(search_string=search_string)


class SubscriptionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SubscriptionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SubscriptionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SubscriptionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SubscriptionBooleanEnd(search_string=search_string)


class SubscriptionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "owner",
            "identifier",
            "payload",
            "contact",
            "name",
            "topic",
            "filter-value",
            "type",
            "content-level",
            "url",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SubscriptionValue(search_string=search_string)

    def include(
        self,
        value: Literal["Subscription:owner"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SubscriptionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SubscriptionBooleanEnd(search_string=search_string)


class SubscriptionStatusBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SubscriptionStatusSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SubscriptionStatusSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SubscriptionStatusValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SubscriptionStatusBooleanEnd(search_string=search_string)


class SubscriptionStatusSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SubscriptionStatusValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SubscriptionStatusBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SubscriptionStatusBooleanEnd(search_string=search_string)


class SubscriptionTopicBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SubscriptionTopicSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SubscriptionTopicSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SubscriptionTopicValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SubscriptionTopicBooleanEnd(search_string=search_string)


class SubscriptionTopicSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "effective",
            "identifier",
            "resource",
            "derived-or-self",
            "event",
            "title",
            "version",
            "url",
            "status",
            "trigger-description",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SubscriptionTopicValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SubscriptionTopicBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SubscriptionTopicBooleanEnd(search_string=search_string)


class SubstanceBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SubstanceSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SubstanceSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SubstanceValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SubstanceBooleanEnd(search_string=search_string)


class SubstanceSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "code",
            "code-reference",
            "quantity",
            "substance-reference",
            "expiry",
            "category",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SubstanceValue(search_string=search_string)

    def include(
        self,
        value: Literal["Substance:code-reference", "Substance:substance-reference"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SubstanceBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AdverseEvent:substance",
            "ClinicalUseDefinition:product",
            "ClinicalUseDefinition:subject",
            "DetectedIssue:subject",
            "DetectedIssue:patient",
            "DiagnosticReport:subject",
            "DiagnosticReport:patient",
            "GenomicStudy:patient",
            "GenomicStudy:subject",
            "ImagingSelection:subject",
            "ImagingSelection:patient",
            "MolecularSequence:subject",
            "MolecularSequence:patient",
            "Observation:subject",
            "Observation:patient",
            "ResearchSubject:subject",
            "ResearchSubject:patient",
            "Specimen:patient",
            "Specimen:subject",
            "Substance:substance-reference",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SubstanceBooleanEnd(search_string=search_string)


class SubstanceDefinitionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SubstanceDefinitionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SubstanceDefinitionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SubstanceDefinitionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SubstanceDefinitionBooleanEnd(search_string=search_string)


class SubstanceDefinitionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "code",
            "domain",
            "name",
            "classification",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SubstanceDefinitionValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SubstanceDefinitionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["RegulatedAuthorization:subject"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SubstanceDefinitionBooleanEnd(search_string=search_string)


class SubstanceNucleicAcidBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SubstanceNucleicAcidSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SubstanceNucleicAcidSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SubstanceNucleicAcidValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SubstanceNucleicAcidBooleanEnd(search_string=search_string)


class SubstanceNucleicAcidSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SubstanceNucleicAcidValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SubstanceNucleicAcidBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SubstanceNucleicAcidBooleanEnd(search_string=search_string)


class SubstancePolymerBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SubstancePolymerSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SubstancePolymerSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SubstancePolymerValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SubstancePolymerBooleanEnd(search_string=search_string)


class SubstancePolymerSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SubstancePolymerValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SubstancePolymerBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SubstancePolymerBooleanEnd(search_string=search_string)


class SubstanceProteinBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SubstanceProteinSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SubstanceProteinSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SubstanceProteinValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SubstanceProteinBooleanEnd(search_string=search_string)


class SubstanceProteinSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SubstanceProteinValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SubstanceProteinBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SubstanceProteinBooleanEnd(search_string=search_string)


class SubstanceReferenceInformationBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SubstanceReferenceInformationSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SubstanceReferenceInformationSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SubstanceReferenceInformationValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SubstanceReferenceInformationBooleanEnd(search_string=search_string)


class SubstanceReferenceInformationSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SubstanceReferenceInformationValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SubstanceReferenceInformationBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SubstanceReferenceInformationBooleanEnd(search_string=search_string)


class SubstanceSourceMaterialBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SubstanceSourceMaterialSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SubstanceSourceMaterialSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SubstanceSourceMaterialValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SubstanceSourceMaterialBooleanEnd(search_string=search_string)


class SubstanceSourceMaterialSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SubstanceSourceMaterialValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SubstanceSourceMaterialBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SubstanceSourceMaterialBooleanEnd(search_string=search_string)


class SupplyDeliveryBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SupplyDeliverySearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SupplyDeliverySearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SupplyDeliveryValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SupplyDeliveryBooleanEnd(search_string=search_string)


class SupplyDeliverySearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "receiver",
            "patient",
            "supplier",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SupplyDeliveryValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "SupplyDelivery:receiver",
            "SupplyDelivery:patient",
            "SupplyDelivery:supplier",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SupplyDeliveryBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SupplyDeliveryBooleanEnd(search_string=search_string)


class SupplyRequestBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return SupplyRequestSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return SupplyRequestSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class SupplyRequestValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return SupplyRequestBooleanEnd(search_string=search_string)


class SupplyRequestSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "requester",
            "identifier",
            "patient",
            "subject",
            "supplier",
            "category",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return SupplyRequestValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "SupplyRequest:requester",
            "SupplyRequest:patient",
            "SupplyRequest:subject",
            "SupplyRequest:supplier",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return SupplyRequestBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["CarePlan:activity-reference", "DocumentReference:based-on"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return SupplyRequestBooleanEnd(search_string=search_string)


class TaskBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return TaskSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return TaskSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class TaskValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return TaskBooleanEnd(search_string=search_string)


class TaskSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "owner",
            "requestedperformer-reference",
            "requester",
            "business-status",
            "identifier",
            "period",
            "code",
            "performer",
            "subject",
            "focus",
            "part-of",
            "encounter",
            "authored-on",
            "priority",
            "intent",
            "output",
            "actor",
            "group-identifier",
            "based-on",
            "patient",
            "modified",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return TaskValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "Task:owner",
            "Task:requestedperformer-reference",
            "Task:requester",
            "Task:subject",
            "Task:focus",
            "Task:part-of",
            "Task:encounter",
            "Task:output",
            "Task:actor",
            "Task:based-on",
            "Task:patient",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return TaskBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "AuditEvent:based-on",
            "CarePlan:activity-reference",
            "ImagingSelection:based-on",
            "ImagingStudy:based-on",
            "PaymentReconciliation:request",
            "Provenance:based-on",
            "Task:part-of",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return TaskBooleanEnd(search_string=search_string)


class TerminologyCapabilitiesBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return TerminologyCapabilitiesSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return TerminologyCapabilitiesSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class TerminologyCapabilitiesValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return TerminologyCapabilitiesBooleanEnd(search_string=search_string)


class TerminologyCapabilitiesSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "context-type-value",
            "jurisdiction",
            "description",
            "context-type",
            "title",
            "version",
            "url",
            "context-quantity",
            "context",
            "name",
            "publisher",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return TerminologyCapabilitiesValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return TerminologyCapabilitiesBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return TerminologyCapabilitiesBooleanEnd(search_string=search_string)


class TestPlanBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return TestPlanSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return TestPlanSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class TestPlanValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return TestPlanBooleanEnd(search_string=search_string)


class TestPlanSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "scope",
            "url",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return TestPlanValue(search_string=search_string)

    def include(
        self,
        value: Literal["TestPlan:scope"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return TestPlanBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return TestPlanBooleanEnd(search_string=search_string)


class TestReportBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return TestReportSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return TestReportSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class TestReportValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return TestReportBooleanEnd(search_string=search_string)


class TestReportSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "result",
            "identifier",
            "tester",
            "testscript",
            "issued",
            "participant",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return TestReportValue(search_string=search_string)

    def include(
        self,
        value: Literal["TestReport:testscript"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return TestReportBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return TestReportBooleanEnd(search_string=search_string)


class TestScriptBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return TestScriptSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return TestScriptSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class TestScriptValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return TestScriptBooleanEnd(search_string=search_string)


class TestScriptSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "context-type-value",
            "jurisdiction",
            "description",
            "testscript-capability",
            "context-type",
            "scope-artifact-phase",
            "title",
            "scope-artifact-conformance",
            "version",
            "scope-artifact",
            "url",
            "context-quantity",
            "context",
            "name",
            "publisher",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return TestScriptValue(search_string=search_string)

    def include(
        self,
        value: Literal["TestScript:scope-artifact"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return TestScriptBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["TestReport:testscript"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return TestScriptBooleanEnd(search_string=search_string)


class TransportBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return TransportSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return TransportSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class TransportValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return TransportBooleanEnd(search_string=search_string)


class TransportSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "identifier",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return TransportValue(search_string=search_string)

    def include(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return TransportBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return TransportBooleanEnd(search_string=search_string)


class ValueSetBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return ValueSetSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return ValueSetSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class ValueSetValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return ValueSetBooleanEnd(search_string=search_string)


class ValueSetSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "date",
            "identifier",
            "code",
            "context-type-value",
            "jurisdiction",
            "description",
            "derived-from",
            "context-type",
            "predecessor",
            "title",
            "version",
            "url",
            "expansion",
            "reference",
            "context-quantity",
            "effective",
            "context",
            "name",
            "publisher",
            "topic",
            "context-type-quantity",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return ValueSetValue(search_string=search_string)

    def include(
        self,
        value: Literal["ValueSet:derived-from", "ValueSet:predecessor"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return ValueSetBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[
            "ConceptMap:target-scope",
            "ConceptMap:source-scope",
            "StructureDefinition:valueset",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return ValueSetBooleanEnd(search_string=search_string)


class VerificationResultBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return VerificationResultSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return VerificationResultSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class VerificationResultValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return VerificationResultBooleanEnd(search_string=search_string)


class VerificationResultSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "status-date",
            "primarysource-who",
            "primarysource-date",
            "validator-organization",
            "attestation-method",
            "attestation-onbehalfof",
            "target",
            "attestation-who",
            "primarysource-type",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return VerificationResultValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "VerificationResult:primarysource-who",
            "VerificationResult:validator-organization",
            "VerificationResult:attestation-onbehalfof",
            "VerificationResult:target",
            "VerificationResult:attestation-who",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return VerificationResultBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal[""],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return VerificationResultBooleanEnd(search_string=search_string)


class VisionPrescriptionBooleanEnd:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def AND(self):
        search_string = self.search_string + "&"
        return VisionPrescriptionSearchBuilder(search_string=search_string)

    def OR(self):
        search_string = self.search_string + "|"
        return VisionPrescriptionSearchBuilder(search_string=search_string)

    def build(self):
        return self.search_string


class VisionPrescriptionValue:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def eq(
        self,
        value: str,
        comparator: Literal["eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"] = "",
    ):
        search_string = self.search_string + f"={comparator}{value}"
        return VisionPrescriptionBooleanEnd(search_string=search_string)


class VisionPrescriptionSearchBuilder:
    def __init__(self, search_string: str):
        self.search_string = search_string

    def param(
        self,
        value: Literal[
            "_text",
            "_id",
            "_list",
            "_has",
            "_type",
            "_sort",
            "_count",
            "_include",
            "_revinclude",
            "_summary",
            "_elements",
            "_contained",
            "_containedType",
            "_language",
            "_query",
            "_in",
            "_lastUpdated",
            "_security",
            "_filter",
            "_profile",
            "_tag",
            "_source",
            "_content",
            "prescriber",
            "identifier",
            "patient",
            "datewritten",
            "encounter",
            "status",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        search_string = self.search_string + value
        if modifier:
            search_string = search_string + f":{modifier}"
        return VisionPrescriptionValue(search_string=search_string)

    def include(
        self,
        value: Literal[
            "VisionPrescription:prescriber",
            "VisionPrescription:patient",
            "VisionPrescription:encounter",
        ],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_include:{modifier}={value}"
        else:
            search_string = self.search_string + f"_include={value}"
        return VisionPrescriptionBooleanEnd(search_string=search_string)

    def revinclude(
        self,
        value: Literal["CarePlan:activity-reference", "DocumentReference:based-on"],
        modifier: Literal[
            "missing",
            "exact",
            "contains",
            "not",
            "text",
            "in",
            "not-in",
            "below",
            "above",
            "type",
            "identifier",
            "of-type",
            "code-text",
            "text-advanced",
            "iterate",
        ] = "",
    ):
        if modifier:
            search_string = self.search_string + f"_revinclude:{modifier}={value}"
        else:
            search_string = self.search_string + f"_revinclude={value}"
        return VisionPrescriptionBooleanEnd(search_string=search_string)
