# Generated by Django 3.0.4 on 2020-03-24 22:34

import colorfield.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('lims', '0052_auto_20200324_1631'),
    ]

    operations = [
        migrations.CreateModel(
            name='AccessType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=30)),
                ('color', colorfield.fields.ColorField(default='#000000', max_length=18)),
                ('email_subject', models.CharField(max_length=100, verbose_name='Email Subject')),
                ('email_body', models.TextField(blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='Beamtime',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('comments', models.TextField(blank=True)),
                ('cancelled', models.BooleanField(default=False)),
                ('start', models.DateTimeField(verbose_name='Start')),
                ('end', models.DateTimeField(verbose_name='End')),
                ('access', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='beamtime', to='schedule.AccessType')),
                ('beamline', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='beamtime', to='lims.Beamline')),
                ('project', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='beamtime', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='EmailNotification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email_subject', models.CharField(max_length=100, verbose_name='Email Subject')),
                ('email_body', models.TextField(blank=True)),
                ('send_time', models.DateTimeField(null=True, verbose_name='Send Time')),
                ('sent', models.BooleanField(default=False)),
                ('beamtime', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notifications', to='schedule.Beamtime')),
            ],
        ),
        migrations.CreateModel(
            name='Downtime',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateTimeField(blank=True, null=True, verbose_name='start')),
                ('end', models.DateTimeField(blank=True, null=True, verbose_name='end')),
                ('scope', models.IntegerField(choices=[(0, 'Facility Downtime'), (1, 'Beamline Maintenance')], default=0)),
                ('comments', models.TextField(blank=True)),
                ('beamline', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='downtime', to='lims.Beamline')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='BeamlineSupport',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField()),
                ('staff', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='support', to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
