# Generated by Django 3.1.5 on 2021-02-01 17:07

from django.db import migrations, models


def update_active(apps, schema_editor):
    """
    Update active flag for existing Container Types
    """
    ContainerType = apps.get_model('lims', 'ContainerType')
    ContainerLocation = apps.get_model('lims', 'ContainerLocation')
    db_alias = schema_editor.connection.alias

    sample_locations = ContainerLocation.objects.using(db_alias).filter(accepts__isnull=True)
    ContainerType.objects.using(db_alias).filter(locations__in=sample_locations).update(active=True)


class Migration(migrations.Migration):

    dependencies = [
        ('lims', '0089_remove_containertype_layout'),
    ]

    operations = [
        migrations.AddField(
            model_name='containertype',
            name='active',
            field=models.BooleanField(default=False, verbose_name='User option'),
        ),
        migrations.RunPython(update_active)
    ]
