# Generated by Django 3.0.1 on 2020-01-05 18:22

from django.db import migrations
from django.db.models import Q, F, Value, Subquery, OuterRef, ExpressionWrapper, IntegerField
from django.db.models.functions import Concat, Length


def activity(apps, schema_editor):
    """
    Fix names and kinds of Data Analysis Reports
    """
    AnalysisReport = apps.get_model('lims', 'AnalysisReport')
    db_alias = schema_editor.connection.alias

    # XRD
    AnalysisReport.objects.using(db_alias).filter(kind__startswith="Azimuthal Integration").update(kind='XRD Analysis')
    AnalysisReport.objects.using(db_alias).filter(kind__startswith="Azimuthal Calibration").update(kind='XRD Calibration')
    AnalysisReport.objects.using(db_alias).filter(kind__endswith="XRD Profile").update(kind='XRD Analysis')

    # screening
    AnalysisReport.objects.using(db_alias).filter(kind__icontains="screening").update(kind='MX Screening')

    # data processing
    excludes = ['XRD Analysis', 'XRD Calibration', 'MX Screening', 'MX Anomalous Merging']
    AnalysisReport.objects.using(db_alias).filter(kind__startswith="Anomalous Merging").update(
        kind='MX Anomalous Merging')
    AnalysisReport.objects.using(db_alias).exclude(kind__in=excludes).filter(
        Q(kind__icontains="Analysis") | Q(kind__icontains="Processing")).filter(kind__icontains='Anomalous').update(
        kind='MX Anomalous Analysis')
    AnalysisReport.objects.using(db_alias).exclude(kind__in=excludes).filter(
        Q(kind__icontains="Analysis") | Q(kind__icontains="Processing")).filter(kind__icontains='Merged').update(
        kind='MX Merging')
    excludes += ['MX Anomalous Merging', 'MX Anomalous Analysis', 'MX Merging']
    AnalysisReport.objects.using(db_alias).exclude(kind__in=excludes).filter(
        Q(kind__icontains="Analysis") | Q(kind__icontains="Processing")).exclude(
        Q(kind__icontains='Anomalous') | Q(kind__icontains='Merged')).update(
        kind='MX Native Analysis')

    # mosgo
    mosgo_screening = Q(kind__icontains="Mosgo Stategy") | Q(kind__icontains="MOSFLM")
    AnalysisReport.objects.using(db_alias).filter(mosgo_screening).update(name='MOSFLM STRATEGY', kind='MOSFLM STRATEGY')

    # delete initial testing reports from 2011
    AnalysisReport.objects.using(db_alias).filter(kind="0").delete()

    # rename all reports to "{kind} of {data.name}" unless the new name is longer than 60 chars
    AnalysisReport.objects.using(db_alias).annotate(kl=Length('kind'), dl=Length('data__name')).annotate(
        length=ExpressionWrapper(F('kl') + F('dl'), output_field=IntegerField())).filter(length__lte=56).update(
        name=Subquery(AnalysisReport.objects.filter(pk=OuterRef('pk')).annotate(
            new_name=Concat('kind', Value(' of '), 'data__name')).values('new_name')[:1]))


class Migration(migrations.Migration):

    dependencies = [
        ('lims', '0045_auto_20191231_1956'),
    ]

    operations = [
        migrations.RunPython(activity)
    ]
