# Generated by Django 3.0.1 on 2019-12-31 23:58

from django.db import migrations
from django.core.exceptions import FieldError


def activity(apps, schema_editor):
    """
    Populate Project types based on previous User Categories
    """
    ProjectType = apps.get_model('lims', 'ProjectType')
    Project = apps.get_model('lims', 'Project')
    db_alias = schema_editor.connection.alias

    # First mark student accounts guessing based on CMCF conventions
    Project.objects.using(db_alias).filter(name__startswith='mx').update(
        kind=ProjectType.objects.using(db_alias).get(name__iexact='Student')
    )

    # Next mark Staff accounts
    try:
        Project.objects.using(db_alias).filter(kind__isnull=True, categories__name__icontains='Staff').update(
            kind=ProjectType.objects.using(db_alias).get(name__iexact='Staff')
        )
    except FieldError:
        pass

    # Next mark industry accounts
    try:
        Project.objects.using(db_alias).filter(kind__isnull=True, categories__name__icontains='Purchased').update(
            kind=ProjectType.objects.using(db_alias).get(name__iexact='Industry')
        )
    except FieldError:
        pass

    # Mark everyone else as academic
    Project.objects.using(db_alias).filter(kind__isnull=True).update(
        kind=ProjectType.objects.using(db_alias).get(name__iexact='Academic')
    )

class Migration(migrations.Migration):

    dependencies = [
        ('lims', '0042_project_kind'),
    ]

    operations = [
        migrations.RunPython(activity)
    ]
