# Generated by Django 3.0.1 on 2019-12-31 01:17

from django.db import migrations, models
from django.forms.models import model_to_dict
import django.utils.timezone
import model_utils.fields
import basiclive.core.lims.models


def transfer_announcements(apps, schema_editor):
    """
    Transfer from annoucements to Guides
    """
    Guide = apps.get_model('lims', 'Guide')
    try:
        Announcement= apps.get_model('staff', 'Announcement')
    except LookupError:
        return

    db_alias = schema_editor.connection.alias
    to_create = []
    for obj in Announcement.objects.using(db_alias).order_by('id'):
        info = model_to_dict(obj)
        info.pop('id')

        to_create.append(Guide(**info))

    Guide.objects.using(db_alias).bulk_create(to_create)


class Migration(migrations.Migration):

    dependencies = [
        ('lims', '0039_auto_20191229_2336'),
    ]

    operations = [
        migrations.CreateModel(
            name='Guide',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('title', models.CharField(blank=True, max_length=50)),
                ('description', models.TextField(blank=True)),
                ('priority', models.IntegerField(default=0)),
                ('attachment', models.FileField(blank=True, upload_to=basiclive.core.lims.models.get_storage_path)),
                ('staff_only', models.BooleanField(default=False)),
                ('kind', models.CharField(choices=[('snippet', 'Snippet'), ('video', 'Video'), ('image', 'Image')], default='snippet', max_length=20)),
                ('modal', models.BooleanField(default=False)),
                ('url', models.CharField(blank=True, max_length=200, null=True)),
            ],
            options={
                'ordering': ('-staff_only', 'priority'),
            },
        ),
        migrations.RunPython(transfer_announcements)
    ]
