# Generated by Django 2.2.5 on 2019-12-20 01:23

from django.db import migrations, models

def update_num_frames(apps, schema_editor):
    """
    Data  num frames
    """
    Data = apps.get_model('lims', 'Data')
    db_alias = schema_editor.connection.alias
    for data in Data.objects.using(db_alias).all():
        if data.frames:
            num_frames = len(data.frames)
            Data.objects.using(db_alias).filter(pk=data.pk).update(num_frames=num_frames)


class Migration(migrations.Migration):

    dependencies = [
        ('lims', '0035_auto_20191219_1940'),
    ]

    operations = [
        migrations.AddField(
            model_name='data',
            name='num_frames',
            field=models.IntegerField(default=1),
        ),
        migrations.RunPython(update_num_frames),
    ]
