# Generated by Django 2.2.5 on 2019-11-11 14:50

from django.db import migrations


def activity(apps, schema_editor):
    """
    Update Data Type with initial information in preparation for using a table instead of strings
    """
    DataType = apps.get_model('lims', 'DataType')
    Data = apps.get_model('lims', 'Data')
    db_alias = schema_editor.connection.alias
    to_create = [
        DataType(
            name='MX Screening', acronym='SCREEN', template="users/entries/data-frames.html",
            description="Test frames for sample characterization and evaluation",
            metadata=[
                'delta_angle', 'start_angle', 'resolution', 'detector', 'detector_type',
                'detector_size', 'pixel_size', 'beam_x', 'beam_y', 'two_theta'
            ]
        ),
        DataType(
            name='MX Dataset', acronym='DATA', template="users/entries/data-frames.html",
            description="Full MX Dataset",
            metadata=[
                'delta_angle', 'start_angle', 'resolution', 'detector', 'detector_type',
                'detector_size', 'pixel_size', 'beam_x', 'beam_y', 'two_theta'
            ]
        ),
        DataType(
            name='XRD Dataset', acronym='XRD', template="users/entries/data-frames.html",
            description="Full MX Dataset",
            metadata=[
                'delta_angle', 'start_angle', 'resolution', 'detector', 'detector_type',
                'detector_size', 'pixel_size', 'beam_x', 'beam_y', 'two_theta'
            ]
        ),
        DataType(
            name='Rastering', acronym='RASTER', template="users/entries/data-frames.html",
            description="Diffraction Cartography Dataset",
            metadata=[
                'grid_points', 'grid_origin', 'start_angle', 'delta_angle', 'detector_type',
                'detector_size', 'pixel_size', 'beam_x', 'beam_y', 'inverse_beam'
            ],
        ),
        DataType(
            name='XAS Dataset', acronym='XAS', template="users/entries/data-xas.html",
            description="X-ray Absorption Spectroscopy Dataset",
            metadata=[],
        ),
        DataType(
            name='XRF Dataset', acronym='XRF', template="users/entries/data-xrf.html",
            description="X-ray Fluorescence Spectroscopy Dataset",
            metadata=[],
        ),
        DataType(
            name='MAD Scan', acronym='MAD', template="users/entries/data-mad.html",
            description="Multiple Anomalous Dispersion Scan",
            metadata=['roi', 'edge'],
        ),
    ]

    # create new datatype objects
    DataType.objects.using(db_alias).bulk_create(to_create)

    # update data types for each data object
    acronyms = {
        'SCREEN': 'MX_SCREEN',  'DATA': 'MX_DATA',  'XRD': 'XRD_DATA',  'RASTER': 'RASTER',
        'XAS': 'XAS_SCAN', 'XRF': 'XRF_SCAN', 'MAD': 'MAD_SCAN'
    }
    for dt in DataType.objects.using(db_alias).all():
        Data.objects.using(db_alias).filter(kind_outgoing=acronyms[dt.acronym]).update(kind=dt)


class Migration(migrations.Migration):

    dependencies = [
        ('lims', '0031_data_kind'),
    ]

    operations = [
        migrations.RunPython(activity)
    ]
