# Generated by Django 2.2.5 on 2019-11-10 18:29

from django.db import migrations, models


def fix_cassette_coords(apps, schema_editor):
    """
    Update Cassette location coordinates to be more centered since labels
    are now shown entirely within each sample location
    """
    ContainerType = apps.get_model('lims', 'ContainerType')
    db_alias = schema_editor.connection.alias
    if ContainerType.objects.using(db_alias).filter(name='Cassette').exists():
        cassette = ContainerType.objects.using(db_alias).get(name='Cassette')
        xcoords = cassette.coords.values_list('x', flat=True)
        ycoords = cassette.coords.values_list('y', flat=True)
        xoffset = 0.5*(1-max(xcoords) - min(xcoords))
        yoffset = 0.5*(1-max(ycoords) - min(ycoords))
        cassette.coords.update(x=(models.F('x') + xoffset), y=(models.F('y') + yoffset))


class Migration(migrations.Migration):

    dependencies = [
        ('lims', '0026_auto_20191109_1921'),
    ]

    operations = [
        migrations.RunPython(fix_cassette_coords),
    ]
