# Generated by Django 2.2.5 on 2019-11-10 00:24

from django.db import migrations, models


def save_loc_name(apps, schema_editor):
    """
    Save Locations from layout into Location Object
    """
    Sample = apps.get_model('lims', 'Sample')
    ContainerLocation = apps.get_model('lims', 'ContainerLocation')

    db_alias = schema_editor.connection.alias
    Sample.objects.using(db_alias).filter(container__isnull=True).delete()
    Sample.objects.using(db_alias).filter(location__isnull=True).delete()
    Sample.objects.using(db_alias).update(loc_name=models.F('location'))
    for s in Sample.objects.using(db_alias).all():
        try:
            loc = s.container.kind.locations.get(name=s.location)
            s.location = loc.pk
            s.save()
        except ContainerLocation.DoesNotExist:
            s.delete()


class Migration(migrations.Migration):

    dependencies = [
        ('lims', '0023_sample_loc_name'),
    ]

    operations = [
        migrations.RunPython(save_loc_name),
    ]
