# Generated by Django 2.2.5 on 2019-09-14 22:05

from django.db import migrations


def create_coords_data(apps, schema_editor):
    """
    Save Locations from layout into Location Object
    """
    ContainerType = apps.get_model('lims', 'ContainerType')
    LocationCoord = apps.get_model('lims', 'LocationCoord')
    db_alias = schema_editor.connection.alias
    to_create = []
    for kind in ContainerType.objects.all():
        for loc in kind.locations.all():
            layout = kind.layout
            x, y = layout.get('locations', {}).get(loc.name, [0.0, 0.0])
            to_create.append(LocationCoord(kind=kind, location=loc, x=x, y=y))
    LocationCoord.objects.using(db_alias).bulk_create(to_create)


class Migration(migrations.Migration):

    dependencies = [
        ('lims', '0016_locationcoord'),
    ]

    operations = [
        migrations.RunPython(create_coords_data),
    ]
