# Generated by Django 2.2.5 on 2019-09-10 04:15

from django.db import migrations


def update_location_coords(apps, schema_editor):
    """
    Save Locations from layout into Container Location Object
    """
    ContainerLocation = apps.get_model('lims', 'ContainerLocation')
    for loc in ContainerLocation.objects.all():
        kind = loc.containers.first()
        if kind:
            layout = kind.layout
            x, y = layout.get('locations', {}).get(loc.name, [0.0, 0.0])
            loc.x = x
            loc.y = y
            loc.save()


class Migration(migrations.Migration):

    dependencies = [
        ('lims', '0009_auto_20190909_2214'),
    ]

    operations = [
        migrations.RunPython(update_location_coords),
    ]
