# Generated by Django 2.2.4 on 2019-09-08 04:14

from django.conf import settings
import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('lims', '0006_auto_20190409_1459'),
    ]

    operations = [
        migrations.AlterField(
            model_name='activitylog',
            name='action_type',
            field=models.IntegerField(choices=[(0, 'Login'), (1, 'Logout'), (2, 'Task'), (3, 'Create'), (4, 'Modify'), (5, 'Delete'), (6, 'Archive')]),
        ),
        migrations.AlterField(
            model_name='activitylog',
            name='content_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='contenttypes.ContentType'),
        ),
        migrations.AlterField(
            model_name='activitylog',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='Date/Time'),
        ),
        migrations.AlterField(
            model_name='activitylog',
            name='ip_number',
            field=models.GenericIPAddressField(verbose_name='IP Address'),
        ),
        migrations.AlterField(
            model_name='activitylog',
            name='object_repr',
            field=models.CharField(blank=True, max_length=200, null=True, verbose_name='Entity'),
        ),
        migrations.AlterField(
            model_name='activitylog',
            name='project',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='activitylog',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='activities', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='activitylog',
            name='user_description',
            field=models.CharField(blank=True, max_length=60, null=True, verbose_name='User name'),
        ),
        migrations.AlterField(
            model_name='analysisreport',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='date created'),
        ),
        migrations.AlterField(
            model_name='analysisreport',
            name='modified',
            field=models.DateTimeField(auto_now=True, verbose_name='date modified'),
        ),
        migrations.AlterField(
            model_name='analysisreport',
            name='score',
            field=models.FloatField(default=0.0),
        ),
        migrations.AlterField(
            model_name='container',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='date created'),
        ),
        migrations.AlterField(
            model_name='container',
            name='location',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='lims.ContainerLocation'),
        ),
        migrations.AlterField(
            model_name='container',
            name='modified',
            field=models.DateTimeField(auto_now=True, verbose_name='date modified'),
        ),
        migrations.AlterField(
            model_name='container',
            name='shipment',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='lims.Shipment'),
        ),
        migrations.AlterField(
            model_name='data',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='date created'),
        ),
        migrations.AlterField(
            model_name='data',
            name='kind',
            field=models.CharField(choices=[('MX_SCREEN', 'MX Screening'), ('MX_DATA', 'MX Dataset'), ('XRD_DATA', 'XRD Dataset'), ('RASTER', 'Raster'), ('XAS_SCAN', 'XAS Scan'), ('XRF_SCAN', 'XRF Scan'), ('MAD_SCAN', 'MAD Scan')], default='MX_SCREEN', max_length=20, verbose_name='Data type'),
        ),
        migrations.AlterField(
            model_name='data',
            name='modified',
            field=models.DateTimeField(auto_now=True, verbose_name='date modified'),
        ),
        migrations.AlterField(
            model_name='dewar',
            name='modified',
            field=models.DateTimeField(auto_now=True, verbose_name='date modified'),
        ),
        migrations.AlterField(
            model_name='group',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='date created'),
        ),
        migrations.AlterField(
            model_name='group',
            name='kind',
            field=models.IntegerField(choices=[(0, 'Native'), (1, 'MAD'), (2, 'SAD'), (3, 'S-SAD')], default=0, verbose_name='exp. type'),
        ),
        migrations.AlterField(
            model_name='group',
            name='modified',
            field=models.DateTimeField(auto_now=True, verbose_name='date modified'),
        ),
        migrations.AlterField(
            model_name='group',
            name='plan',
            field=models.IntegerField(choices=[(0, 'Collect best'), (1, 'Collect first good'), (2, 'Screen and confirm'), (4, 'Collect all')], default=0),
        ),
        migrations.AlterField(
            model_name='group',
            name='resolution',
            field=models.FloatField(blank=True, null=True, verbose_name='Desired Resolution (&#8491;)'),
        ),
        migrations.AlterField(
            model_name='group',
            name='sample_count',
            field=models.PositiveIntegerField(default=1, verbose_name='Number of Samples'),
        ),
        migrations.AlterField(
            model_name='group',
            name='shipment',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='lims.Shipment'),
        ),
        migrations.AlterField(
            model_name='loadhistory',
            name='location',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='lims.ContainerLocation'),
        ),
        migrations.AlterField(
            model_name='project',
            name='carrier',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='lims.Carrier'),
        ),
        migrations.AlterField(
            model_name='project',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='date created'),
        ),
        migrations.AlterField(
            model_name='project',
            name='last_name',
            field=models.CharField(blank=True, max_length=150, verbose_name='last name'),
        ),
        migrations.AlterField(
            model_name='project',
            name='modified',
            field=models.DateTimeField(auto_now=True, verbose_name='date modified'),
        ),
        migrations.AlterField(
            model_name='project',
            name='name',
            field=models.SlugField(verbose_name='account name'),
        ),
        migrations.AlterField(
            model_name='project',
            name='username',
            field=models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username'),
        ),
        migrations.AlterField(
            model_name='sample',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='date created'),
        ),
        migrations.AlterField(
            model_name='sample',
            name='group',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='lims.Group'),
        ),
        migrations.AlterField(
            model_name='sample',
            name='location',
            field=models.CharField(blank=True, max_length=10, null=True, verbose_name='port'),
        ),
        migrations.AlterField(
            model_name='sample',
            name='modified',
            field=models.DateTimeField(auto_now=True, verbose_name='date modified'),
        ),
        migrations.AlterField(
            model_name='session',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='date created'),
        ),
        migrations.AlterField(
            model_name='shipment',
            name='carrier',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='lims.Carrier'),
        ),
        migrations.AlterField(
            model_name='shipment',
            name='created',
            field=models.DateTimeField(auto_now_add=True, verbose_name='date created'),
        ),
        migrations.AlterField(
            model_name='shipment',
            name='modified',
            field=models.DateTimeField(auto_now=True, verbose_name='date modified'),
        ),
        migrations.AlterField(
            model_name='spacegroup',
            name='crystal_system',
            field=models.CharField(choices=[('a', 'triclinic'), ('m', 'monoclinic'), ('o', 'orthorombic'), ('t', 'tetragonal'), ('h', 'hexagonal'), ('c', 'cubic')], max_length=1),
        ),
        migrations.AlterField(
            model_name='spacegroup',
            name='lattice_type',
            field=models.CharField(choices=[('P', 'primitive'), ('C', 'side-centered'), ('I', 'body-centered'), ('F', 'face-centered'), ('R', 'rhombohedral')], max_length=1),
        ),
    ]
