# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2017-11-15 19:17
from __future__ import unicode_literals

from django.conf import settings
import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import jsonfield.fields
from basiclive.core import lims


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('auth', '0008_alter_user_username_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.ASCIIUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=30, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('name', models.SlugField(verbose_name=b'account name')),
                ('contact_person', models.CharField(blank=True, max_length=200, null=True)),
                ('contact_email', models.EmailField(blank=True, max_length=100, null=True)),
                ('account_number', models.CharField(blank=True, max_length=50, null=True)),
                ('department', models.CharField(blank=True, max_length=600, null=True)),
                ('address', models.CharField(blank=True, max_length=600, null=True)),
                ('city', models.CharField(blank=True, max_length=180, null=True)),
                ('province', models.CharField(blank=True, max_length=180, null=True)),
                ('postal_code', models.CharField(blank=True, max_length=30, null=True)),
                ('country', models.CharField(blank=True, max_length=180, null=True)),
                ('contact_phone', models.CharField(blank=True, max_length=60, null=True)),
                ('contact_fax', models.CharField(blank=True, max_length=60, null=True)),
                ('organisation', models.CharField(blank=True, max_length=600, null=True)),
                ('show_archives', models.BooleanField(default=False)),
                ('key', models.CharField(blank=True, max_length=100, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name=b'date created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name=b'date modified')),
                ('updated', models.BooleanField(default=False)),
            ],
            options={
                'verbose_name': 'Project Account',
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='ActivityLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name=b'Date/Time')),
                ('user_description', models.CharField(blank=True, max_length=60, null=True, verbose_name=b'User name')),
                ('ip_number', models.GenericIPAddressField(verbose_name=b'IP Address')),
                ('object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('action_type', models.IntegerField(choices=[(0, b'Login'), (1, b'Logout'), (2, b'Task'), (3, b'Create'), (4, b'Modify'), (5, b'Delete'), (6, b'Archive')])),
                ('object_repr', models.CharField(blank=True, max_length=200, null=True, verbose_name=b'Entity')),
                ('description', models.TextField(blank=True)),
                ('content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('project', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='activities', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-created',),
            },
        ),
        migrations.CreateModel(
            name='AnalysisReport',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60)),
                ('staff_comments', models.TextField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name=b'date created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name=b'date modified')),
                ('status', models.IntegerField(choices=[(5, 'Active'), (9, 'Archived'), (10, 'Trashed')], default=5)),
                ('kind', models.CharField(max_length=100)),
                ('score', models.FloatField()),
                ('url', models.CharField(max_length=200)),
                ('details', jsonfield.fields.JSONField(default=[])),
            ],
            options={
                'ordering': ['-score'],
            },
        ),
        migrations.CreateModel(
            name='Beamline',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=600)),
                ('acronym', models.CharField(max_length=50)),
                ('energy_lo', models.FloatField(default=4.0)),
                ('energy_hi', models.FloatField(default=18.5)),
                ('contact_phone', models.CharField(max_length=60)),
            ],
        ),
        migrations.CreateModel(
            name='Carrier',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60)),
                ('url', models.URLField()),
            ],
        ),
        migrations.CreateModel(
            name='Component',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='ComponentType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
            ],
        ),
        migrations.CreateModel(
            name='Container',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60)),
                ('staff_comments', models.TextField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name=b'date created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name=b'date modified')),
                ('status', models.IntegerField(choices=[(0, 'Draft'), (1, 'Sent'), (2, 'On-site'), (3, 'Loaded'), (4, 'Returned'), (9, 'Archived')], default=0)),
                ('comments', models.TextField(blank=True, null=True)),
                ('priority', models.IntegerField(default=0)),
            ],
            options={
                'ordering': ('kind', 'location'),
            },
        ),
        migrations.CreateModel(
            name='ContainerLocation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=5)),
            ],
        ),
        migrations.CreateModel(
            name='ContainerType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=20)),
                ('layout', jsonfield.fields.JSONField(blank=True, null=True)),
                ('envelope', models.CharField(blank=True, max_length=200)),
                ('container_locations', models.ManyToManyField(blank=True, related_name='containers', to='lims.ContainerLocation')),
            ],
        ),
        migrations.CreateModel(
            name='Data',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60)),
                ('staff_comments', models.TextField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name=b'date created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name=b'date modified')),
                ('status', models.IntegerField(choices=[(5, 'Active'), (9, 'Archived'), (10, 'Trashed')], default=5)),
                ('file_name', models.CharField(blank=True, max_length=200, null=True)),
                ('frames', lims.models.FrameField(blank=True, max_length=200, null=True)),
                ('exposure_time', models.FloatField(blank=True, null=True)),
                ('attenuation', models.FloatField(default=0.0)),
                ('energy', models.DecimalField(decimal_places=4, max_digits=10)),
                ('beam_size', models.FloatField(blank=True, null=True)),
                ('url', models.CharField(max_length=200)),
                ('kind', models.CharField(choices=[(b'MX_SCREEN', b'MX Screening'), (b'MX_DATA', b'MX Dataset'), (b'XRD_DATA', b'XRD Dataset'), (b'RASTER', b'Raster'), (b'XAS_SCAN', b'XAS Scan'), (b'XRF_SCAN', b'XRF Scan'), (b'MAD_SCAN', b'MAD Scan')], default=b'MX_SCREEN', max_length=20, verbose_name=b'Data type')),
                ('download', models.BooleanField(default=False)),
                ('meta_data', jsonfield.fields.JSONField(default={})),
                ('beamline', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='lims.Beamline')),
            ],
            options={
                'verbose_name': 'Dataset',
            },
        ),
        migrations.CreateModel(
            name='Dewar',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('staff_comments', models.TextField(blank=True, null=True)),
                ('modified', models.DateTimeField(auto_now=True, verbose_name=b'date modified')),
                ('active', models.BooleanField(default=False)),
                ('beamline', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lims.Beamline')),
                ('container', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='dewars', to='lims.Container')),
            ],
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60)),
                ('staff_comments', models.TextField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name=b'date created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name=b'date modified')),
                ('status', models.IntegerField(choices=[(0, 'Draft'), (5, 'Active'), (6, 'Processing'), (7, 'Complete'), (9, 'Archived')], default=0)),
                ('energy', models.DecimalField(blank=True, decimal_places=4, max_digits=10, null=True)),
                ('kind', models.IntegerField(choices=[(0, b'Native'), (1, b'MAD'), (2, b'SAD')], default=0, verbose_name=b'exp. type')),
                ('absorption_edge', models.CharField(blank=True, max_length=5, null=True)),
                ('plan', models.IntegerField(choices=[(0, b'Rank and collect best'), (1, b'Collect first good'), (2, b'Screen and confirm'), (3, b'Screen and collect'), (4, b'Just collect')], default=2)),
                ('comments', models.TextField(blank=True, null=True)),
                ('priority', models.IntegerField(blank=True, null=True)),
                ('sample_count', models.PositiveIntegerField(default=1, verbose_name=b'Number of Samples')),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['priority'],
                'verbose_name': 'Group',
            },
        ),
        migrations.CreateModel(
            name='LoadHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateTimeField(auto_now_add=True)),
                ('end', models.DateTimeField(blank=True, null=True)),
                ('child', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='parent_history', to='lims.Container')),
                ('location', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='lims.ContainerLocation')),
                ('parent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='children_history', to='lims.Container')),
            ],
            options={
                'ordering': ['-start'],
            },
        ),
        migrations.CreateModel(
            name='Sample',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60)),
                ('staff_comments', models.TextField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name=b'date created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name=b'date modified')),
                ('barcode', models.SlugField(blank=True, null=True)),
                ('location', models.CharField(blank=True, max_length=10, null=True, verbose_name=b'port')),
                ('comments', models.TextField(blank=True, null=True)),
                ('collect_status', models.BooleanField(default=False)),
                ('priority', models.IntegerField(blank=True, null=True)),
                ('container', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='lims.Container')),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='lims.Group')),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['priority', 'container__name', 'location', 'name'],
            },
        ),
        migrations.CreateModel(
            name='Session',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name=b'date created')),
                ('name', models.CharField(max_length=100)),
                ('comments', models.TextField()),
                ('beamline', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='sessions', to='lims.Beamline')),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='sessions', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Shipment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60)),
                ('staff_comments', models.TextField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name=b'date created')),
                ('modified', models.DateTimeField(auto_now=True, verbose_name=b'date modified')),
                ('status', models.IntegerField(choices=[(0, 'Draft'), (1, 'Sent'), (2, 'On-site'), (4, 'Returned'), (9, 'Archived')], default=0)),
                ('comments', models.TextField(blank=True, max_length=200, null=True)),
                ('tracking_code', models.CharField(blank=True, max_length=60, null=True)),
                ('return_code', models.CharField(blank=True, max_length=60, null=True)),
                ('date_shipped', models.DateTimeField(blank=True, null=True)),
                ('date_received', models.DateTimeField(blank=True, null=True)),
                ('date_returned', models.DateTimeField(blank=True, null=True)),
                ('storage_location', models.CharField(blank=True, max_length=60, null=True)),
                ('carrier', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='lims.Carrier')),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SpaceGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=20)),
                ('crystal_system', models.CharField(choices=[(b'a', b'triclinic'), (b'm', b'monoclinic'), (b'o', b'orthorombic'), (b't', b'tetragonal'), (b'h', b'hexagonal'), (b'c', b'cubic')], max_length=1)),
                ('lattice_type', models.CharField(choices=[(b'P', b'primitive'), (b'C', b'side-centered'), (b'I', b'body-centered'), (b'F', b'face-centered'), (b'R', b'rhombohedral')], max_length=1)),
            ],
        ),
        migrations.CreateModel(
            name='Stretch',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateTimeField()),
                ('end', models.DateTimeField(blank=True, null=True)),
                ('session', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='stretches', to='lims.Session')),
            ],
            options={
                'ordering': ['-start'],
                'verbose_name': 'Beamline Usage',
                'verbose_name_plural': 'Beamline Usage',
            },
        ),
        migrations.AddField(
            model_name='group',
            name='shipment',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='lims.Shipment'),
        ),
        migrations.AddField(
            model_name='data',
            name='group',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='lims.Group'),
        ),
        migrations.AddField(
            model_name='data',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='data',
            name='sample',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='lims.Sample'),
        ),
        migrations.AddField(
            model_name='data',
            name='session',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='lims.Session'),
        ),
        migrations.AddField(
            model_name='containerlocation',
            name='accepts',
            field=models.ManyToManyField(blank=True, related_name='locations', to='lims.ContainerType'),
        ),
        migrations.AddField(
            model_name='container',
            name='kind',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lims.ContainerType'),
        ),
        migrations.AddField(
            model_name='container',
            name='location',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='lims.ContainerLocation'),
        ),
        migrations.AddField(
            model_name='container',
            name='parent',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='lims.Container'),
        ),
        migrations.AddField(
            model_name='container',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='container',
            name='shipment',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='lims.Shipment'),
        ),
        migrations.AddField(
            model_name='component',
            name='kind',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lims.ComponentType'),
        ),
        migrations.AddField(
            model_name='component',
            name='shipment',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='components', to='lims.Shipment'),
        ),
        migrations.AddField(
            model_name='beamline',
            name='automounters',
            field=models.ManyToManyField(through='lims.Dewar', to='lims.Container'),
        ),
        migrations.AddField(
            model_name='analysisreport',
            name='data',
            field=models.ManyToManyField(blank=True, related_name='reports', to='lims.Data'),
        ),
        migrations.AddField(
            model_name='analysisreport',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='project',
            name='carrier',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='lims.Carrier'),
        ),
        migrations.AddField(
            model_name='project',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups'),
        ),
        migrations.AddField(
            model_name='project',
            name='user_permissions',
            field=models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions'),
        ),
        migrations.AlterUniqueTogether(
            name='sample',
            unique_together=set([('project', 'container', 'location')]),
        ),
        migrations.AlterUniqueTogether(
            name='group',
            unique_together=set([('project', 'name', 'shipment')]),
        ),
        migrations.AlterUniqueTogether(
            name='container',
            unique_together=set([('project', 'name', 'shipment')]),
        ),
    ]
