# Generated by Django 3.1.4 on 2020-12-02 19:27

from django.db import migrations


def fix_content_type(apps, schema_editor):
    ContentType = apps.get_model('contenttypes', 'ContentType')
    db_alias = schema_editor.connection.alias
    ContentType.objects.using(db_alias).filter(app_label='staff').update(app_label='acl')


class Migration(migrations.Migration):

    dependencies = [
        ('acl', '0015_auto_20200923_0857'),
    ]

    operations = [
        migrations.RunPython(fix_content_type),
        migrations.AlterModelTable('userlist', 'acl_userlist'),
        migrations.AlterModelTable('remoteconnection', 'acl_remoteconnection'),
    ]
