import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type ORG::TEST::SAMPLE::MODULE
 *
 * @schema CfnSampleModuleProps
 */
export interface CfnSampleModuleProps {
    /**
     * @schema CfnSampleModuleProps#Parameters
     */
    readonly parameters?: CfnSampleModulePropsParameters;
    /**
     * @schema CfnSampleModuleProps#Resources
     */
    readonly resources?: CfnSampleModulePropsResources;
}
/**
 * Converts an object of type 'CfnSampleModuleProps' to JSON representation.
 */
export declare function toJson_CfnSampleModuleProps(obj: CfnSampleModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnSampleModulePropsParameters
 */
export interface CfnSampleModulePropsParameters {
    /**
     * Name for the bucket
     *
     * @schema CfnSampleModulePropsParameters#BucketName
     */
    readonly bucketName?: CfnSampleModulePropsParametersBucketName;
}
/**
 * Converts an object of type 'CfnSampleModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnSampleModulePropsParameters(obj: CfnSampleModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnSampleModulePropsResources
 */
export interface CfnSampleModulePropsResources {
    /**
     * @schema CfnSampleModulePropsResources#S3Bucket
     */
    readonly s3Bucket?: CfnSampleModulePropsResourcesS3Bucket;
}
/**
 * Converts an object of type 'CfnSampleModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnSampleModulePropsResources(obj: CfnSampleModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * Name for the bucket
 *
 * @schema CfnSampleModulePropsParametersBucketName
 */
export interface CfnSampleModulePropsParametersBucketName {
    /**
     * @schema CfnSampleModulePropsParametersBucketName#Type
     */
    readonly type: string;
    /**
     * @schema CfnSampleModulePropsParametersBucketName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnSampleModulePropsParametersBucketName' to JSON representation.
 */
export declare function toJson_CfnSampleModulePropsParametersBucketName(obj: CfnSampleModulePropsParametersBucketName | undefined): Record<string, any> | undefined;
/**
 * @schema CfnSampleModulePropsResourcesS3Bucket
 */
export interface CfnSampleModulePropsResourcesS3Bucket {
    /**
     * @schema CfnSampleModulePropsResourcesS3Bucket#Type
     */
    readonly type?: string;
    /**
     * @schema CfnSampleModulePropsResourcesS3Bucket#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnSampleModulePropsResourcesS3Bucket' to JSON representation.
 */
export declare function toJson_CfnSampleModulePropsResourcesS3Bucket(obj: CfnSampleModulePropsResourcesS3Bucket | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `ORG::TEST::SAMPLE::MODULE`
 *
 * @cloudformationResource ORG::TEST::SAMPLE::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnSampleModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "ORG::TEST::SAMPLE::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnSampleModuleProps;
    /**
     * Create a new `ORG::TEST::SAMPLE::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnSampleModuleProps);
}
