"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getKeySchemaProperty = exports.hash = void 0;
const crypto = require("crypto");
exports.hash = (code) => crypto.createHash('md5').update(code).digest('hex').substr(0, 6);
exports.getKeySchemaProperty = (table, keyType) => {
    const cfnTable = table.node.defaultChild;
    const keySchemas = cfnTable.keySchema;
    const partitionKeyAttribute = keySchemas.find((keySchema) => keySchema.keyType === keyType);
    if (partitionKeyAttribute === undefined) {
        throw new Error('PartitionKey is not set');
    }
    return partitionKeyAttribute;
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsaUNBQWlDO0FBR3BCLFFBQUEsSUFBSSxHQUFHLENBQUMsSUFBWSxFQUFVLEVBQUUsQ0FDM0MsTUFBTSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7QUFFdEQsUUFBQSxvQkFBb0IsR0FBRyxDQUNsQyxLQUFZLEVBQ1osT0FBZSxFQUNhLEVBQUU7SUFDOUIsTUFBTSxRQUFRLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxZQUF3QixDQUFDO0lBQ3JELE1BQU0sVUFBVSxHQUFHLFFBQVEsQ0FBQyxTQUF5QyxDQUFDO0lBQ3RFLE1BQU0scUJBQXFCLEdBQUcsVUFBVSxDQUFDLElBQUksQ0FDM0MsQ0FBQyxTQUFTLEVBQUUsRUFBRSxDQUFDLFNBQVMsQ0FBQyxPQUFPLEtBQUssT0FBTyxDQUM3QyxDQUFDO0lBQ0YsSUFBSSxxQkFBcUIsS0FBSyxTQUFTLEVBQUU7UUFDdkMsTUFBTSxJQUFJLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0tBQzVDO0lBQ0QsT0FBTyxxQkFBcUIsQ0FBQztBQUMvQixDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjcnlwdG8gZnJvbSAnY3J5cHRvJztcbmltcG9ydCB7IFRhYmxlLCBDZm5UYWJsZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1keW5hbW9kYic7XG5cbmV4cG9ydCBjb25zdCBoYXNoID0gKGNvZGU6IHN0cmluZyk6IHN0cmluZyA9PlxuICBjcnlwdG8uY3JlYXRlSGFzaCgnbWQ1JykudXBkYXRlKGNvZGUpLmRpZ2VzdCgnaGV4Jykuc3Vic3RyKDAsIDYpO1xuXG5leHBvcnQgY29uc3QgZ2V0S2V5U2NoZW1hUHJvcGVydHkgPSAoXG4gIHRhYmxlOiBUYWJsZSxcbiAga2V5VHlwZTogc3RyaW5nLFxuKTogQ2ZuVGFibGUuS2V5U2NoZW1hUHJvcGVydHkgPT4ge1xuICBjb25zdCBjZm5UYWJsZSA9IHRhYmxlLm5vZGUuZGVmYXVsdENoaWxkIGFzIENmblRhYmxlO1xuICBjb25zdCBrZXlTY2hlbWFzID0gY2ZuVGFibGUua2V5U2NoZW1hIGFzIENmblRhYmxlLktleVNjaGVtYVByb3BlcnR5W107XG4gIGNvbnN0IHBhcnRpdGlvbktleUF0dHJpYnV0ZSA9IGtleVNjaGVtYXMuZmluZChcbiAgICAoa2V5U2NoZW1hKSA9PiBrZXlTY2hlbWEua2V5VHlwZSA9PT0ga2V5VHlwZSxcbiAgKTtcbiAgaWYgKHBhcnRpdGlvbktleUF0dHJpYnV0ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdQYXJ0aXRpb25LZXkgaXMgbm90IHNldCcpO1xuICB9XG4gIHJldHVybiBwYXJ0aXRpb25LZXlBdHRyaWJ1dGU7XG59O1xuIl19