import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "rayou.cdk-url-shortener",
    "version": "0.1.2",
    "description": "Deploy a URL shortener with custom domain support in just a few lines of code.",
    "license": "Apache-2.0",
    "url": "https://github.com/rayou/cdk-url-shortener.git",
    "long_description_content_type": "text/markdown",
    "author": "Ray Ou<yuhung.ou@live.com>",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/rayou/cdk-url-shortener.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "rayou.cdk_url_shortener",
        "rayou.cdk_url_shortener._jsii"
    ],
    "package_data": {
        "rayou.cdk_url_shortener._jsii": [
            "cdk-url-shortener@0.1.2.jsii.tgz"
        ],
        "rayou.cdk_url_shortener": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "aws-cdk.aws-apigateway>=1.61.0, <2.0.0",
        "aws-cdk.aws-certificatemanager>=1.61.0, <2.0.0",
        "aws-cdk.aws-dynamodb>=1.61.0, <2.0.0",
        "aws-cdk.aws-iam>=1.61.0, <2.0.0",
        "aws-cdk.aws-lambda-event-sources>=1.61.0, <2.0.0",
        "aws-cdk.aws-lambda>=1.61.0, <2.0.0",
        "aws-cdk.aws-route53-targets>=1.61.0, <2.0.0",
        "aws-cdk.aws-route53>=1.61.0, <2.0.0",
        "aws-cdk.core>=1.61.0, <2.0.0",
        "constructs>=3.0.4, <4.0.0",
        "jsii>=1.12.0, <2.0.0",
        "publication>=0.0.3"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Typing :: Typed",
        "Development Status :: 4 - Beta",
        "License :: OSI Approved"
    ]
}
"""
)

with open("README.md") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
