"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.awsCredentialStep = void 0;
function awsCredentialStep(stepName, props) {
    const params = {};
    params['aws-region'] = props.region;
    params['role-duration-seconds'] = 30 * 60;
    // Session tagging requires the role to have `sts:TagSession` permissions,
    // which CDK bootstrapped roles do not currently have.
    params['role-skip-session-tagging'] = props.roleSkipSessionTagging ?? true;
    params['aws-access-key-id'] = props.accessKeyId;
    params['aws-secret-access-key'] = props.secretAccessKey;
    if (props.sessionToken) {
        params['aws-session-token'] = props.sessionToken;
    }
    if (props.roleToAssume) {
        params['role-to-assume'] = props.roleToAssume;
    }
    if (props.roleExternalId) {
        params['role-external-id'] = props.roleExternalId;
    }
    return {
        name: stepName,
        uses: 'aws-actions/configure-aws-credentials@v1',
        with: params,
    };
}
exports.awsCredentialStep = awsCredentialStep;
//# sourceMappingURL=data:application/json;base64,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