This is a library for working with IPFS in Python. It includes a programmer-friendly wrapper (IPFS-API) for the official IPFS Python API (ipfshttpclient). It also includes a module (IPFS-DataTransmission) for direct P2P data transmission between two IPFS-Nodes.

## Package Contents:
# Modules:
- IPFS_API: a wrapper for the module ipfshttpclient2 that makes it easier to work with IPFS in Python
- IPFS_DataTransmission: a Python module that enables P2P data transmission between IPFS nodes
- IPFS_LNS: a Python module that allows IPFS nodes and their multiaddresses to be stored in app data to make them easier to find in the IP layer of the internet (easier to connect to)
- ipfshttpclient2: a modified version of the official ipfshttpclient module that has been expanded to include the ipfs.p2p functions
# Other:
- Examples: a folder of scripts demonstrating how to work with IPFS_DataTransmission
- Prerequisites.txt: a set of instructions for installing and configuring all the prerequisite software tools needed for using this module (IPFS and Python)
- HowItWorks.txt: provides a conceptual overview of how this module works, explaining the understanding needed to use the module properly and giving some technical details about how this module interacts with IPFS


## Getting started with IPFS-DataTransmission:
1. Read HowItWorks.md in order to understand the basic concepts involved.
2. Read and try out the demo scripts in the Examples folder.
3. Reread HowItWorks.md to complete your understanding of how IPFS-DataTransmission works.
