"""Credenciales oficiales de prueba de SUNAT para tests de integración.

Estas son las credenciales públicas y documentadas por SUNAT para testing.
Ver: https://cpe.sunat.gob.pe/node/88
"""

import os

# Credenciales oficiales de prueba de SUNAT
SUNAT_TEST_CREDENTIALS = {
    "ruc": "20000000001",
    "usuario": "20000000001MODDATOS", 
    "password": "moddatos",
    "es_test": True
}

# Certificado de prueba oficial (público, para testing únicamente)
# Este certificado está expirado y es solo para pruebas
SUNAT_TEST_CERTIFICATE_PEM = """-----BEGIN RSA PRIVATE KEY-----
MIIEowIBAAKCAQEA7bXTMjOSElQ9VM/gRwD68VSejdXmaJ34NwzL2VU9GcuuPqnF
4/M7hwupaJQ7Hxpw/C1Lba2kO6gi/mxyqbPoYwIQkXceVnJ+Ig65RacRS+yDZ6+r
3pM7AkOOQT1K75LBfRSmu8l+IkgwbrZj36E9eID5yLknvGOVHhnui5OrBdFoB8i/
iZsTrt++yroWodqV2dfs+1eCSJTYHpibSpaq74BnrhPU2oHxh1C/QbmSuX1Mf0Ug
1I6sVHilN337fXxiAGZdHXborQtjrb+Ha9YMS61JiPmWe+RZrXykE+0pkvdkFSNg
eVgD5S9W5274ZGYssO5xRPkP8BidpshOESBY3QIDAQABAoIBAE5f7MpYhojUjYQx
JdlDUXnQVJafN+C2dOhxp6R4njSrG0A96alGwRG9npWEihmvNiFvLbdz0Pp6bU9F
omihkLVUMPJFPBN0nHHOOPfmJaXKzWiaWyh/kq0kaPrJorNqx7Dd5jt0K8pR0uYt
7LAHEaVxoOm1YoySqM/L7QLIJVM9HUj31FZEXsDO68C13c6C35cPkU1tP6PfIouA
pQuDA1TvkFCo8RqIBUIxcj/yKvjQgnbeNqDwzz5St+2m4wSUw+8EprwJivx/WEjr
k/c1AVZV2Yx1HP/zf/3IaC7c6IWnKxpvPQgwzJ6/SoHKXKcb3Y7yhe3xJTfRj8v4
u1hJHgECgYEA+bfDvxEymR3wO08eEgvFfnr/XmziKwWTYHV+pkNvgVVCOvfJgOZn
9RMzYxHAo61NNpZ5OidEGZZ9jenuy9hK8K5kTqnaRMlFJ/80nq6S04dODsOJFEzq
8YFmTI7/G502FN/FHPUGV0wmxBDI1Zt5LNlb5KFLBxeniE9CFV+y3o0CgYEA87C6
obaTQn1wQ+PZEticFIESRf2m8gYTrxNPyRh/OgAAgXFGnFL2cj0QIhIow1Gev9tU
adywFIF89b8elHMm6n+vVyO1lC31kPr77GcYqMHSk+5+tU32Fx7QOp6+k8Iy2Lb/
xlHTv/AvOpXzlt9h5vn5/bTASiMkgYPHuOsAN5ECgYAbgrc58XcVj0rL/edeLZXQ
XVSM3on8G10lH0yYnI1IPlBRlsLIRJnnUfozS91hKtJ61RD96x2BhCbI36DDLEz1
PwEl+Whmc5X+1grCAJGEZD+hOMF9TwwDFzJh9M7+B8/RdOWOTyAntef/aan2fm5X
FosdIPfXDDAUwEaTfDuEcQKBgQDm/QkbCj2x08cbgxkbBRmFUgcpMtMRLHNyC2Mg
YckPCDtydxYQTY9vH7RwJzheU7qfb14nblm1RjxVkJCC9FfaBagFeELAr4PKpi0v
m1XDeN2K/ZE7eCehKMMGHbzVwEmEJIpzyNJnaFrMNKENzLY3Q5IUS0XNwFv1LB2f
iZnOEQKBgFEu9v61M2ekBJAsJ/U/3siOCRDN2B4PEbEaQX9m8Cc6xDP5PnQTwy0D
MY85r37CK7vSp35sBaYdmMBgrwBfQiO8Oj7NaECdcM+wyvvZbC0EVYk9CykIJyxK
h40CmyxXxzwZcDhgoMqkmuvvo/iN12P+kt3J6cuWbr3Xl8ORLTYw
-----END RSA PRIVATE KEY-----
-----BEGIN CERTIFICATE-----
MIIEVDCCAzygAwIBAgIJAPTrkMJbCOr1MA0GCSqGSIb3DQEBBQUAMHkxCzAJBgNV
BAYTAlVTMQ4wDAYDVQQIEwVNYWluZTESMBAGA1UEBxMJTGltaW5ndG9uMR8wHQYD
VQQKExZ4bWxzZWNsaWJzLnBocCBMaWJyYXJ5MSUwIwYDVQQDExx4bWxzZWNsaWJz
L3d3dy5jZGF0YXpvbmUub3JnMB4XDTA4MDcwNzIwMjIzMVoXDTE4MDcwNTIwMjIz
MVoweTELMAkGA1UEBhMCVVMxDjAMBgNVBAgTBU1haW5lMRIwEAYDVQQHEwlMaW1p
bmd0b24xHzAdBgNVBAoTFnhtbHNlY2xpYnMucGhwIExpYnJhcnkxJTAjBgNVBAMT
HHhtbHNlY2xpYnMvd3d3LmNkYXRhem9uZS5vcmcwggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDttdMyM5ISVD1Uz+BHAPrxVJ6N1eZonfg3DMvZVT0Zy64+
qcXj8zuHC6lolDsfGnD8LUttraQ7qCL+bHKps+hjAhCRdx5Wcn4iDrlFpxFL7INn
r6vekzsCQ45BPUrvksF9FKa7yX4iSDButmPfoT14gPnIuSe8Y5UeGe6Lk6sF0WgH
yL+JmxOu377Kuhah2pXZ1+z7V4JIlNgemJtKlqrvgGeuE9TagfGHUL9BuZK5fUx/
RSDUjqxUeKU3fft9fGIAZl0dduitC2Otv4dr1gxLrUmI+ZZ75FmtfKQT7SmS92QV
I2B5WAPlL1bnbvhkZiyw7nFE+Q/wGJ2myE4RIFjdAgMBAAGjgd4wgdswHQYDVR0O
BBYEFEC5iG0uGXLpQG/zMj/4TuDWfTpHMIGrBgNVHSMEgaMwgaCAFEC5iG0uGXLp
QG/zMj/4TuDWfTpHoX2kezB5MQswCQYDVQQGEwJVUzEOMAwGA1UECBMFTWFpbmUx
EjAQBgNVBAcTCUxpbWluZ3RvbjEfMB0GA1UEChMWeG1sc2VjbGlicy5waHAgTGli
cmFyeTElMCMGA1UEAxMceG1sc2VjbGlicy93d3cuY2RhdGF6b25lLm9yZ4IJAPTr
kMJbCOr1MAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBACmSKrte07Vr
GB8dtrN5mrt28ILickQjguu46h6vChgQ4YfIAoA1KWNsZJUuuIzTDjE5xz2hsW37
CI0yrNesv2ho2hhP+fIaxCGmcwLYXL80UaPRglYk5+wPWFOt3QFAVoEgwjLX9+y+
c2Gu7xLgHAFZVRjQ5hhKT0Nj3vhnt0k8LcognNl1wKuWda7VL4tODp/2IOXr5o5v
/OL3UesGfeWfvr8LVmMc5f7/vLAu1+2Yk+/C9/EZyf3BDZQ4z8ae/iwqprCTUIEj
hUDcq4+0YN2EIw6suGE2FtWlsIywNErmoOhdrmntU61n3nFCQBi7QDUnZrAFrl4/
bmk3eRJ00nE=
-----END CERTIFICATE-----"""


def get_test_credentials():
    """
    Obtiene credenciales de prueba con soporte para variables de entorno.
    
    Prioridad:
    1. Variables de entorno (para personalización)  
    2. Credenciales hardcodeadas de SUNAT (por defecto)
    
    Returns:
        dict: Credenciales para testing
    """
    return {
        "ruc": os.getenv("SUNAT_TEST_RUC", SUNAT_TEST_CREDENTIALS["ruc"]),
        "usuario": os.getenv("SUNAT_TEST_USER", SUNAT_TEST_CREDENTIALS["usuario"]),
        "password": os.getenv("SUNAT_TEST_PASSWORD", SUNAT_TEST_CREDENTIALS["password"]),
        "certificado": os.getenv("SUNAT_TEST_CERT", SUNAT_TEST_CERTIFICATE_PEM),
        "es_test": os.getenv("SUNAT_TEST_PRODUCTION", "false").lower() != "true"
    }