"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduledFargateTask = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const aws_events_targets_1 = require("@aws-cdk/aws-events-targets");
const scheduled_task_base_1 = require("../base/scheduled-task-base");
/**
 * A scheduled Fargate task that will be initiated off of CloudWatch Events.
 *
 * @stability stable
 */
class ScheduledFargateTask extends scheduled_task_base_1.ScheduledTaskBase {
    /**
     * Constructs a new instance of the ScheduledFargateTask class.
     *
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        if (props.scheduledFargateTaskDefinitionOptions && props.scheduledFargateTaskImageOptions) {
            throw new Error('You must specify either a scheduledFargateTaskDefinitionOptions or scheduledFargateTaskOptions, not both.');
        }
        else if (props.scheduledFargateTaskDefinitionOptions) {
            this.taskDefinition = props.scheduledFargateTaskDefinitionOptions.taskDefinition;
        }
        else if (props.scheduledFargateTaskImageOptions) {
            const taskImageOptions = props.scheduledFargateTaskImageOptions;
            this.taskDefinition = new aws_ecs_1.FargateTaskDefinition(this, 'ScheduledTaskDef', {
                memoryLimitMiB: taskImageOptions.memoryLimitMiB || 512,
                cpu: taskImageOptions.cpu || 256,
            });
            this.taskDefinition.addContainer('ScheduledContainer', {
                image: taskImageOptions.image,
                command: taskImageOptions.command,
                environment: taskImageOptions.environment,
                secrets: taskImageOptions.secrets,
                logging: (_b = taskImageOptions.logDriver) !== null && _b !== void 0 ? _b : this.createAWSLogDriver(this.node.id),
            });
        }
        else {
            throw new Error('You must specify one of: taskDefinition or image');
        }
        // Use the EcsTask as the target of the EventRule
        const eventRuleTarget = new aws_events_targets_1.EcsTask({
            cluster: this.cluster,
            taskDefinition: this.taskDefinition,
            taskCount: this.desiredTaskCount,
            subnetSelection: this.subnetSelection,
            platformVersion: props.platformVersion,
        });
        this.addTaskAsTarget(eventRuleTarget);
    }
}
exports.ScheduledFargateTask = ScheduledFargateTask;
_a = JSII_RTTI_SYMBOL_1;
ScheduledFargateTask[_a] = { fqn: "@aws-cdk/aws-ecs-patterns.ScheduledFargateTask", version: "1.107.0" };
//# sourceMappingURL=data:application/json;base64,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