# codat-bankfeeds

<!-- Start SDK Installation -->
## SDK Installation

```bash
pip install codat-bankfeeds
```
<!-- End SDK Installation -->

## SDK Example Usage
<!-- Start SDK Example Usage -->
```python
import codat
from codat.models import operations, shared

s = codat.Codat(
    security=shared.Security(
        auth_header="YOUR_API_KEY_HERE",
    ),
)


req = operations.CreateBankFeedRequest(
    request_body=[
        shared.BankFeedAccount(
            account_name="provident",
            account_number="distinctio",
            account_type="quibusdam",
            balance=6027.63,
            currency="nulla",
            feed_start_date="2022-10-23T00:00:00Z",
            id="corrupti",
            modified_date="2022-10-23T00:00:00Z",
            sort_code="illum",
            status="vel",
        ),
        shared.BankFeedAccount(
            account_name="error",
            account_number="deserunt",
            account_type="suscipit",
            balance=4375.87,
            currency="magnam",
            feed_start_date="2022-10-23T00:00:00Z",
            id="debitis",
            modified_date="2022-10-23T00:00:00Z",
            sort_code="ipsa",
            status="delectus",
        ),
        shared.BankFeedAccount(
            account_name="tempora",
            account_number="suscipit",
            account_type="molestiae",
            balance=7917.25,
            currency="placeat",
            feed_start_date="2022-10-23T00:00:00Z",
            id="voluptatum",
            modified_date="2022-10-23T00:00:00Z",
            sort_code="iusto",
            status="excepturi",
        ),
    ],
    company_id="8a210b68-6988-11ed-a1eb-0242ac120002",
    connection_id="2e9d2c44-f675-40ba-8049-353bfcb5e171",
)
    
res = s.create_bank_feed(req)

if res.bank_feed_accounts is not None:
    # handle response
```
<!-- End SDK Example Usage -->

<!-- Start SDK Available Operations -->
## Available Resources and Operations

### Codat SDK

* `create_bank_feed` - Create bank feed bank accounts
* `create_bank_transactions` - Create bank transactions
* `get_bank_feeds` - List bank feed bank accounts
* `get_create_bank_account_model` - List push options for bank account bank transactions
* `list_bank_account_transactions` - List bank transactions for bank account
* `update_bank_feed` - Update bank feed bank account
<!-- End SDK Available Operations -->

### SDK Generated by [Speakeasy](https://docs.speakeasyapi.dev/docs/using-speakeasy/client-sdks)
