"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackApprovalAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_apigateway_1 = require("@aws-cdk/aws-apigateway");
const aws_codepipeline_1 = require("@aws-cdk/aws-codepipeline");
const aws_codepipeline_actions_1 = require("@aws-cdk/aws-codepipeline-actions");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const aws_sns_1 = require("@aws-cdk/aws-sns");
const aws_sns_subscriptions_1 = require("@aws-cdk/aws-sns-subscriptions");
const channel_types_1 = require("./channel-types");
class SlackApprovalAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.APPROVAL,
            provider: 'Manual',
            artifactBounds: {
                minInputs: 0,
                maxInputs: 0,
                minOutputs: 0,
                maxOutputs: 0,
            },
        });
        this.props = props;
        this.props = props;
    }
    /**
     * This is a renamed version of the {@link IAction.bind} method.
     */
    bound(scope, stage, options) {
        const environment = {
            SLACK_BOT_TOKEN: this.props.slackBotToken,
            SLACK_SIGNING_SECRET: this.props.slackSigningSecret,
            SLACK_CHANNEL: this.props.slackChannel,
            SLACK_CHANNEL_ID: this.props.slackChannelId,
            SLACK_CHANNEL_TYPES: (this.props.slackChannelTypes || [channel_types_1.ChannelTypes.PUBLIC]).join(','),
            SLACK_BOT_NAME: this.props.slackBotName || 'buildbot',
            SLACK_BOT_ICON: this.props.slackBotIcon || ':robot_face:',
        };
        const approvalRequester = new aws_lambda_1.Function(scope, 'SlackApprovalRequesterFunction', {
            runtime: aws_lambda_1.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'approval-requester')),
            environment,
        });
        const topic = new aws_sns_1.Topic(scope, 'SlackApprovalTopic');
        topic.grantPublish(options.role);
        topic.addSubscription(new aws_sns_subscriptions_1.LambdaSubscription(approvalRequester));
        const approvalHandler = new aws_lambda_1.Function(scope, 'SlackApprovalHandlerFunction', {
            runtime: aws_lambda_1.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'approval-handler')),
            environment,
        });
        const api = new aws_apigateway_1.RestApi(scope, 'SlackApprovalApi');
        api.root.addProxy({
            defaultIntegration: new aws_apigateway_1.LambdaIntegration(approvalHandler),
        });
        approvalHandler.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: ['codepipeline:PutApprovalResult'],
            resources: [`${stage.pipeline.pipelineArn}/${stage.stageName}/${this.props.actionName}`],
        }));
        return {
            configuration: {
                NotificationArn: topic.topicArn,
                CustomData: this.props.additionalInformation,
                ExternalEntityLink: this.props.externalEntityLink,
            },
        };
    }
}
exports.SlackApprovalAction = SlackApprovalAction;
_a = JSII_RTTI_SYMBOL_1;
SlackApprovalAction[_a] = { fqn: "@cloudcomponents/cdk-codepipeline-slack.SlackApprovalAction", version: "1.41.0" };
//# sourceMappingURL=data:application/json;base64,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