HTML_SANITIZERS = {
    "borrower": {
        "tags": {
            "h1",
            "h2",
            "h3",
            "strong",
            "em",
            "p",
            "ul",
            "ol",
            "li",
            "br",
            "sub",
            "sup",
            "hr",
            "colgroup",
            "col",
            "table",
            "div",
            "thead",
            "tr",
            "th",
            "tbody",
            "td",
        },
        "attributes": {
            "table": ("style",),
            "div": ("class",),
        },
        "empty": {"hr", "br"},
        "separate": {"p", "li", "th", "td", "tr"},
        "whitespace": {"br"},
    }
}

HTML_SANITIZER_CUSTOM_SETTINGS = {
    "tags": (
        "h1",
        "h2",
        "h3",
        "a",
        "strong",
        "em",
        "p",
        "ul",
        "ol",
        "li",
        "br",
        "hr",
        "h4",
        "table",
        "colgroup",
        "col",
        "thead",
        "tr",
        "th",
        "tbody",
        "td",
        "div",
    ),
    "attributes": {
        "a": ("href", "name", "target", "title", "id", "rel", "style"),
        "table": ("style",),
        "div": ("class",),
        "col": ("span", "style"),
    },
    "empty": {"hr", "br", "col"},
    "separate": {"p", "li", "th", "td", "tr"},
    "whitespace": {"br"},
}
