"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirewallDomainList = exports.FirewallDomains = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_s3_assets_1 = require("@aws-cdk/aws-s3-assets");
const core_1 = require("@aws-cdk/core");
const route53resolver_generated_1 = require("./route53resolver.generated");
/**
 * (experimental) A list of domains.
 *
 * @experimental
 */
class FirewallDomains {
    /**
     * (experimental) Firewall domains created from a list of domains.
     *
     * @param list the list of domains.
     * @experimental
     */
    static fromList(list) {
        for (const domain of list) {
            if (!/^[\w-.]+$/.test(domain)) {
                throw new Error(`Invalid domain: ${domain}. Valid characters: A-Z, a-z, 0-9, _, -, .`);
            }
        }
        return {
            bind(_scope) {
                return { domains: list };
            },
        };
    }
    /**
     * (experimental) Firewall domains created from the URL of a file stored in Amazon S3.
     *
     * The file must be a text file and must contain a single domain per line.
     * The content type of the S3 object must be `plain/text`.
     *
     * @param url S3 bucket url (s3://bucket/prefix/objet).
     * @experimental
     */
    static fromS3Url(url) {
        if (!core_1.Token.isUnresolved(url) && !url.startsWith('s3://')) {
            throw new Error(`The S3 URL must start with s3://, got ${url}`);
        }
        return {
            bind(_scope) {
                return { domainFileUrl: url };
            },
        };
    }
    /**
     * (experimental) Firewall domains created from a file stored in Amazon S3.
     *
     * The file must be a text file and must contain a single domain per line.
     * The content type of the S3 object must be `plain/text`.
     *
     * @param bucket S3 bucket.
     * @param key S3 key.
     * @experimental
     */
    static fromS3(bucket, key) {
        return this.fromS3Url(bucket.s3UrlForObject(key));
    }
    /**
     * (experimental) Firewall domains created from a local disk path to a text file.
     *
     * The file must be a text file (`.txt` extension) and must contain a single
     * domain per line. It will be uploaded to S3.
     *
     * @param assetPath path to the text file.
     * @experimental
     */
    static fromAsset(assetPath) {
        // cdk-assets will correctly set the content type for the S3 object
        // if the file has the correct extension
        if (path.extname(assetPath) !== '.txt') {
            throw new Error(`FirewallDomains.fromAsset() expects a file with the .txt extension, got ${assetPath}`);
        }
        return {
            bind(scope) {
                const asset = new aws_s3_assets_1.Asset(scope, 'Domains', { path: assetPath });
                if (!asset.isFile) {
                    throw new Error('FirewallDomains.fromAsset() expects a file');
                }
                return { domainFileUrl: asset.s3ObjectUrl };
            },
        };
    }
}
exports.FirewallDomains = FirewallDomains;
_a = JSII_RTTI_SYMBOL_1;
FirewallDomains[_a] = { fqn: "@aws-cdk/aws-route53resolver.FirewallDomains", version: "1.121.0" };
/**
 * (experimental) A Firewall Domain List.
 *
 * @experimental
 */
class FirewallDomainList extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props.name && !core_1.Token.isUnresolved(props.name) && !/^[\w-.]{1,128}$/.test(props.name)) {
            throw new Error(`Invalid domain list name: ${props.name}. The name must have 1-128 characters. Valid characters: A-Z, a-z, 0-9, _, -, .`);
        }
        const domainsConfig = props.domains.bind(this);
        const domainList = new route53resolver_generated_1.CfnFirewallDomainList(this, 'Resource', {
            name: props.name,
            domainFileUrl: domainsConfig.domainFileUrl,
            domains: domainsConfig.domains,
        });
        this.firewallDomainListId = domainList.attrId;
        this.firewallDomainListArn = domainList.attrArn;
        this.firewallDomainListCreationTime = domainList.attrCreationTime;
        this.firewallDomainListCreatorRequestId = domainList.attrCreatorRequestId;
        this.firewallDomainListDomainCount = domainList.attrDomainCount;
        this.firewallDomainListManagedOwnerName = domainList.attrManagedOwnerName;
        this.firewallDomainListModificationTime = domainList.attrModificationTime;
        this.firewallDomainListStatus = domainList.attrStatus;
        this.firewallDomainListStatusMessage = domainList.attrStatusMessage;
    }
    /**
     * (experimental) Import an existing Firewall Rule Group.
     *
     * @experimental
     */
    static fromFirewallDomainListId(scope, id, firewallDomainListId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.firewallDomainListId = firewallDomainListId;
            }
        }
        return new Import(scope, id);
    }
}
exports.FirewallDomainList = FirewallDomainList;
_b = JSII_RTTI_SYMBOL_1;
FirewallDomainList[_b] = { fqn: "@aws-cdk/aws-route53resolver.FirewallDomainList", version: "1.121.0" };
//# sourceMappingURL=data:application/json;base64,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