# SeleniumProxy

![Twitter URL](https://img.shields.io/twitter/url?style=social&url=https%3A%2F%2Ftwitter.com%2Fteaglebuilt)
![GitHub stars](https://img.shields.io/github/stars/teaglebuilt/robotframework-seleniumproxy?style=social)
![GitHub watchers](https://img.shields.io/github/watchers/teaglebuilt/robotframework-seleniumproxy?style=social)
![GitHub followers](https://img.shields.io/github/followers/teaglebuilt?style=social)

![Build](https://github.com/teaglebuilt/robotframework-seleniumproxy/workflows/Python%20package/badge.svg)
![PyPI - Version](https://img.shields.io/pypi/v/robotframework-seleniumproxy)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/robotframework-seleniumproxy)

A library for RobotFramework that extends [SeleniumLibrary](https://github.com/robotframework/SeleniumLibrary).

Project documentation and usage - [Keyword Documentation](https://teaglebuilt.github.io/robotframework-seleniumproxy/)

# What is it

SeleniumProxy inherits seleniums webdriver and captures all network activity generated by the webdriver. The webdriver stores data in a class with added keywords to interact with requests and responses.

Proxy Server is launched in the background with a proxy client added to the webdriver class that adds the methods needed to interact with the proxy server at run time.

[Pypi](https://pypi.org/project/robotframework-seleniumproxy/0.0.2/)

```

pip install robotframework-seleniumproxy

```

# How it works.

[Proxy2](https://github.com/inaz2/proxy2) runs the proxy server
[OpenSSL](https://github.com/inaz2/proxy2)

OpenSSL is required for intercepting HTTPS connections.

```
brew install openssl
```

Seleniums webdriver browser type is a class which is inherited and extended to give the webdriver the ability to create a client proxy and store the activity within the webdriver.

Robotframeworks seleniumlibrary is extended to add several keywords for creating the webdriver with the given functionality and still capable of using the keywords available

# CREDITS

Credits of code or ideas I have used in this project.

[Jani Mikkonen](http://github.com/rasjani)

- Log wrapper Keyword Decorator
- Packaging Automation

[Will Keeling](https://github.com/wkeeling)

- Idea of Extending Selenium with Mixins to extend driver functionality
