# -*- coding: utf-8 -*-
"""
Created on Thu Jan 27 22:34:12 2022

@author: Will

A library of materials to be used by modelling functions 

"""
def custom_dielectric(mws, name, epsilon, mu, tanD, thermalConductivity):
    material = mws.Material
    material.Reset()
    material.name(name)
    material.FrqType('all')
    material.Type('Normal')
    material.MaterialUnit('Frequency', 'GHz')
    material.MaterialUnit('Geometry', 'mm')
    material.epsilon(str(epsilon))
    material.Mu(str(mu))
    material.Kappa('0.0')
    material.tanD(str(tanD))
    material.tanDFreq('10.0')
    material.tanDGiven('True')
    material.tanDModel('ConsttanD')
    material.KappaM('0.0')
    material.tanDM('0.0')
    material.tanDMFreq('0.0')
    material.tanDMGiven('False')
    material.tanDMModel('ConstKappa')
    material.DispModelEps('None')
    material.DispModelMu('None')
    material.DispersiveFittingSchemeEps('General 1st')
    material.DispersiveFittingSchemeMu('General 1st')
    material.UseGeneralDispersionEps('False')
    material.UseGeneralDispersionMu('False')
    material.Rho('0.0')
    material.ThermalType('Normal')
    material.thermalConductivity(str(thermalConductivity))
    material.ThermalType('Normal')
    material.SetActiveMaterial('all')
    material.Colour('0.94', '0.82', '0.76')
    material.Wireframe('False')
    material.Transparency('0')
    material.Create()
    format(material)

def air(mws):
    material = mws.Material
    material.Reset()
    material.Name('Air')
    material.FrqType('all')
    material.Type('Normal')
    material.MaterialUnit('Frequency', 'GHz')
    material.MaterialUnit('Geometry', 'mm')
    material.Epsilon('1.00059')
    material.Mu('1.0')
    material.Kappa('0.0')
    material.TanD('0.0')
    material.TanDFreq('0.0')
    material.TanDGiven('False')
    material.TanDModel('ConstKappa')
    material.KappaM('0')
    material.TanDM('0.0')
    material.TanDMFreq('0.0')
    material.TanDMGiven('False')
    material.TanDMModel('ConstKappa')
    material.DispModelEps('None')
    material.DispModelMu('None')
    material.DispersiveFittingSchemeEps('General 1st')
    material.DispersiveFittingSchemeMu('General 1st')
    material.UseGeneralDispersionEps('False')
    material.UseGeneralDispersionMu('False')
    material.Rho('1.204')
    material.ThermalType('Normal')
    material.ThermalConductivity('0.026')
    material.HeatCapacity('1.005')
    material.SetActiveMaterial('all')
    material.Colour('0.682353', '0.717647', '1')
    material.Wireframe('False')
    material.Transparency('0')
    material.Create()
    format(material)
    
def copper_annealed_lossy(mws):
    material = mws.Material
    material.Reset()
    material.Name('Copper (annealed)')
    material.FrqType('static')
    material.Type('Normal')
    material.SetMaterialUnit('Hz', 'mm')
    material.Epsilon('1')
    material.Mue('1.0')
    material.Kappa('5.8e+007')
    material.TanD('0')
    material.TanDFreq('0.0')
    material.TanDGiven('False')
    material.TanDModel('ConstTanD')
    material.KappaM('0.0')
    material.TanDM('0.0')
    material.TanDMFreq('0.0')
    material.TanDMGiven('False')
    material.TanDMModel('ConstTanD')
    material.DispModelEps('None')
    material.DispModelMue('None')
    material.DispersiveFittingSchemeEps('Nth Order')
    material.DispersiveFittingSchemeMue('Nth Order')
    material.UseGeneralDispersionEps('False')
    material.UseGeneralDispersionMue('False')
    material.FrqType('all')
    material.Type('Lossy metal')
    material.SetMaterialUnit('GHz', 'mm')
    material.Mue('1.0')
    material.Kappa('5.8e+007')
    material.Rho('8930.0')
    material.ThermalType('Normal')
    material.ThermalConductivity('401.0')
    material.HeatCapacity('0.39')
    material.MetabolicRate('0')
    material.BloodFlow('0')
    material.VoxelConvection('0')
    material.MechanicsType('Isotropic')
    material.YoungsModulus('120')
    material.PoissonsRatio('0.33')
    material.ThermalExpansionRate('17')
    material.Colour('1', '1', '0')
    material.Wireframe('False')
    material.Reflection('False')
    material.Allowoutline('True')
    material.Transparentoutline('False')
    material.Transparency('0')
    material.Create()
    format(material)
    
def copper_pure_lossy(mws):
    material = mws.Material

    material.Reset()
    material.Name('Copper (pure)')
    material.FrqType('all')  # warning
    material.Type('Lossy Metal')
    material.MaterialUnit('Frequency', 'GHz')
    material.MaterialUnit('Geometry', 'mm')
    material.MaterialUnit('Time', 's')
    material.MaterialUnit('Temperature', 'Kelvin')
    material.Mu('1.0')  # warning
    material.Sigma('5.96e+007')
    material.Rho('8930.0')
    material.ThermalType('Normal')
    material.ThermalConductivity('401.0')
    material.HeatCapacity('0.39')  # warning
    material.MetabolicRate('0')
    material.BloodFlow('0')
    material.VoxelConvection('0')
    material.MechanicsType('Isotropic')
    material.YoungsModulus('120')
    material.PoissonsRatio('0.33')
    material.ThermalExpansionRate('17')
    material.ReferenceCoordSystem('Global')
    material.CoordSystemType('Cartesian')
    material.NLAnisotropy('False')
    material.NLAStackingFactor('1')
    material.NLADirectionX('1')
    material.NLADirectionY('1')
    material.NLADirectionZ('1')
    material.ParticleProperty('SecondaryEmission')
    material.SeModel('Furman')
    material.SeVaughan('175', '2.25', '0', '1.0', '7.5')
    material.SePlot1D('True', '0', '100', '0', '1000')
    material.SeMaxSecondaries('10')
    material.SeTsParam_T1('0.66')
    material.SeTsParam_T2('0.80')
    material.SeTsParam_T3('0.70')
    material.SeTsParam_T4('1.00')
    material.SeTsParam_SEY('2.25')
    material.SeTsParam_Energy('175')
    material.SeTsParam_S('1.33')
    material.SeTsParam_PN('0', '1.6')
    material.SeTsParam_PN('1', '2.0')
    material.SeTsParam_PN('2', '1.8')
    material.SeTsParam_PN('3', '4.7')
    material.SeTsParam_PN('4', '1.8')
    material.SeTsParam_PN('5', '2.4')
    material.SeTsParam_PN('6', '1.8')
    material.SeTsParam_PN('7', '1.8')
    material.SeTsParam_PN('8', '2.3')
    material.SeTsParam_PN('9', '1.8')
    material.SeTsParam_EpsN('1', '6.20')
    material.SeTsParam_EpsN('2', '13.00')
    material.SeTsParam_EpsN('3', '8.80')
    material.SeTsParam_EpsN('4', '6.25')
    material.SeTsParam_EpsN('5', '2.25')
    material.SeTsParam_EpsN('6', '9.20')
    material.SeTsParam_EpsN('7', '5.30')
    material.SeTsParam_EpsN('8', '17.80')
    material.SeTsParam_EpsN('9', '10.00')
    material.SeRdParam_R('1.0')
    material.SeRdParam_R1('0.26')
    material.SeRdParam_R2('2.0')
    material.SeRdParam_Q('0.4')
    material.SeRdParam_P1Inf('0.01')
    material.SeRdParam_Energy('40.0')
    material.SeBsParam_Sigma('1.9')
    material.SeBsParam_E1('0.26')
    material.SeBsParam_E2('2.0')
    material.SeBsParam_P1Hat('0.02')
    material.SeBsParam_P1Inf('0.01')
    material.SeBsParam_Energy('0.0')
    material.SeBsParam_P('0.9')
    material.SeBsParam_W('100.0')
    material.FrqType('static')  # warning
    material.Type('Normal')
    material.MaterialUnit('Frequency', 'Hz')
    material.MaterialUnit('Geometry', 'mm')
    material.Epsilon('1')
    material.Mu('1.0')  # warning
    material.Kappa('5.96e+007')
    material.TanD('0')
    material.TanDFreq('0.0')
    material.TanDGiven('False')
    material.TanDModel('ConstTanD')
    material.KappaM('0.0')  # warning
    material.TanDM('0.0')
    material.TanDMFreq('0.0')
    material.TanDMGiven('False')
    material.TanDMModel('ConstTanD')
    material.DispModelEps('None')
    material.DispModelMu('None')
    material.DispersiveFittingSchemeEps('Nth Order')
    material.DispersiveFittingSchemeMu('Nth Order')
    material.UseGeneralDispersionEps('False')
    material.UseGeneralDispersionMu('False')
    material.Colour('1', '1', '0')
    material.Wireframe('False')
    material.Reflection('False')
    material.Allowoutline('True')
    material.Transparentoutline('False')
    material.Transparency('0')
    material.Create()
    format(material)

def fr4_lossy(mws):
    material = mws.material
    material.Reset()
    material.Name('FR-4 (lossy)')
    material.FrqType('all')
    material.Type('Normal')
    material.SetMaterialUnit('GHz', 'mm')
    material.Epsilon('4.3')
    material.Mue('1.0')
    material.Kappa('0.0')
    material.TanD('0.025')
    material.TanDFreq('10.0')
    material.TanDGiven('True')
    material.TanDModel('ConstTanD')
    material.KappaM('0.0')
    material.TanDM('0.0')
    material.TanDMFreq('0.0')
    material.TanDMModel('ConstKappa')
    material.DispModelEps('None')
    material.DispModelMue('None')
    material.DispersiveFittingSchemeEps('General 1st')
    material.DispersiveFittingSchemeMue('General 1st')
    material.UseGeneralDispersionEps('False')
    material.UseGeneralDispersionMue('False')
    material.Rho('0.0')
    material.ThermalType('Normal')
    material.ThermalConductivity('0.3')
    material.SetActiveMaterial('all')
    material.Colour('0.94', '0.82', '0.76')
    material.Wireframe('False')
    material.Transparency('0')
    material.Create()
    format(material)
