# openapi-client
Welcome to the IDX API.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v2
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python &gt;&#x3D;3.7

## Migration from other generators like python and python-legacy

### Changes
1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO
    - This means that you can use isinstance to check if a payload validated against a schema class
    - This means that no data will be of type None/True/False
        - ingested None will subclass NoneClass
        - ingested True will subclass BoolClass
        - ingested False will subclass BoolClass
        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()
5. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg
    - type number + format: See .as_float_oapg, .as_int_oapg
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg
    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg
7. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
    - Use get_item_oapg if you need a way to always get a value whether or not the key exists
        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg('optionalProp')
        - All required and optional keys have type hints for this method, and @typing.overload is used
        - A type hint is also generated for additionalProperties accessed using this method
    - So you will need to update you code to use some_instance['optionalProp'] to access optional property
    and additionalProperty values
8. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Oapg and _oapg used in class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions
on protected + public classes/methods.
oapg stands for OpenApi Python Generator.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the camelCase spec named variable.
Also it is possible to send in two properties, named camelCase and camel_case in the same payload.
That use case should be support so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[Unset, Schema]
headers: typing.Union[Unset, TODO]
Note: response header deserialization has not yet been added


## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import openapi_client
from pprint import pprint
from openapi_client.apis.tags import account_creation_api
from openapi_client.model.create_user_dto import CreateUserDto
from openapi_client.model.create_user_response_dto import CreateUserResponseDto
from openapi_client.model.order_get_dto import OrderGetDto
from openapi_client.model.order_post_dto import OrderPostDto
# Defining the host is optional and defaults to https://api.idx.us
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.idx.us"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: OAuth
configuration = openapi_client.Configuration(
    host = "https://api.idx.us"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = account_creation_api.AccountCreationApi(api_client)
    authorization = "Authorization_example" # str | 
order_post_dto = OrderPostDto(
        member_id="member_id_example",
        purchase_details=dict(
            coupon_id="coupon_id_example",
            discount_coupon_id="discount_coupon_id_example",
        ),
        tracking_id="tracking_id_example",
    ) # OrderPostDto | Order object

    try:
        # Create a new order
        api_response = api_instance.create_order(authorizationorder_post_dto)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling AccountCreationApi->create_order: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.idx.us*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountCreationApi* | [**create_order**](docs/apis/tags/AccountCreationApi.md#create_order) | **post** /v1/order | Create a new order
*AccountCreationApi* | [**create_user**](docs/apis/tags/AccountCreationApi.md#create_user) | **post** /v1/user | Create a new user
*CyberscanApi* | [**v1_cyberscan_member_id_data_type_hash_delete**](docs/apis/tags/CyberscanApi.md#v1_cyberscan_member_id_data_type_hash_delete) | **delete** /v1/cyberscan/{memberId}/{dataType}/{hash} | Delete the given cyberscan item
*CyberscanApi* | [**v1_cyberscan_member_id_data_type_hash_exposures_get**](docs/apis/tags/CyberscanApi.md#v1_cyberscan_member_id_data_type_hash_exposures_get) | **get** /v1/cyberscan/{memberId}/{dataType}/{hash}/exposures | Get exposures for the given cyberscan item
*CyberscanApi* | [**v1_cyberscan_member_id_data_type_hash_put**](docs/apis/tags/CyberscanApi.md#v1_cyberscan_member_id_data_type_hash_put) | **put** /v1/cyberscan/{memberId}/{dataType}/{hash} | Create or update the given cyberscan item with no value
*CyberscanApi* | [**v1_cyberscan_member_id_get**](docs/apis/tags/CyberscanApi.md#v1_cyberscan_member_id_get) | **get** /v1/cyberscan/{memberId} | Get cyberscan data
*CyberscanApi* | [**v1_cyberscan_member_id_summary_get**](docs/apis/tags/CyberscanApi.md#v1_cyberscan_member_id_summary_get) | **get** /v1/cyberscan/{memberId}/summary | Get the cyberscan summary
*CyberscanApi* | [**v1_cyberscan_post**](docs/apis/tags/CyberscanApi.md#v1_cyberscan_post) | **post** /v1/cyberscan | Create a new cyberscan item
*MemberDeactivationApi* | [**member_cancel_subscription**](docs/apis/tags/MemberDeactivationApi.md#member_cancel_subscription) | **post** /v1/subscription/{memberId}/cancel | Cancel a Member Subscription
*MemberDeactivationApi* | [**member_deactivate_services**](docs/apis/tags/MemberDeactivationApi.md#member_deactivate_services) | **post** /v1/subscription/{memberId}/deactivate | Deactivate a Member&#x27;s services
*MemberInformationApi* | [**get_location_code**](docs/apis/tags/MemberInformationApi.md#get_location_code) | **get** /v1/member/{memberId}/locationcode | Get the LocationCode for a member
*MemberInformationApi* | [**get_member_subscription**](docs/apis/tags/MemberInformationApi.md#get_member_subscription) | **get** /v1/subscription/{memberId} | Get member subscription
*MemberInformationApi* | [**update_location_code**](docs/apis/tags/MemberInformationApi.md#update_location_code) | **patch** /v1/member/{memberId}/locationcode | Update a member&#x27;s LocationCode
*ProductActivationApi* | [**v1_activate_member_id_product_id_post**](docs/apis/tags/ProductActivationApi.md#v1_activate_member_id_product_id_post) | **post** /v1/activate/{memberId}/{productId} | Activate the given product

## Documentation For Models

 - [ActivatePostDto](docs/models/ActivatePostDto.md)
 - [CancelSubscriptionResponse](docs/models/CancelSubscriptionResponse.md)
 - [CreateUserDto](docs/models/CreateUserDto.md)
 - [CreateUserResponseDto](docs/models/CreateUserResponseDto.md)
 - [CyberScanExposuresGetDto](docs/models/CyberScanExposuresGetDto.md)
 - [CyberScanItemDto](docs/models/CyberScanItemDto.md)
 - [CyberscanGetDto](docs/models/CyberscanGetDto.md)
 - [CyberscanHashPutDto](docs/models/CyberscanHashPutDto.md)
 - [CyberscanPostDto](docs/models/CyberscanPostDto.md)
 - [CyberscanResponseDto](docs/models/CyberscanResponseDto.md)
 - [CyberscanSummaryGetDto](docs/models/CyberscanSummaryGetDto.md)
 - [LocationCodeGetDto](docs/models/LocationCodeGetDto.md)
 - [LocationCodePatchDto](docs/models/LocationCodePatchDto.md)
 - [MemberCancelPutDto](docs/models/MemberCancelPutDto.md)
 - [MemberSubscriptionGetDto](docs/models/MemberSubscriptionGetDto.md)
 - [OrderGetDto](docs/models/OrderGetDto.md)
 - [OrderPostDto](docs/models/OrderPostDto.md)

## Documentation For Authorization

 Authentication schemes defined for the API:
## OAuth

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **customer-api:order:create**: Create Orders
 - **customer-api:user:create**: Create Users
 - **customer-api:subscription:read**: Read subscriptions
 - **customer-api:subscription:update**: Update subscriptions
 - **customer-api:cyberscan:read**: Read cyberscan data
 - **customer-api:cyberscan:create**: Create cyberscan data
 - **customer-api:cyberscan:delete**: Delete cyberscan data
 - **customer-api:member-locationcode:update**: Update Location Code
 - **customer-api:member-locationcode:read**: Read Location Code


## Author

support@idx.us
support@idx.us
support@idx.us
support@idx.us
support@idx.us

## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in openapi_client.apis and openapi_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from openapi_client.apis.default_api import DefaultApi`
- `from openapi_client.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import openapi_client
from openapi_client.apis import *
from openapi_client.models import *
```
